/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.antc.snowflake;

import com.xforceplus.antc.snowflake.AntcSnowflakeConfig;
import com.xforceplus.antc.snowflake.AntcSnowflakeService;
import com.xforceplus.antc.snowflake.AntcSnowflakeWorker;
import java.net.InetAddress;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class AntcSnowflakeUtil {
    private static final Logger logger = LoggerFactory.getLogger(AntcSnowflakeUtil.class);
    @Autowired
    private Environment environment;
    @Autowired
    AntcSnowflakeConfig antcSnowflakeConfig;
    @Autowired
    AntcSnowflakeService snowflakeldCheckService;
    static AntcSnowflakeWorker snowflakeIdWorker = new AntcSnowflakeWorker(RandomUtils.nextInt((int)1, (int)1000) & 0x1F, RandomUtils.nextInt((int)1, (int)1000) & 0x1F);

    @PostConstruct
    public void init() {
        int workerId;
        Integer datacenterId = this.antcSnowflakeConfig.getAppId();
        if (null == datacenterId) {
            datacenterId = RandomUtils.nextInt((int)1, (int)31);
            logger.warn("##### AntcSnowflake\u5e94\u7528\u672a\u914d\u7f6e${antc.snowflake.appId}; datacenterId={} (\u968f\u673a\u751f\u6210)", (Object)datacenterId);
        } else {
            logger.info("##### AntcSnowflake\u5e94\u7528\u5df2\u914d\u7f6e${antc.snowflake.appId} datacenterId={}", (Object)datacenterId);
        }
        String ip = null;
        try {
            InetAddress ia = InetAddress.getLocalHost();
            ip = ia.getHostAddress();
            String localip = StringUtils.substringAfterLast((String)ip, (String)".");
            workerId = Integer.parseInt(localip);
        }
        catch (Exception e) {
            workerId = RandomUtils.nextInt((int)1, (int)31);
        }
        logger.info("##### \u521d\u59cb\u5316\u8be5\u8282\u70b9\u5206\u914d\u7684workerID={}\uff1b(workerID & 31)={}", (Object)workerId, (Object)(workerId & 0x1F));
        long checkWorkerId = workerId & 0x1F;
        long checkDatacenterId = datacenterId & 0x1F;
        if (this.antcSnowflakeConfig.getRemoteCheckFlag().booleanValue() && StringUtils.isNotBlank((CharSequence)this.antcSnowflakeConfig.getRemoteCheckUrl())) {
            try {
                for (int i = 1; i <= 35; ++i) {
                    if (this.snowflakeldCheckService.check(checkDatacenterId, checkWorkerId, ip)) {
                        this.snowflakeldCheckService.timer();
                    }
                    ++checkWorkerId;
                    logger.info("##### \u5206\u5e03\u5f0fID \u6570\u636e\u68c0\u6d4b[\u7b2c{}\u6b21], checkDatacenterId:{};checkWorkerId:{};ip:{}", new Object[]{i, checkDatacenterId, checkWorkerId &= 0x1FL, ip});
                }
            }
            catch (Exception e) {
                logger.error("##### \u5206\u5e03\u5f0fID \u6570\u636e\u68c0\u6d4b\u5f02\u5e38\uff1a", (Object)e.getMessage());
            }
        } else {
            logger.info("##### AntcSnowflake \u8fdc\u7a0b\u76d1\u6d4b\u670d\u52a1\u5df2\u5173\u95ed");
        }
        logger.info("##### \u68c0\u6d4b\u540e\u7684\u8be5\u8282\u70b9\u5206\u914d\u7684datacenterId={}\uff1b(workerID & 31)={}", (Object)checkDatacenterId, (Object)checkWorkerId);
        snowflakeIdWorker = new AntcSnowflakeWorker(checkWorkerId, checkDatacenterId);
        logger.info("##### snowflakeIdWorker IOC\u5b9e\u4f8b\uff1a{}", (Object)snowflakeIdWorker);
    }

    public static long nextId() {
        return snowflakeIdWorker.nextId();
    }

    public static long[] nextId(int size) {
        return snowflakeIdWorker.nextId(size);
    }

    static {
        logger.info("##### snowflakeIdWorker \u9759\u6001\u5b9e\u4f8b\uff1a{}", (Object)snowflakeIdWorker);
    }
}

