package com.xforceplus.antc.snowflake;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.*;

/**
 * Describe: ID 生成器 数据检测
 */
@Component
public class AntcSnowflakeService {
    private static final Logger logger = LoggerFactory.getLogger(AntcSnowflakeService.class);

    @Autowired
    AntcSnowflakeConfig antcSnowflakeConfig;


    static RestTemplate restTemplate = new RestTemplate();


    public boolean check(Long datacenterId, Long workerId, String ip) {
        try {
            // 0：可用，1：已被使用
            String url = antcSnowflakeConfig.getRemoteCheckUrl() + "/global/coop/coop-route/v1/id-generator/check?datacenterId={datacenterId}&workerId={workerId}&ip={ip}";
            Map<String, Object> params = new HashMap();
            params.put("datacenterId", datacenterId);
            params.put("workerId", workerId);
            params.put("ip", ip);
            String rs = restTemplate.getForObject(url, String.class, params);
            logger.info("###### 分布式ID 数据检测response： {}", rs);
            if ("0".equals(rs)) {
                heartbeatDatacenterId = datacenterId;
                heartbeatWorkerId = workerId;
                return true;
            }
            return false;
        } catch (Exception e) {
            logger.error("##### 分布式ID使用本身配置/随机生成数据，检测异常：{}", e.getMessage());
            return true;
        }
    }

    // 心跳数据
    static Long heartbeatDatacenterId = null;
    static Long heartbeatWorkerId = null;

    public void heartbeat() {
        try {
            if (null == heartbeatDatacenterId) {
                logger.warn("##### 分布式ID健康检查 无心跳数据不发送检测");
                return;
            }
            logger.info("##### 分布式ID健康检查:[heartbeatDatacenterId:{};heartbeatWorkerId:{};]", heartbeatDatacenterId, heartbeatWorkerId);
            String url = antcSnowflakeConfig.getRemoteCheckUrl() + "/global/coop/coop-route/v1/id-generator/heartbeat?datacenterId={datacenterId}&workerId={workerId}";
            Map<String, Object> params = new HashMap();
            params.put("datacenterId", heartbeatDatacenterId);
            params.put("workerId", heartbeatWorkerId);
            String rs = restTemplate.getForObject(url, String.class, params);
            logger.info("###### 分布式ID[datacenterId：{}; workerId：{}] 心跳结果response： {}", heartbeatDatacenterId, heartbeatWorkerId, rs);
        } catch (Exception e) {
            logger.error("##### 分布式ID[datacenterId：{}; workerId：{}] 心跳异常：{}", heartbeatDatacenterId, heartbeatWorkerId, e.getMessage());
        }
    }

    /**
     * 健康检查定时器
     */
    public void timer() {
        logger.info("##### 分布式ID 数据心跳检查启动");
        try {
            ScheduledExecutorService pool = (ScheduledExecutorService) Executors.newScheduledThreadPool(1);
            pool.scheduleAtFixedRate(new Runnable() {
                @Override
                public void run() {
                    heartbeat();
                }
            }, 60 * 60, 60 * 60, TimeUnit.SECONDS);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception{
        BlockingQueue<Runnable> workQueueL1 = new ArrayBlockingQueue<>(10);
        ThreadPoolExecutor customExecutorL1 = new ThreadPoolExecutor(1, 2,
                200, TimeUnit.SECONDS, workQueueL1, new ThreadPoolExecutor.CallerRunsPolicy());
        for (int i = 0; i <20 ; i++) {
            System.out.println(i);
            final int tag = i;
            customExecutorL1.submit(new Runnable() {
                @Override
                public void run() {
                    System.out.println("线程》》》"+tag);
                    try {
                        Thread.sleep(10000);
                    }catch (Exception e){}
                }
            });
        }

        System.out.println(workQueueL1.size());
    }


}