package com.xforceplus.phoenix.auth.client.api;

import java.io.File;
import java.util.List;
import com.xforceplus.phoenix.auth.client.model.MsAutCompanyLimitObj;
import com.xforceplus.phoenix.auth.client.model.MsAutCompanyLimitResponse;
import com.xforceplus.phoenix.auth.client.model.MsAuthLimitRequest;
import com.xforceplus.phoenix.auth.client.model.MsAuthResponse;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "authLimit", description = "the authLimit API")
public interface AuthLimitApi {

    @ApiOperation(value = "删除限额信息", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthLimit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authLimit/deleteAuthLimit",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse deleteAuthLimit(@ApiParam(value = "限额id集合" ,required=true ) @RequestBody List<Long> limitIds);


    @ApiOperation(value = "下载认证限额导入模板", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthLimit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "一般回复", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authLimit/downloadAuthLimitTemplate",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse downloadAuthLimitTemplate();


    @ApiOperation(value = "导入认证限额数据", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthLimit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authLimit/importAuthLimitData",
        produces = { "application/json" }, 
        consumes = { "multipart/form-data" },
        method = RequestMethod.POST)
     MsAuthResponse importAuthLimitData(@ApiParam(value = "file detail") @RequestPart("file") MultipartFile file);


    @ApiOperation(value = "新增限额信息", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthLimit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authLimit/insertAuthLimit",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse insertAuthLimit(@ApiParam(value = "request" ,required=true ) @RequestBody MsAutCompanyLimitObj request);


    @ApiOperation(value = "认证限额信息集合", notes = "", response = MsAutCompanyLimitResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthLimit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAutCompanyLimitResponse.class) })
    @RequestMapping(value = "/authLimit/listAuthLimits",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAutCompanyLimitResponse listAuthLimits(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthLimitRequest authLimitRequest);


    @ApiOperation(value = "编辑限额信息", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthLimit", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authLimit/updateAuthLimit",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse updateAuthLimit(@ApiParam(value = "request" ,required=true ) @RequestBody MsAutCompanyLimitObj request);

}
