package com.xforceplus.phoenix.auth.client.api;

import com.xforceplus.phoenix.auth.client.model.MsAuthResponse;
import com.xforceplus.phoenix.auth.client.model.MsExportInvoiceRequest;
import com.xforceplus.phoenix.auth.client.model.MsListUndeclaredCompanyRequest;
import com.xforceplus.phoenix.auth.client.model.MsListUndeclaredCompanyResponse;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthConfirmRequest;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthRequest;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthResponse;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthStatisticRequest;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthStatisticResponse;
import com.xforceplus.phoenix.auth.client.model.MsStatisticalJumpRequest;
import com.xforceplus.phoenix.auth.client.model.MsTurnOutInvoiceRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "authRequest", description = "the authRequest API")
public interface AuthRequestApi {

    @ApiOperation(value = "取消进转出", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/cancelTurnOutInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse cancelTurnOutInvoices(@ApiParam(value = "request" ,required=true ) @RequestBody MsTurnOutInvoiceRequest request);


    @ApiOperation(value = "发送认证确认接口", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/confrimSendAuth",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse confrimSendAuth(@ApiParam(value = "request" ,required=true ) @RequestBody MsSendAuthConfirmRequest request);


    @ApiOperation(value = "发票导出 - 导出发票数据", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/export/exportInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse exportInvoices(@ApiParam(value = "request" ,required=true ) @RequestBody MsExportInvoiceRequest request);


    @ApiOperation(value = "获取认证发票各状态数据", notes = "", response = MsSendAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsSendAuthResponse.class) })
    @RequestMapping(value = "/authRequest/getAuthInvoiceInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSendAuthResponse getAuthInvoiceInfo(@ApiParam(value = "request" ,required=true ) @RequestBody MsSendAuthRequest request);


    @ApiOperation(value = "获取认证发票统计数据", notes = "", response = MsSendAuthStatisticResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsSendAuthStatisticResponse.class) })
    @RequestMapping(value = "/authRequest/getAuthInvoiceInfoStatistic",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsSendAuthStatisticResponse getAuthInvoiceInfoStatistic(@ApiParam(value = "request" ,required=true ) @RequestBody MsSendAuthStatisticRequest request);


    @ApiOperation(value = "获取未申报的公司", notes = "", response = MsListUndeclaredCompanyResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsListUndeclaredCompanyResponse.class) })
    @RequestMapping(value = "/authRequest/listUndeclaredCompanyInfos",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsListUndeclaredCompanyResponse listUndeclaredCompanyInfos(@ApiParam(value = "request" ,required=true ) @RequestBody MsListUndeclaredCompanyRequest request);


    @ApiOperation(value = "申请统计跳转", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/statisticalJump",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse statisticalJump(@ApiParam(value = "request" ,required=true ) @RequestBody MsStatisticalJumpRequest request);


    @ApiOperation(value = "进转出", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authRequest/turnOutInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse turnOutInvoices(@ApiParam(value = "request" ,required=true ) @RequestBody MsTurnOutInvoiceRequest request);

}
