package com.xforceplus.phoenix.auth.client.api;

import com.xforceplus.phoenix.auth.client.model.MsAuthInvoiceRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

/**
 * 认证首页api
 */
@Api(value = "AuthIndex", description = "the AuthIndex API")
public interface IndexApi {

    @ApiOperation(
            value = "认证首页列表",
            notes = "",
            response = Response.class,
            tags = {"AuthIndex"}
    )
    @RequestMapping(
            value = {"/authIndex/listAuthInvoices"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response listAuthInvoices(@RequestBody MsAuthInvoiceRequest request);


    @ApiOperation(
            value = "首页统计各认证状态发票数",
            notes = "",
            response = Response.class,
            tags = {"AuthIndex"}
    )
    @RequestMapping(
            value = {"/authIndex/countAuthInvoiceNumByStatus"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response countAuthInvoiceNumByStatus(@RequestBody MsAuthInvoiceRequest request);

    @ApiOperation(
            value = "首页统计总金额",
            notes = "",
            response = Response.class,
            tags = {"AuthIndex"}
    )
    @RequestMapping(
            value = {"/authIndex/countAuthInvoiceAmount"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response countAuthInvoiceAmount(@RequestBody MsAuthInvoiceRequest request);

    @ApiOperation(
            value = "有认证权限的公司集合",
            notes = "",
            response = Response.class,
            tags = {"AuthIndex"}
    )
    @RequestMapping(
            value = {"/authIndex/listCompanyInfos"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response listCompanyInfos(@RequestBody String companyName);

    @ApiOperation(
            value = "查询税盘在线信息",
            notes = "",
            response = Response.class,
            tags = {"AuthIndex"}
    )
    @RequestMapping(
            value = {"/authIndex/listTaxPlateClientOnlines"},
            produces = {"application/json"},
            method = {RequestMethod.POST}
    )
    Response listTaxPlateOnlineStatus();
}
