package com.xforceplus.phoenix.auth.client.api;

import com.xforceplus.phoenix.auth.client.model.MsTaxPlateInfoResponse;
import com.xforceplus.phoenix.auth.client.model.MsTaxPlateOnlineStatusRequest;
import com.xforceplus.phoenix.auth.client.model.MsTaxPlateRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "taxPlate", description = "the taxPlate API")
public interface TaxPlateApi {

    @ApiOperation(value = "查看税盘在线详情", notes = "", response = MsTaxPlateInfoResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "TaxPlate", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsTaxPlateInfoResponse.class) })
    @RequestMapping(value = "/taxPlate/getTaxPlateOnlineDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsTaxPlateInfoResponse getTaxPlateOnlineDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsTaxPlateRequest taxPlateRequest);


    @ApiOperation(value = "查询税盘在线信息", notes = "", response = MsTaxPlateInfoResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "TaxPlate", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsTaxPlateInfoResponse.class) })
    @RequestMapping(value = "/taxPlate/listTaxPlateOnlineStatus",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsTaxPlateInfoResponse listTaxPlateOnlineStatus(@ApiParam(value = "request" ,required=true ) @RequestBody MsTaxPlateOnlineStatusRequest taxPlateOnlineStatusRequest);

}
