package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsAutCompanyLimit {
  @JsonProperty("limitId")
  private Long limitId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("limitMonth")
  private String limitMonth = null;

  @JsonProperty("limitAmount")
  private String limitAmount = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("opStatus")
  private Integer opStatus = null;

  @JsonProperty("opTime")
  private java.util.Date opTime = null;

  @JsonIgnore
  public MsAutCompanyLimit limitId(Long limitId) {
    this.limitId = limitId;
    return this;
  }

   /**
   * 认证限额id
   * @return limitId
  **/
  @ApiModelProperty(value = "认证限额id")
  public Long getLimitId() {
    return limitId;
  }

  public void setLimitId(Long limitId) {
    this.limitId = limitId;
  }

  @JsonIgnore
  public MsAutCompanyLimit companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsAutCompanyLimit companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsAutCompanyLimit limitMonth(String limitMonth) {
    this.limitMonth = limitMonth;
    return this;
  }

   /**
   * 限额月份
   * @return limitMonth
  **/
  @ApiModelProperty(value = "限额月份")
  public String getLimitMonth() {
    return limitMonth;
  }

  public void setLimitMonth(String limitMonth) {
    this.limitMonth = limitMonth;
  }

  @JsonIgnore
  public MsAutCompanyLimit limitAmount(String limitAmount) {
    this.limitAmount = limitAmount;
    return this;
  }

   /**
   * 认证限额
   * @return limitAmount
  **/
  @ApiModelProperty(value = "认证限额")
  public String getLimitAmount() {
    return limitAmount;
  }

  public void setLimitAmount(String limitAmount) {
    this.limitAmount = limitAmount;
  }

  @JsonIgnore
  public MsAutCompanyLimit opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsAutCompanyLimit opStatus(Integer opStatus) {
    this.opStatus = opStatus;
    return this;
  }

   /**
   * 操作状态：0-正常，1-已过期
   * @return opStatus
  **/
  @ApiModelProperty(value = "操作状态：0-正常，1-已过期")
  public Integer getOpStatus() {
    return opStatus;
  }

  public void setOpStatus(Integer opStatus) {
    this.opStatus = opStatus;
  }

  @JsonIgnore
  public MsAutCompanyLimit opTime(java.util.Date opTime) {
    this.opTime = opTime;
    return this;
  }

   /**
   * 操作时间
   * @return opTime
  **/
  @ApiModelProperty(value = "操作时间")
  public java.util.Date getOpTime() {
    return opTime;
  }

  public void setOpTime(java.util.Date opTime) {
    this.opTime = opTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAutCompanyLimit autCompanyLimit = (MsAutCompanyLimit) o;
    return Objects.equals(this.limitId, autCompanyLimit.limitId) &&
        Objects.equals(this.companyName, autCompanyLimit.companyName) &&
        Objects.equals(this.companyTaxNo, autCompanyLimit.companyTaxNo) &&
        Objects.equals(this.limitMonth, autCompanyLimit.limitMonth) &&
        Objects.equals(this.limitAmount, autCompanyLimit.limitAmount) &&
        Objects.equals(this.opUserName, autCompanyLimit.opUserName) &&
        Objects.equals(this.opStatus, autCompanyLimit.opStatus) &&
        Objects.equals(this.opTime, autCompanyLimit.opTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(limitId, companyName, companyTaxNo, limitMonth, limitAmount, opUserName, opStatus, opTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAutCompanyLimit {\n");
    
    sb.append("    limitId: ").append(toIndentedString(limitId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    limitMonth: ").append(toIndentedString(limitMonth)).append("\n");
    sb.append("    limitAmount: ").append(toIndentedString(limitAmount)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    opStatus: ").append(toIndentedString(opStatus)).append("\n");
    sb.append("    opTime: ").append(toIndentedString(opTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
