package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsAutCompanyLimitObj {
  @JsonProperty("limitId")
  private Long limitId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("limitMonth")
  private String limitMonth = null;

  @JsonProperty("limitAmount")
  private String limitAmount = null;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonIgnore
  public MsAutCompanyLimitObj limitId(Long limitId) {
    this.limitId = limitId;
    return this;
  }

   /**
   * 限额id
   * @return limitId
  **/
  @ApiModelProperty(value = "限额id")
  public Long getLimitId() {
    return limitId;
  }

  public void setLimitId(Long limitId) {
    this.limitId = limitId;
  }

  @JsonIgnore
  public MsAutCompanyLimitObj companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsAutCompanyLimitObj companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsAutCompanyLimitObj limitMonth(String limitMonth) {
    this.limitMonth = limitMonth;
    return this;
  }

   /**
   * 限额月份
   * @return limitMonth
  **/
  @ApiModelProperty(value = "限额月份")
  public String getLimitMonth() {
    return limitMonth;
  }

  public void setLimitMonth(String limitMonth) {
    this.limitMonth = limitMonth;
  }

  @JsonIgnore
  public MsAutCompanyLimitObj limitAmount(String limitAmount) {
    this.limitAmount = limitAmount;
    return this;
  }

   /**
   * 认证限额
   * @return limitAmount
  **/
  @ApiModelProperty(value = "认证限额")
  public String getLimitAmount() {
    return limitAmount;
  }

  public void setLimitAmount(String limitAmount) {
    this.limitAmount = limitAmount;
  }

  @JsonIgnore
  public MsAutCompanyLimitObj opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsAutCompanyLimitObj opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAutCompanyLimitObj autCompanyLimitObj = (MsAutCompanyLimitObj) o;
    return Objects.equals(this.limitId, autCompanyLimitObj.limitId) &&
        Objects.equals(this.companyName, autCompanyLimitObj.companyName) &&
        Objects.equals(this.companyTaxNo, autCompanyLimitObj.companyTaxNo) &&
        Objects.equals(this.limitMonth, autCompanyLimitObj.limitMonth) &&
        Objects.equals(this.limitAmount, autCompanyLimitObj.limitAmount) &&
        Objects.equals(this.opUserId, autCompanyLimitObj.opUserId) &&
        Objects.equals(this.opUserName, autCompanyLimitObj.opUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(limitId, companyName, companyTaxNo, limitMonth, limitAmount, opUserId, opUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAutCompanyLimitObj {\n");
    
    sb.append("    limitId: ").append(toIndentedString(limitId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    limitMonth: ").append(toIndentedString(limitMonth)).append("\n");
    sb.append("    limitAmount: ").append(toIndentedString(limitAmount)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
