package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsInvoiceParamGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsAuthInvoiceRequest {
  @JsonProperty("authTabStatus")
  private Integer authTabStatus = null;

  @JsonProperty("pageIndex")
  private Integer pageIndex = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 20;

  @JsonProperty("purchaserTaxNos")
  private List<String> purchaserTaxNos = new ArrayList<String>();

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("paramGroups")
  private List<MsInvoiceParamGroup> paramGroups = new ArrayList<MsInvoiceParamGroup>();

  @JsonProperty("fields")
  private List<String> fields = new ArrayList<String>();

  @JsonProperty("orders")
  private List<String> orders = new ArrayList<String>();

  @JsonProperty("orderSort")
  private List<String> orderSort = new ArrayList<String>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("companyIds")
  private List<Long> companyIds = new ArrayList<Long>();

  @JsonIgnore
  public MsAuthInvoiceRequest authTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
    return this;
  }

   /**
   * 认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税，5-认证中，6-认证成功，7-认证异常，8-已转出,9-不可认证,10-挂起列表
   * @return authTabStatus
  **/
  @ApiModelProperty(value = "认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税，5-认证中，6-认证成功，7-认证异常，8-已转出,9-不可认证,10-挂起列表")
  public Integer getAuthTabStatus() {
    return authTabStatus;
  }

  public void setAuthTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页码
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 一页显示条数
   * @return pageSize
  **/
  @ApiModelProperty(value = "一页显示条数")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest purchaserTaxNos(List<String> purchaserTaxNos) {
    this.purchaserTaxNos = purchaserTaxNos;
    return this;
  }

  public MsAuthInvoiceRequest addPurchaserTaxNosItem(String purchaserTaxNosItem) {
    this.purchaserTaxNos.add(purchaserTaxNosItem);
    return this;
  }

   /**
   * 购方公司税号集合
   * @return purchaserTaxNos
  **/
  @ApiModelProperty(value = "购方公司税号集合")
  public List<String> getPurchaserTaxNos() {
    return purchaserTaxNos;
  }

  public void setPurchaserTaxNos(List<String> purchaserTaxNos) {
    this.purchaserTaxNos = purchaserTaxNos;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsAuthInvoiceRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织Id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织Id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest paramGroups(List<MsInvoiceParamGroup> paramGroups) {
    this.paramGroups = paramGroups;
    return this;
  }

  public MsAuthInvoiceRequest addParamGroupsItem(MsInvoiceParamGroup paramGroupsItem) {
    this.paramGroups.add(paramGroupsItem);
    return this;
  }

   /**
   * Get paramGroups
   * @return paramGroups
  **/
  @ApiModelProperty(value = "")
  public List<MsInvoiceParamGroup> getParamGroups() {
    return paramGroups;
  }

  public void setParamGroups(List<MsInvoiceParamGroup> paramGroups) {
    this.paramGroups = paramGroups;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest fields(List<String> fields) {
    this.fields = fields;
    return this;
  }

  public MsAuthInvoiceRequest addFieldsItem(String fieldsItem) {
    this.fields.add(fieldsItem);
    return this;
  }

   /**
   * 自定义展示列KEY 取字段的驼峰格式命名 如:\"invoiceNo\"
   * @return fields
  **/
  @ApiModelProperty(value = "自定义展示列KEY 取字段的驼峰格式命名 如:\"invoiceNo\"")
  public List<String> getFields() {
    return fields;
  }

  public void setFields(List<String> fields) {
    this.fields = fields;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest orders(List<String> orders) {
    this.orders = orders;
    return this;
  }

  public MsAuthInvoiceRequest addOrdersItem(String ordersItem) {
    this.orders.add(ordersItem);
    return this;
  }

   /**
   * 自定义排序列KEY 取字段的驼峰格式命名 如:\"invoiceNo\"
   * @return orders
  **/
  @ApiModelProperty(value = "自定义排序列KEY 取字段的驼峰格式命名 如:\"invoiceNo\"")
  public List<String> getOrders() {
    return orders;
  }

  public void setOrders(List<String> orders) {
    this.orders = orders;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest orderSort(List<String> orderSort) {
    this.orderSort = orderSort;
    return this;
  }

  public MsAuthInvoiceRequest addOrderSortItem(String orderSortItem) {
    this.orderSort.add(orderSortItem);
    return this;
  }

   /**
   * 排序方式  asc-升序  desc-降序
   * @return orderSort
  **/
  @ApiModelProperty(value = "排序方式  asc-升序  desc-降序")
  public List<String> getOrderSort() {
    return orderSort;
  }

  public void setOrderSort(List<String> orderSort) {
    this.orderSort = orderSort;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 用户名称
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "用户名称")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsAuthInvoiceRequest companyIds(List<Long> companyIds) {
    this.companyIds = companyIds;
    return this;
  }

  public MsAuthInvoiceRequest addCompanyIdsItem(Long companyIdsItem) {
    this.companyIds.add(companyIdsItem);
    return this;
  }

   /**
   * 公司id集合
   * @return companyIds
  **/
  @ApiModelProperty(value = "公司id集合")
  public List<Long> getCompanyIds() {
    return companyIds;
  }

  public void setCompanyIds(List<Long> companyIds) {
    this.companyIds = companyIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthInvoiceRequest authInvoiceRequest = (MsAuthInvoiceRequest) o;
    return Objects.equals(this.authTabStatus, authInvoiceRequest.authTabStatus) &&
        Objects.equals(this.pageIndex, authInvoiceRequest.pageIndex) &&
        Objects.equals(this.pageSize, authInvoiceRequest.pageSize) &&
        Objects.equals(this.purchaserTaxNos, authInvoiceRequest.purchaserTaxNos) &&
        Objects.equals(this.orgIdList, authInvoiceRequest.orgIdList) &&
        Objects.equals(this.paramGroups, authInvoiceRequest.paramGroups) &&
        Objects.equals(this.fields, authInvoiceRequest.fields) &&
        Objects.equals(this.orders, authInvoiceRequest.orders) &&
        Objects.equals(this.orderSort, authInvoiceRequest.orderSort) &&
        Objects.equals(this.sysUserId, authInvoiceRequest.sysUserId) &&
        Objects.equals(this.sysUserName, authInvoiceRequest.sysUserName) &&
        Objects.equals(this.purchaserGroupId, authInvoiceRequest.purchaserGroupId) &&
        Objects.equals(this.companyIds, authInvoiceRequest.companyIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authTabStatus, pageIndex, pageSize, purchaserTaxNos, orgIdList, paramGroups, fields, orders, orderSort, sysUserId, sysUserName, purchaserGroupId, companyIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthInvoiceRequest {\n");
    
    sb.append("    authTabStatus: ").append(toIndentedString(authTabStatus)).append("\n");
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    purchaserTaxNos: ").append(toIndentedString(purchaserTaxNos)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    paramGroups: ").append(toIndentedString(paramGroups)).append("\n");
    sb.append("    fields: ").append(toIndentedString(fields)).append("\n");
    sb.append("    orders: ").append(toIndentedString(orders)).append("\n");
    sb.append("    orderSort: ").append(toIndentedString(orderSort)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    companyIds: ").append(toIndentedString(companyIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
