package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsAuthLimitRequest {
  @JsonProperty("searchKeyword")
  private String searchKeyword = null;

  @JsonProperty("limitMonthStart")
  private String limitMonthStart = null;

  @JsonProperty("limitMonthEnd")
  private String limitMonthEnd = null;

  @JsonProperty("opStatus")
  private Integer opStatus = null;

  @JsonProperty("pageIndex")
  private Integer pageIndex = 1;

  @JsonProperty("pageSize")
  private Integer pageSize = 20;

  @JsonProperty("opUserId")
  private Long opUserId = null;

  @JsonProperty("opUserName")
  private String opUserName = null;

  @JsonProperty("companyTaxNoList")
  private List<String> companyTaxNoList = new ArrayList<String>();

  @JsonIgnore
  public MsAuthLimitRequest searchKeyword(String searchKeyword) {
    this.searchKeyword = searchKeyword;
    return this;
  }

   /**
   * 搜索关键词
   * @return searchKeyword
  **/
  @ApiModelProperty(value = "搜索关键词")
  public String getSearchKeyword() {
    return searchKeyword;
  }

  public void setSearchKeyword(String searchKeyword) {
    this.searchKeyword = searchKeyword;
  }

  @JsonIgnore
  public MsAuthLimitRequest limitMonthStart(String limitMonthStart) {
    this.limitMonthStart = limitMonthStart;
    return this;
  }

   /**
   * 限额月份起始值，例：201809
   * @return limitMonthStart
  **/
  @ApiModelProperty(value = "限额月份起始值，例：201809")
  public String getLimitMonthStart() {
    return limitMonthStart;
  }

  public void setLimitMonthStart(String limitMonthStart) {
    this.limitMonthStart = limitMonthStart;
  }

  @JsonIgnore
  public MsAuthLimitRequest limitMonthEnd(String limitMonthEnd) {
    this.limitMonthEnd = limitMonthEnd;
    return this;
  }

   /**
   * 限额月份起始值，例：201809
   * @return limitMonthEnd
  **/
  @ApiModelProperty(value = "限额月份起始值，例：201809")
  public String getLimitMonthEnd() {
    return limitMonthEnd;
  }

  public void setLimitMonthEnd(String limitMonthEnd) {
    this.limitMonthEnd = limitMonthEnd;
  }

  @JsonIgnore
  public MsAuthLimitRequest opStatus(Integer opStatus) {
    this.opStatus = opStatus;
    return this;
  }

   /**
   * 操作状态：0-正常，1-已过期
   * @return opStatus
  **/
  @ApiModelProperty(value = "操作状态：0-正常，1-已过期")
  public Integer getOpStatus() {
    return opStatus;
  }

  public void setOpStatus(Integer opStatus) {
    this.opStatus = opStatus;
  }

  @JsonIgnore
  public MsAuthLimitRequest pageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
    return this;
  }

   /**
   * 页码
   * @return pageIndex
  **/
  @ApiModelProperty(value = "页码")
  public Integer getPageIndex() {
    return pageIndex;
  }

  public void setPageIndex(Integer pageIndex) {
    this.pageIndex = pageIndex;
  }

  @JsonIgnore
  public MsAuthLimitRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * 一页显示条数
   * @return pageSize
  **/
  @ApiModelProperty(value = "一页显示条数")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsAuthLimitRequest opUserId(Long opUserId) {
    this.opUserId = opUserId;
    return this;
  }

   /**
   * 操作人id
   * @return opUserId
  **/
  @ApiModelProperty(value = "操作人id")
  public Long getOpUserId() {
    return opUserId;
  }

  public void setOpUserId(Long opUserId) {
    this.opUserId = opUserId;
  }

  @JsonIgnore
  public MsAuthLimitRequest opUserName(String opUserName) {
    this.opUserName = opUserName;
    return this;
  }

   /**
   * 操作人名
   * @return opUserName
  **/
  @ApiModelProperty(value = "操作人名")
  public String getOpUserName() {
    return opUserName;
  }

  public void setOpUserName(String opUserName) {
    this.opUserName = opUserName;
  }

  @JsonIgnore
  public MsAuthLimitRequest companyTaxNoList(List<String> companyTaxNoList) {
    this.companyTaxNoList = companyTaxNoList;
    return this;
  }

  public MsAuthLimitRequest addCompanyTaxNoListItem(String companyTaxNoListItem) {
    this.companyTaxNoList.add(companyTaxNoListItem);
    return this;
  }

   /**
   * 公司税号集合
   * @return companyTaxNoList
  **/
  @ApiModelProperty(value = "公司税号集合")
  public List<String> getCompanyTaxNoList() {
    return companyTaxNoList;
  }

  public void setCompanyTaxNoList(List<String> companyTaxNoList) {
    this.companyTaxNoList = companyTaxNoList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthLimitRequest authLimitRequest = (MsAuthLimitRequest) o;
    return Objects.equals(this.searchKeyword, authLimitRequest.searchKeyword) &&
        Objects.equals(this.limitMonthStart, authLimitRequest.limitMonthStart) &&
        Objects.equals(this.limitMonthEnd, authLimitRequest.limitMonthEnd) &&
        Objects.equals(this.opStatus, authLimitRequest.opStatus) &&
        Objects.equals(this.pageIndex, authLimitRequest.pageIndex) &&
        Objects.equals(this.pageSize, authLimitRequest.pageSize) &&
        Objects.equals(this.opUserId, authLimitRequest.opUserId) &&
        Objects.equals(this.opUserName, authLimitRequest.opUserName) &&
        Objects.equals(this.companyTaxNoList, authLimitRequest.companyTaxNoList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(searchKeyword, limitMonthStart, limitMonthEnd, opStatus, pageIndex, pageSize, opUserId, opUserName, companyTaxNoList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthLimitRequest {\n");
    
    sb.append("    searchKeyword: ").append(toIndentedString(searchKeyword)).append("\n");
    sb.append("    limitMonthStart: ").append(toIndentedString(limitMonthStart)).append("\n");
    sb.append("    limitMonthEnd: ").append(toIndentedString(limitMonthEnd)).append("\n");
    sb.append("    opStatus: ").append(toIndentedString(opStatus)).append("\n");
    sb.append("    pageIndex: ").append(toIndentedString(pageIndex)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    opUserId: ").append(toIndentedString(opUserId)).append("\n");
    sb.append("    opUserName: ").append(toIndentedString(opUserName)).append("\n");
    sb.append("    companyTaxNoList: ").append(toIndentedString(companyTaxNoList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
