package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsCompanyMain {
  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("authLimitAmount")
  private String authLimitAmount = null;

  @JsonIgnore
  public MsCompanyMain companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsCompanyMain companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCompanyMain companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCompanyMain taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsCompanyMain authLimitAmount(String authLimitAmount) {
    this.authLimitAmount = authLimitAmount;
    return this;
  }

   /**
   * 认证限额
   * @return authLimitAmount
  **/
  @ApiModelProperty(value = "认证限额")
  public String getAuthLimitAmount() {
    return authLimitAmount;
  }

  public void setAuthLimitAmount(String authLimitAmount) {
    this.authLimitAmount = authLimitAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCompanyMain companyMain = (MsCompanyMain) o;
    return Objects.equals(this.companyId, companyMain.companyId) &&
        Objects.equals(this.companyName, companyMain.companyName) &&
        Objects.equals(this.companyTaxNo, companyMain.companyTaxNo) &&
        Objects.equals(this.taxPeriod, companyMain.taxPeriod) &&
        Objects.equals(this.authLimitAmount, companyMain.authLimitAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, companyName, companyTaxNo, taxPeriod, authLimitAmount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCompanyMain {\n");
    
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    authLimitAmount: ").append(toIndentedString(authLimitAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
