package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsCompanyRequest {
  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("companyIds")
  private List<Long> companyIds = new ArrayList<Long>();

  @JsonIgnore
  public MsCompanyRequest companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCompanyRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsCompanyRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsCompanyRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsCompanyRequest companyIds(List<Long> companyIds) {
    this.companyIds = companyIds;
    return this;
  }

  public MsCompanyRequest addCompanyIdsItem(Long companyIdsItem) {
    this.companyIds.add(companyIdsItem);
    return this;
  }

   /**
   * 公司id集合
   * @return companyIds
  **/
  @ApiModelProperty(value = "公司id集合")
  public List<Long> getCompanyIds() {
    return companyIds;
  }

  public void setCompanyIds(List<Long> companyIds) {
    this.companyIds = companyIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCompanyRequest companyRequest = (MsCompanyRequest) o;
    return Objects.equals(this.companyName, companyRequest.companyName) &&
        Objects.equals(this.purchaserGroupId, companyRequest.purchaserGroupId) &&
        Objects.equals(this.sysUserId, companyRequest.sysUserId) &&
        Objects.equals(this.sysUserName, companyRequest.sysUserName) &&
        Objects.equals(this.companyIds, companyRequest.companyIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyName, purchaserGroupId, sysUserId, sysUserName, companyIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCompanyRequest {\n");
    
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    companyIds: ").append(toIndentedString(companyIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
