package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 自定义列对象
 */
@ApiModel(description = "自定义列对象")

@JsonInclude(NON_NULL)
public class MsCustomColumnObj {
  @JsonProperty("code")
  private String code = null;

  @JsonProperty("name")
  private String name = null;

  @JsonProperty("status")
  private String status = null;

  @JsonIgnore
  public MsCustomColumnObj code(String code) {
    this.code = code;
    return this;
  }

   /**
   * 字段code
   * @return code
  **/
  @ApiModelProperty(value = "字段code")
  public String getCode() {
    return code;
  }

  public void setCode(String code) {
    this.code = code;
  }

  @JsonIgnore
  public MsCustomColumnObj name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 字段名称
   * @return name
  **/
  @ApiModelProperty(value = "字段名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @JsonIgnore
  public MsCustomColumnObj status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 状态值，true or false
   * @return status
  **/
  @ApiModelProperty(value = "状态值，true or false")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomColumnObj customColumnObj = (MsCustomColumnObj) o;
    return Objects.equals(this.code, customColumnObj.code) &&
        Objects.equals(this.name, customColumnObj.name) &&
        Objects.equals(this.status, customColumnObj.status);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, name, status);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomColumnObj {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
