package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsDownloadInvoiceImage {
  @JsonProperty("invoiceNum")
  private Integer invoiceNum = null;

  @JsonProperty("imageNum")
  private Integer imageNum = null;

  @JsonIgnore
  public MsDownloadInvoiceImage invoiceNum(Integer invoiceNum) {
    this.invoiceNum = invoiceNum;
    return this;
  }

   /**
   * 发票数
   * @return invoiceNum
  **/
  @ApiModelProperty(value = "发票数")
  public Integer getInvoiceNum() {
    return invoiceNum;
  }

  public void setInvoiceNum(Integer invoiceNum) {
    this.invoiceNum = invoiceNum;
  }

  @JsonIgnore
  public MsDownloadInvoiceImage imageNum(Integer imageNum) {
    this.imageNum = imageNum;
    return this;
  }

   /**
   * 影像数
   * @return imageNum
  **/
  @ApiModelProperty(value = "影像数")
  public Integer getImageNum() {
    return imageNum;
  }

  public void setImageNum(Integer imageNum) {
    this.imageNum = imageNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDownloadInvoiceImage downloadInvoiceImage = (MsDownloadInvoiceImage) o;
    return Objects.equals(this.invoiceNum, downloadInvoiceImage.invoiceNum) &&
        Objects.equals(this.imageNum, downloadInvoiceImage.imageNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceNum, imageNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDownloadInvoiceImage {\n");
    
    sb.append("    invoiceNum: ").append(toIndentedString(invoiceNum)).append("\n");
    sb.append("    imageNum: ").append(toIndentedString(imageNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
