package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsDownloadInvoiceImageRequest
 */

@JsonInclude(NON_NULL)
public class MsDownloadInvoiceImageRequest {
  @JsonProperty("downloadType")
  private Integer downloadType = null;

  @JsonProperty("invoiceIds")
  private List<String> invoiceIds = new ArrayList<String>();

  @JsonIgnore
  public MsDownloadInvoiceImageRequest downloadType(Integer downloadType) {
    this.downloadType = downloadType;
    return this;
  }

   /**
   * 下载类型：1-点击下载影像按钮获取弹框提示的数据，2-确认下载
   * @return downloadType
  **/
  @ApiModelProperty(value = "下载类型：1-点击下载影像按钮获取弹框提示的数据，2-确认下载")
  public Integer getDownloadType() {
    return downloadType;
  }

  public void setDownloadType(Integer downloadType) {
    this.downloadType = downloadType;
  }

  @JsonIgnore
  public MsDownloadInvoiceImageRequest invoiceIds(List<String> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsDownloadInvoiceImageRequest addInvoiceIdsItem(String invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<String> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<String> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsDownloadInvoiceImageRequest downloadInvoiceImageRequest = (MsDownloadInvoiceImageRequest) o;
    return Objects.equals(this.downloadType, downloadInvoiceImageRequest.downloadType) &&
        Objects.equals(this.invoiceIds, downloadInvoiceImageRequest.invoiceIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(downloadType, invoiceIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsDownloadInvoiceImageRequest {\n");
    
    sb.append("    downloadType: ").append(toIndentedString(downloadType)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
