package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsInvoiceParamGroup;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 自定义列对象
 */
@ApiModel(description = "自定义列对象")

@JsonInclude(NON_NULL)
public class MsExportInvoiceRequest {
  @JsonProperty("downloadType")
  private Integer downloadType = null;

  @JsonProperty("pageId")
  private Integer pageId = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("withDetailFlag")
  private Integer withDetailFlag = null;

  @JsonProperty("paramGroups")
  private List<MsInvoiceParamGroup> paramGroups = new ArrayList<MsInvoiceParamGroup>();

  @JsonProperty("orders")
  private List<String> orders = new ArrayList<String>();

  @JsonProperty("orderSort")
  private List<String> orderSort = new ArrayList<String>();

  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("authTabStatus")
  private Integer authTabStatus = null;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("companyIds")
  private List<Long> companyIds = new ArrayList<Long>();

  @JsonIgnore
  public MsExportInvoiceRequest downloadType(Integer downloadType) {
    this.downloadType = downloadType;
    return this;
  }

   /**
   * 下载类型 1-发票管理导出Excel 2-认证管理导出Excel
   * @return downloadType
  **/
  @ApiModelProperty(value = "下载类型 1-发票管理导出Excel 2-认证管理导出Excel")
  public Integer getDownloadType() {
    return downloadType;
  }

  public void setDownloadType(Integer downloadType) {
    this.downloadType = downloadType;
  }

  @JsonIgnore
  public MsExportInvoiceRequest pageId(Integer pageId) {
    this.pageId = pageId;
    return this;
  }

   /**
   * 自定义功能界面ID 0-默认 1-进项发票导出 2-认证导出
   * @return pageId
  **/
  @ApiModelProperty(value = "自定义功能界面ID 0-默认 1-进项发票导出 2-认证导出")
  public Integer getPageId() {
    return pageId;
  }

  public void setPageId(Integer pageId) {
    this.pageId = pageId;
  }

  @JsonIgnore
  public MsExportInvoiceRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 下载自定义组ID   传0导出默认定义
   * @return groupId
  **/
  @ApiModelProperty(value = "下载自定义组ID   传0导出默认定义")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsExportInvoiceRequest withDetailFlag(Integer withDetailFlag) {
    this.withDetailFlag = withDetailFlag;
    return this;
  }

   /**
   * 是否含明细  0-不含明细（默认） 1-含明细
   * @return withDetailFlag
  **/
  @ApiModelProperty(value = "是否含明细  0-不含明细（默认） 1-含明细")
  public Integer getWithDetailFlag() {
    return withDetailFlag;
  }

  public void setWithDetailFlag(Integer withDetailFlag) {
    this.withDetailFlag = withDetailFlag;
  }

  @JsonIgnore
  public MsExportInvoiceRequest paramGroups(List<MsInvoiceParamGroup> paramGroups) {
    this.paramGroups = paramGroups;
    return this;
  }

  public MsExportInvoiceRequest addParamGroupsItem(MsInvoiceParamGroup paramGroupsItem) {
    this.paramGroups.add(paramGroupsItem);
    return this;
  }

   /**
   * Get paramGroups
   * @return paramGroups
  **/
  @ApiModelProperty(value = "")
  public List<MsInvoiceParamGroup> getParamGroups() {
    return paramGroups;
  }

  public void setParamGroups(List<MsInvoiceParamGroup> paramGroups) {
    this.paramGroups = paramGroups;
  }

  @JsonIgnore
  public MsExportInvoiceRequest orders(List<String> orders) {
    this.orders = orders;
    return this;
  }

  public MsExportInvoiceRequest addOrdersItem(String ordersItem) {
    this.orders.add(ordersItem);
    return this;
  }

   /**
   * 自定义排序列KEY 取字段的驼峰格式命名 如:\"invoiceNo\"
   * @return orders
  **/
  @ApiModelProperty(value = "自定义排序列KEY 取字段的驼峰格式命名 如:\"invoiceNo\"")
  public List<String> getOrders() {
    return orders;
  }

  public void setOrders(List<String> orders) {
    this.orders = orders;
  }

  @JsonIgnore
  public MsExportInvoiceRequest orderSort(List<String> orderSort) {
    this.orderSort = orderSort;
    return this;
  }

  public MsExportInvoiceRequest addOrderSortItem(String orderSortItem) {
    this.orderSort.add(orderSortItem);
    return this;
  }

   /**
   * 排序方式  asc-升序  desc-降序  和orders对应
   * @return orderSort
  **/
  @ApiModelProperty(value = "排序方式  asc-升序  desc-降序  和orders对应")
  public List<String> getOrderSort() {
    return orderSort;
  }

  public void setOrderSort(List<String> orderSort) {
    this.orderSort = orderSort;
  }

  @JsonIgnore
  public MsExportInvoiceRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsExportInvoiceRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票ID数组
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票ID数组")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public MsExportInvoiceRequest authTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
    return this;
  }

   /**
   * 认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税，5-认证中，6-认证成功，7-认证异常，8-已转出，9-不可认证
   * @return authTabStatus
  **/
  @ApiModelProperty(value = "认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税，5-认证中，6-认证成功，7-认证异常，8-已转出，9-不可认证")
  public Integer getAuthTabStatus() {
    return authTabStatus;
  }

  public void setAuthTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
  }

  @JsonIgnore
  public MsExportInvoiceRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsExportInvoiceRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsExportInvoiceRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsExportInvoiceRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsExportInvoiceRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 用户名称
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "用户名称")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsExportInvoiceRequest companyIds(List<Long> companyIds) {
    this.companyIds = companyIds;
    return this;
  }

  public MsExportInvoiceRequest addCompanyIdsItem(Long companyIdsItem) {
    this.companyIds.add(companyIdsItem);
    return this;
  }

   /**
   * 公司id集合
   * @return companyIds
  **/
  @ApiModelProperty(value = "公司id集合")
  public List<Long> getCompanyIds() {
    return companyIds;
  }

  public void setCompanyIds(List<Long> companyIds) {
    this.companyIds = companyIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsExportInvoiceRequest exportInvoiceRequest = (MsExportInvoiceRequest) o;
    return Objects.equals(this.downloadType, exportInvoiceRequest.downloadType) &&
        Objects.equals(this.pageId, exportInvoiceRequest.pageId) &&
        Objects.equals(this.groupId, exportInvoiceRequest.groupId) &&
        Objects.equals(this.withDetailFlag, exportInvoiceRequest.withDetailFlag) &&
        Objects.equals(this.paramGroups, exportInvoiceRequest.paramGroups) &&
        Objects.equals(this.orders, exportInvoiceRequest.orders) &&
        Objects.equals(this.orderSort, exportInvoiceRequest.orderSort) &&
        Objects.equals(this.invoiceIds, exportInvoiceRequest.invoiceIds) &&
        Objects.equals(this.authTabStatus, exportInvoiceRequest.authTabStatus) &&
        Objects.equals(this.orgIdList, exportInvoiceRequest.orgIdList) &&
        Objects.equals(this.sysUserId, exportInvoiceRequest.sysUserId) &&
        Objects.equals(this.sysUserName, exportInvoiceRequest.sysUserName) &&
        Objects.equals(this.purchaserGroupId, exportInvoiceRequest.purchaserGroupId) &&
        Objects.equals(this.companyIds, exportInvoiceRequest.companyIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(downloadType, pageId, groupId, withDetailFlag, paramGroups, orders, orderSort, invoiceIds, authTabStatus, orgIdList, sysUserId, sysUserName, purchaserGroupId, companyIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsExportInvoiceRequest {\n");
    
    sb.append("    downloadType: ").append(toIndentedString(downloadType)).append("\n");
    sb.append("    pageId: ").append(toIndentedString(pageId)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    withDetailFlag: ").append(toIndentedString(withDetailFlag)).append("\n");
    sb.append("    paramGroups: ").append(toIndentedString(paramGroups)).append("\n");
    sb.append("    orders: ").append(toIndentedString(orders)).append("\n");
    sb.append("    orderSort: ").append(toIndentedString(orderSort)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    authTabStatus: ").append(toIndentedString(authTabStatus)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    companyIds: ").append(toIndentedString(companyIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
