package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsFreezeInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class MsFreezeInvoiceRequest {
  @JsonProperty("freezeDesc")
  private String freezeDesc = null;

  @JsonProperty("invoiceIds")
  private List<String> invoiceIds = new ArrayList<String>();

  @JsonIgnore
  public MsFreezeInvoiceRequest freezeDesc(String freezeDesc) {
    this.freezeDesc = freezeDesc;
    return this;
  }

   /**
   * 冻结描述
   * @return freezeDesc
  **/
  @ApiModelProperty(value = "冻结描述")
  public String getFreezeDesc() {
    return freezeDesc;
  }

  public void setFreezeDesc(String freezeDesc) {
    this.freezeDesc = freezeDesc;
  }

  @JsonIgnore
  public MsFreezeInvoiceRequest invoiceIds(List<String> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsFreezeInvoiceRequest addInvoiceIdsItem(String invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<String> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<String> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsFreezeInvoiceRequest freezeInvoiceRequest = (MsFreezeInvoiceRequest) o;
    return Objects.equals(this.freezeDesc, freezeInvoiceRequest.freezeDesc) &&
        Objects.equals(this.invoiceIds, freezeInvoiceRequest.invoiceIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(freezeDesc, invoiceIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsFreezeInvoiceRequest {\n");
    
    sb.append("    freezeDesc: ").append(toIndentedString(freezeDesc)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
