package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsInvoiceMain {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("createUserId")
  private Long createUserId = null;

  @JsonProperty("createUserName")
  private String createUserName = null;

  @JsonProperty("updateUserId")
  private Long updateUserId = null;

  @JsonProperty("updateUserName")
  private String updateUserName = null;

  @JsonProperty("bussinessId")
  private Long bussinessId = null;

  @JsonProperty("bussinessNo")
  private String bussinessNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("purchaserOrgId")
  private Long purchaserOrgId = null;

  @JsonProperty("purchaserExternalCode")
  private String purchaserExternalCode = null;

  @JsonProperty("purchaserLabel")
  private String purchaserLabel = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerRootOrgId")
  private Long sellerRootOrgId = null;

  @JsonProperty("sellerOrgId")
  private Long sellerOrgId = null;

  @JsonProperty("sellerExternalCode")
  private String sellerExternalCode = null;

  @JsonProperty("sellerInvoiceId")
  private Long sellerInvoiceId = null;

  @JsonProperty("sellerUserName")
  private String sellerUserName = null;

  @JsonProperty("sellerViewImageFlag")
  private Integer sellerViewImageFlag = null;

  @JsonProperty("invoiceColor")
  private Integer invoiceColor = null;

  @JsonProperty("sellerSyncStatus")
  private Integer sellerSyncStatus = null;

  @JsonProperty("sellerSyncTime")
  private String sellerSyncTime = null;

  @JsonProperty("sellerLabel")
  private String sellerLabel = null;

  @JsonProperty("taxRate")
  private String taxRate = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("amountWithTaxCapital")
  private String amountWithTaxCapital = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("machineCode")
  private String machineCode = null;

  @JsonProperty("checkCode")
  private String checkCode = null;

  @JsonProperty("cipherText")
  private String cipherText = null;

  @JsonProperty("invoiceOrig")
  private Integer invoiceOrig = null;

  @JsonProperty("specialInvoiceFlag")
  private Integer specialInvoiceFlag = null;

  @JsonProperty("titleOkFlag")
  private Integer titleOkFlag = null;

  @JsonProperty("saleListFlag")
  private Integer saleListFlag = null;

  @JsonProperty("dataOkFlag")
  private Integer dataOkFlag = null;

  @JsonProperty("recogStatus")
  private Integer recogStatus = null;

  @JsonProperty("recogInvoiceId")
  private Long recogInvoiceId = null;

  @JsonProperty("recogResponseTime")
  private String recogResponseTime = null;

  @JsonProperty("recogUserName")
  private String recogUserName = null;

  @JsonProperty("recogUploadNum")
  private Integer recogUploadNum = null;

  @JsonProperty("complianceStatus")
  private Integer complianceStatus = null;

  @JsonProperty("taxInvoiceId")
  private Long taxInvoiceId = null;

  @JsonProperty("authSyncStatus")
  private Integer authSyncStatus = null;

  @JsonProperty("authSyncTime")
  private String authSyncTime = null;

  @JsonProperty("veriInvoiceId")
  private Long veriInvoiceId = null;

  @JsonProperty("veriStatus")
  private Integer veriStatus = null;

  @JsonProperty("veriRequestTime")
  private String veriRequestTime = null;

  @JsonProperty("veriResponseTime")
  private String veriResponseTime = null;

  @JsonProperty("veriUserName")
  private String veriUserName = null;

  @JsonProperty("authStatus")
  private Integer authStatus = null;

  @JsonProperty("authStyle")
  private Integer authStyle = null;

  @JsonProperty("authBussiDate")
  private String authBussiDate = null;

  @JsonProperty("authTaxPeriod")
  private String authTaxPeriod = null;

  @JsonProperty("authRequestTime")
  private String authRequestTime = null;

  @JsonProperty("authResponseTime")
  private String authResponseTime = null;

  @JsonProperty("authRequestUserName")
  private String authRequestUserName = null;

  @JsonProperty("redStatus")
  private Integer redStatus = null;

  @JsonProperty("redTime")
  private String redTime = null;

  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;

  @JsonProperty("redUserName")
  private String redUserName = null;

  @JsonProperty("retreatStatus")
  private Integer retreatStatus = null;

  @JsonProperty("retreatTime")
  private String retreatTime = null;

  @JsonProperty("retreatUserName")
  private String retreatUserName = null;

  @JsonProperty("matchStatus")
  private Integer matchStatus = null;

  @JsonProperty("matchTime")
  private String matchTime = null;

  @JsonProperty("matchUserName")
  private String matchUserName = null;

  @JsonProperty("chargeUpStatus")
  private Integer chargeUpStatus = null;

  @JsonProperty("chargeUpNo")
  private String chargeUpNo = null;

  @JsonProperty("chargeUpTime")
  private String chargeUpTime = null;

  @JsonProperty("chargeUpPeriod")
  private String chargeUpPeriod = null;

  @JsonProperty("chargeUpUserName")
  private String chargeUpUserName = null;

  @JsonProperty("saleConfirmStatus")
  private Integer saleConfirmStatus = null;

  @JsonProperty("saleConfirmNo")
  private String saleConfirmNo = null;

  @JsonProperty("saleConfirmTime")
  private String saleConfirmTime = null;

  @JsonProperty("saleConfirmPeriod")
  private String saleConfirmPeriod = null;

  @JsonProperty("saleConfirmUserName")
  private String saleConfirmUserName = null;

  @JsonProperty("paymentStatus")
  private Integer paymentStatus = null;

  @JsonProperty("paymentNo")
  private String paymentNo = null;

  @JsonProperty("paymentDate")
  private String paymentDate = null;

  @JsonProperty("paymentTime")
  private String paymentTime = null;

  @JsonProperty("paymentUserName")
  private String paymentUserName = null;

  @JsonProperty("freezeStatus")
  private Integer freezeStatus = null;

  @JsonProperty("freezeTime")
  private String freezeTime = null;

  @JsonProperty("freezeUserName")
  private String freezeUserName = null;

  @JsonProperty("loseStatus")
  private Integer loseStatus = null;

  @JsonProperty("loseTime")
  private String loseTime = null;

  @JsonProperty("loseUserName")
  private String loseUserName = null;

  @JsonProperty("blackStatus")
  private Integer blackStatus = null;

  @JsonProperty("blackRemark")
  private String blackRemark = null;

  @JsonProperty("bizTag1")
  private String bizTag1 = null;

  @JsonProperty("bizTag2")
  private String bizTag2 = null;

  @JsonProperty("bizTag3")
  private String bizTag3 = null;

  @JsonProperty("originBussinessId")
  private Long originBussinessId = null;

  @JsonProperty("originBussinessNo")
  private String originBussinessNo = null;

  @JsonProperty("originInvoiceNo")
  private String originInvoiceNo = null;

  @JsonProperty("originInvoiceCode")
  private String originInvoiceCode = null;

  @JsonProperty("tpStatus")
  private Integer tpStatus = null;

  @JsonProperty("purchaserAddress")
  private String purchaserAddress = null;

  @JsonProperty("purchaserTel")
  private String purchaserTel = null;

  @JsonProperty("purchaserAddrTel")
  private String purchaserAddrTel = null;

  @JsonProperty("purchaserBankName")
  private String purchaserBankName = null;

  @JsonProperty("purchaserBankAccount")
  private String purchaserBankAccount = null;

  @JsonProperty("purchaserBankNameAccount")
  private String purchaserBankNameAccount = null;

  @JsonProperty("sellerAddress")
  private String sellerAddress = null;

  @JsonProperty("sellerTel")
  private String sellerTel = null;

  @JsonProperty("sellerAddrTel")
  private String sellerAddrTel = null;

  @JsonProperty("sellerBankName")
  private String sellerBankName = null;

  @JsonProperty("sellerBankAccount")
  private String sellerBankAccount = null;

  @JsonProperty("sellerBankNameAccount")
  private String sellerBankNameAccount = null;

  @JsonProperty("sellerUserId")
  private Long sellerUserId = null;

  @JsonProperty("cashierName")
  private String cashierName = null;

  @JsonProperty("checkerName")
  private String checkerName = null;

  @JsonProperty("invoicerName")
  private String invoicerName = null;

  @JsonProperty("recogUserId")
  private Long recogUserId = null;

  @JsonProperty("recogDeductionImageUrl")
  private String recogDeductionImageUrl = null;

  @JsonProperty("recogInvoiceImageUrl")
  private String recogInvoiceImageUrl = null;

  @JsonProperty("pdfUrl")
  private String pdfUrl = null;

  @JsonProperty("vehicleType")
  private String vehicleType = null;

  @JsonProperty("vehicleBrand")
  private String vehicleBrand = null;

  @JsonProperty("productionArea")
  private String productionArea = null;

  @JsonProperty("certNo")
  private String certNo = null;

  @JsonProperty("importCertNo")
  private String importCertNo = null;

  @JsonProperty("inspectionNo")
  private String inspectionNo = null;

  @JsonProperty("engineNo")
  private String engineNo = null;

  @JsonProperty("organizationCode")
  private String organizationCode = null;

  @JsonProperty("vin")
  private String vin = null;

  @JsonProperty("tonnage")
  private String tonnage = null;

  @JsonProperty("taxPaidProof")
  private String taxPaidProof = null;

  @JsonProperty("maxCapacity")
  private String maxCapacity = null;

  @JsonProperty("taxAuthName")
  private String taxAuthName = null;

  @JsonProperty("taxAuthCode")
  private String taxAuthCode = null;

  @JsonProperty("veriUserId")
  private Long veriUserId = null;

  @JsonProperty("veriRemark")
  private String veriRemark = null;

  @JsonProperty("authRequestUserId")
  private Long authRequestUserId = null;

  @JsonProperty("authRemark")
  private String authRemark = null;

  @JsonProperty("redUserId")
  private Long redUserId = null;

  @JsonProperty("redRemark")
  private String redRemark = null;

  @JsonProperty("retreatUserId")
  private Long retreatUserId = null;

  @JsonProperty("retreatRemark")
  private String retreatRemark = null;

  @JsonProperty("matchUserId")
  private Long matchUserId = null;

  @JsonProperty("matchRemark")
  private String matchRemark = null;

  @JsonProperty("chargeUpUserId")
  private Long chargeUpUserId = null;

  @JsonProperty("chargeUpRemark")
  private String chargeUpRemark = null;

  @JsonProperty("saleConfirmUserId")
  private Long saleConfirmUserId = null;

  @JsonProperty("saleConfirmRemark")
  private String saleConfirmRemark = null;

  @JsonProperty("paymentUserId")
  private Long paymentUserId = null;

  @JsonProperty("paymentRemark")
  private String paymentRemark = null;

  @JsonProperty("freezeUserId")
  private Long freezeUserId = null;

  @JsonProperty("freezeRemark")
  private String freezeRemark = null;

  @JsonProperty("loseUserId")
  private Long loseUserId = null;

  @JsonProperty("loseRemark")
  private String loseRemark = null;

  @JsonProperty("remark")
  private String remark = null;

  @JsonProperty("noComplianceDesc")
  private List<String> noComplianceDesc = new ArrayList<String>();

  @JsonProperty("imageNum")
  private Integer imageNum = null;

  @JsonProperty("cooperationFlag")
  private Boolean cooperationFlag = null;

  @JsonProperty("authWarningDays")
  private Integer authWarningDays = null;

  @JsonProperty("remarkFlag")
  private Boolean remarkFlag = null;

  @JsonIgnore
  public MsInvoiceMain invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票主键
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票主键")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public MsInvoiceMain invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型 s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型 s-增值税专用发票 c-增值税普通发票 ce-增值税电子普通发票 ju-增值税普通发票（卷票） ct-通行费增值税电子普通发票 v-机动车统一销售发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsInvoiceMain invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsInvoiceMain invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsInvoiceMain status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 发票状态 0-默认 1-正常 2-作废 3-被红冲 7-异常 8-失控 9-删除
   * @return status
  **/
  @ApiModelProperty(value = "发票状态 0-默认 1-正常 2-作废 3-被红冲 7-异常 8-失控 9-删除")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsInvoiceMain createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 数据创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "数据创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsInvoiceMain updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 更新时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "更新时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsInvoiceMain createUserId(Long createUserId) {
    this.createUserId = createUserId;
    return this;
  }

   /**
   * 创建用户ID
   * @return createUserId
  **/
  @ApiModelProperty(value = "创建用户ID")
  public Long getCreateUserId() {
    return createUserId;
  }

  public void setCreateUserId(Long createUserId) {
    this.createUserId = createUserId;
  }

  @JsonIgnore
  public MsInvoiceMain createUserName(String createUserName) {
    this.createUserName = createUserName;
    return this;
  }

   /**
   * 创建用户名
   * @return createUserName
  **/
  @ApiModelProperty(value = "创建用户名")
  public String getCreateUserName() {
    return createUserName;
  }

  public void setCreateUserName(String createUserName) {
    this.createUserName = createUserName;
  }

  @JsonIgnore
  public MsInvoiceMain updateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
    return this;
  }

   /**
   * 更新用户ID
   * @return updateUserId
  **/
  @ApiModelProperty(value = "更新用户ID")
  public Long getUpdateUserId() {
    return updateUserId;
  }

  public void setUpdateUserId(Long updateUserId) {
    this.updateUserId = updateUserId;
  }

  @JsonIgnore
  public MsInvoiceMain updateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
    return this;
  }

   /**
   * 更新用户名
   * @return updateUserName
  **/
  @ApiModelProperty(value = "更新用户名")
  public String getUpdateUserName() {
    return updateUserName;
  }

  public void setUpdateUserName(String updateUserName) {
    this.updateUserName = updateUserName;
  }

  @JsonIgnore
  public MsInvoiceMain bussinessId(Long bussinessId) {
    this.bussinessId = bussinessId;
    return this;
  }

   /**
   * 业务单ID
   * @return bussinessId
  **/
  @ApiModelProperty(value = "业务单ID")
  public Long getBussinessId() {
    return bussinessId;
  }

  public void setBussinessId(Long bussinessId) {
    this.bussinessId = bussinessId;
  }

  @JsonIgnore
  public MsInvoiceMain bussinessNo(String bussinessNo) {
    this.bussinessNo = bussinessNo;
    return this;
  }

   /**
   * 业务单号
   * @return bussinessNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getBussinessNo() {
    return bussinessNo;
  }

  public void setBussinessNo(String bussinessNo) {
    this.bussinessNo = bussinessNo;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方纳税人识别号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方纳税人识别号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 购方集团组织ID（票易通）
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "购方集团组织ID（票易通）")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserOrgId(Long purchaserOrgId) {
    this.purchaserOrgId = purchaserOrgId;
    return this;
  }

   /**
   * 购方组织ID（票易通）
   * @return purchaserOrgId
  **/
  @ApiModelProperty(value = "购方组织ID（票易通）")
  public Long getPurchaserOrgId() {
    return purchaserOrgId;
  }

  public void setPurchaserOrgId(Long purchaserOrgId) {
    this.purchaserOrgId = purchaserOrgId;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserExternalCode(String purchaserExternalCode) {
    this.purchaserExternalCode = purchaserExternalCode;
    return this;
  }

   /**
   * 购方公司编号（外部系统）
   * @return purchaserExternalCode
  **/
  @ApiModelProperty(value = "购方公司编号（外部系统）")
  public String getPurchaserExternalCode() {
    return purchaserExternalCode;
  }

  public void setPurchaserExternalCode(String purchaserExternalCode) {
    this.purchaserExternalCode = purchaserExternalCode;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserLabel(String purchaserLabel) {
    this.purchaserLabel = purchaserLabel;
    return this;
  }

   /**
   * 购方标签
   * @return purchaserLabel
  **/
  @ApiModelProperty(value = "购方标签")
  public String getPurchaserLabel() {
    return purchaserLabel;
  }

  public void setPurchaserLabel(String purchaserLabel) {
    this.purchaserLabel = purchaserLabel;
  }

  @JsonIgnore
  public MsInvoiceMain sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsInvoiceMain sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方纳税人识别号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方纳税人识别号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsInvoiceMain sellerRootOrgId(Long sellerRootOrgId) {
    this.sellerRootOrgId = sellerRootOrgId;
    return this;
  }

   /**
   * 销方集团组织ID（票易通）
   * @return sellerRootOrgId
  **/
  @ApiModelProperty(value = "销方集团组织ID（票易通）")
  public Long getSellerRootOrgId() {
    return sellerRootOrgId;
  }

  public void setSellerRootOrgId(Long sellerRootOrgId) {
    this.sellerRootOrgId = sellerRootOrgId;
  }

  @JsonIgnore
  public MsInvoiceMain sellerOrgId(Long sellerOrgId) {
    this.sellerOrgId = sellerOrgId;
    return this;
  }

   /**
   * 销方组织ID（票易通）
   * @return sellerOrgId
  **/
  @ApiModelProperty(value = "销方组织ID（票易通）")
  public Long getSellerOrgId() {
    return sellerOrgId;
  }

  public void setSellerOrgId(Long sellerOrgId) {
    this.sellerOrgId = sellerOrgId;
  }

  @JsonIgnore
  public MsInvoiceMain sellerExternalCode(String sellerExternalCode) {
    this.sellerExternalCode = sellerExternalCode;
    return this;
  }

   /**
   * 销方公司编号（外部系统）
   * @return sellerExternalCode
  **/
  @ApiModelProperty(value = "销方公司编号（外部系统）")
  public String getSellerExternalCode() {
    return sellerExternalCode;
  }

  public void setSellerExternalCode(String sellerExternalCode) {
    this.sellerExternalCode = sellerExternalCode;
  }

  @JsonIgnore
  public MsInvoiceMain sellerInvoiceId(Long sellerInvoiceId) {
    this.sellerInvoiceId = sellerInvoiceId;
    return this;
  }

   /**
   * 销方发票主表ID
   * @return sellerInvoiceId
  **/
  @ApiModelProperty(value = "销方发票主表ID")
  public Long getSellerInvoiceId() {
    return sellerInvoiceId;
  }

  public void setSellerInvoiceId(Long sellerInvoiceId) {
    this.sellerInvoiceId = sellerInvoiceId;
  }

  @JsonIgnore
  public MsInvoiceMain sellerUserName(String sellerUserName) {
    this.sellerUserName = sellerUserName;
    return this;
  }

   /**
   * 销方开票操作人姓名
   * @return sellerUserName
  **/
  @ApiModelProperty(value = "销方开票操作人姓名")
  public String getSellerUserName() {
    return sellerUserName;
  }

  public void setSellerUserName(String sellerUserName) {
    this.sellerUserName = sellerUserName;
  }

  @JsonIgnore
  public MsInvoiceMain sellerViewImageFlag(Integer sellerViewImageFlag) {
    this.sellerViewImageFlag = sellerViewImageFlag;
    return this;
  }

   /**
   * 销方查看影像标志   0-默认  1-允许销方查看影像
   * @return sellerViewImageFlag
  **/
  @ApiModelProperty(value = "销方查看影像标志   0-默认  1-允许销方查看影像")
  public Integer getSellerViewImageFlag() {
    return sellerViewImageFlag;
  }

  public void setSellerViewImageFlag(Integer sellerViewImageFlag) {
    this.sellerViewImageFlag = sellerViewImageFlag;
  }

  @JsonIgnore
  public MsInvoiceMain invoiceColor(Integer invoiceColor) {
    this.invoiceColor = invoiceColor;
    return this;
  }

   /**
   * 红蓝标识   1-蓝票  2-红票
   * @return invoiceColor
  **/
  @ApiModelProperty(value = "红蓝标识   1-蓝票  2-红票")
  public Integer getInvoiceColor() {
    return invoiceColor;
  }

  public void setInvoiceColor(Integer invoiceColor) {
    this.invoiceColor = invoiceColor;
  }

  @JsonIgnore
  public MsInvoiceMain sellerSyncStatus(Integer sellerSyncStatus) {
    this.sellerSyncStatus = sellerSyncStatus;
    return this;
  }

   /**
   * 销方开具状态  0-默认  1-无销方信息（非协同）  2-销方信息未到（协同） 3-销方信息已到（协同）
   * @return sellerSyncStatus
  **/
  @ApiModelProperty(value = "销方开具状态  0-默认  1-无销方信息（非协同）  2-销方信息未到（协同） 3-销方信息已到（协同）")
  public Integer getSellerSyncStatus() {
    return sellerSyncStatus;
  }

  public void setSellerSyncStatus(Integer sellerSyncStatus) {
    this.sellerSyncStatus = sellerSyncStatus;
  }

  @JsonIgnore
  public MsInvoiceMain sellerSyncTime(String sellerSyncTime) {
    this.sellerSyncTime = sellerSyncTime;
    return this;
  }

   /**
   * 销方信息获取时间
   * @return sellerSyncTime
  **/
  @ApiModelProperty(value = "销方信息获取时间")
  public String getSellerSyncTime() {
    return sellerSyncTime;
  }

  public void setSellerSyncTime(String sellerSyncTime) {
    this.sellerSyncTime = sellerSyncTime;
  }

  @JsonIgnore
  public MsInvoiceMain sellerLabel(String sellerLabel) {
    this.sellerLabel = sellerLabel;
    return this;
  }

   /**
   * 销方标签
   * @return sellerLabel
  **/
  @ApiModelProperty(value = "销方标签")
  public String getSellerLabel() {
    return sellerLabel;
  }

  public void setSellerLabel(String sellerLabel) {
    this.sellerLabel = sellerLabel;
  }

  @JsonIgnore
  public MsInvoiceMain taxRate(String taxRate) {
    this.taxRate = taxRate;
    return this;
  }

   /**
   * 税率   多税率以逗号隔开，如：16%,11%,3%
   * @return taxRate
  **/
  @ApiModelProperty(value = "税率   多税率以逗号隔开，如：16%,11%,3%")
  public String getTaxRate() {
    return taxRate;
  }

  public void setTaxRate(String taxRate) {
    this.taxRate = taxRate;
  }

  @JsonIgnore
  public MsInvoiceMain amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsInvoiceMain taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsInvoiceMain amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsInvoiceMain amountWithTaxCapital(String amountWithTaxCapital) {
    this.amountWithTaxCapital = amountWithTaxCapital;
    return this;
  }

   /**
   * 含税金额(大写)
   * @return amountWithTaxCapital
  **/
  @ApiModelProperty(value = "含税金额(大写)")
  public String getAmountWithTaxCapital() {
    return amountWithTaxCapital;
  }

  public void setAmountWithTaxCapital(String amountWithTaxCapital) {
    this.amountWithTaxCapital = amountWithTaxCapital;
  }

  @JsonIgnore
  public MsInvoiceMain paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 发票开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "发票开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsInvoiceMain machineCode(String machineCode) {
    this.machineCode = machineCode;
    return this;
  }

   /**
   * 机器编码
   * @return machineCode
  **/
  @ApiModelProperty(value = "机器编码")
  public String getMachineCode() {
    return machineCode;
  }

  public void setMachineCode(String machineCode) {
    this.machineCode = machineCode;
  }

  @JsonIgnore
  public MsInvoiceMain checkCode(String checkCode) {
    this.checkCode = checkCode;
    return this;
  }

   /**
   * 校验码
   * @return checkCode
  **/
  @ApiModelProperty(value = "校验码")
  public String getCheckCode() {
    return checkCode;
  }

  public void setCheckCode(String checkCode) {
    this.checkCode = checkCode;
  }

  @JsonIgnore
  public MsInvoiceMain cipherText(String cipherText) {
    this.cipherText = cipherText;
    return this;
  }

   /**
   * 密文
   * @return cipherText
  **/
  @ApiModelProperty(value = "密文")
  public String getCipherText() {
    return cipherText;
  }

  public void setCipherText(String cipherText) {
    this.cipherText = cipherText;
  }

  @JsonIgnore
  public MsInvoiceMain invoiceOrig(Integer invoiceOrig) {
    this.invoiceOrig = invoiceOrig;
    return this;
  }

   /**
   * 发票来源  0-默认 11-销方直连 12-销方抽取  13-销方手工回填   21-国税验真   22-国税底账  31-影像识别
   * @return invoiceOrig
  **/
  @ApiModelProperty(value = "发票来源  0-默认 11-销方直连 12-销方抽取  13-销方手工回填   21-国税验真   22-国税底账  31-影像识别")
  public Integer getInvoiceOrig() {
    return invoiceOrig;
  }

  public void setInvoiceOrig(Integer invoiceOrig) {
    this.invoiceOrig = invoiceOrig;
  }

  @JsonIgnore
  public MsInvoiceMain specialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
    return this;
  }

   /**
   * 特殊发票标记  0-默认  1-通行费   2-成品油
   * @return specialInvoiceFlag
  **/
  @ApiModelProperty(value = "特殊发票标记  0-默认  1-通行费   2-成品油")
  public Integer getSpecialInvoiceFlag() {
    return specialInvoiceFlag;
  }

  public void setSpecialInvoiceFlag(Integer specialInvoiceFlag) {
    this.specialInvoiceFlag = specialInvoiceFlag;
  }

  @JsonIgnore
  public MsInvoiceMain titleOkFlag(Integer titleOkFlag) {
    this.titleOkFlag = titleOkFlag;
    return this;
  }

   /**
   * 抬头是否有误   0-默认  1-无误   2-有误
   * @return titleOkFlag
  **/
  @ApiModelProperty(value = "抬头是否有误   0-默认  1-无误   2-有误")
  public Integer getTitleOkFlag() {
    return titleOkFlag;
  }

  public void setTitleOkFlag(Integer titleOkFlag) {
    this.titleOkFlag = titleOkFlag;
  }

  @JsonIgnore
  public MsInvoiceMain saleListFlag(Integer saleListFlag) {
    this.saleListFlag = saleListFlag;
    return this;
  }

   /**
   * 是否有销货清单  0-未知（默认）  1-有    2-无
   * @return saleListFlag
  **/
  @ApiModelProperty(value = "是否有销货清单  0-未知（默认）  1-有    2-无")
  public Integer getSaleListFlag() {
    return saleListFlag;
  }

  public void setSaleListFlag(Integer saleListFlag) {
    this.saleListFlag = saleListFlag;
  }

  @JsonIgnore
  public MsInvoiceMain dataOkFlag(Integer dataOkFlag) {
    this.dataOkFlag = dataOkFlag;
    return this;
  }

   /**
   * 数据源比对是否一致  0-未知（默认）  1-一致    2-不一致
   * @return dataOkFlag
  **/
  @ApiModelProperty(value = "数据源比对是否一致  0-未知（默认）  1-一致    2-不一致")
  public Integer getDataOkFlag() {
    return dataOkFlag;
  }

  public void setDataOkFlag(Integer dataOkFlag) {
    this.dataOkFlag = dataOkFlag;
  }

  @JsonIgnore
  public MsInvoiceMain recogStatus(Integer recogStatus) {
    this.recogStatus = recogStatus;
    return this;
  }

   /**
   * 识别状态  0-未识别（默认） 1-已识别
   * @return recogStatus
  **/
  @ApiModelProperty(value = "识别状态  0-未识别（默认） 1-已识别")
  public Integer getRecogStatus() {
    return recogStatus;
  }

  public void setRecogStatus(Integer recogStatus) {
    this.recogStatus = recogStatus;
  }

  @JsonIgnore
  public MsInvoiceMain recogInvoiceId(Long recogInvoiceId) {
    this.recogInvoiceId = recogInvoiceId;
    return this;
  }

   /**
   * 识别发票主表ID
   * @return recogInvoiceId
  **/
  @ApiModelProperty(value = "识别发票主表ID")
  public Long getRecogInvoiceId() {
    return recogInvoiceId;
  }

  public void setRecogInvoiceId(Long recogInvoiceId) {
    this.recogInvoiceId = recogInvoiceId;
  }

  @JsonIgnore
  public MsInvoiceMain recogResponseTime(String recogResponseTime) {
    this.recogResponseTime = recogResponseTime;
    return this;
  }

   /**
   * 识别完成时间
   * @return recogResponseTime
  **/
  @ApiModelProperty(value = "识别完成时间")
  public String getRecogResponseTime() {
    return recogResponseTime;
  }

  public void setRecogResponseTime(String recogResponseTime) {
    this.recogResponseTime = recogResponseTime;
  }

  @JsonIgnore
  public MsInvoiceMain recogUserName(String recogUserName) {
    this.recogUserName = recogUserName;
    return this;
  }

   /**
   * 识别操作人姓名
   * @return recogUserName
  **/
  @ApiModelProperty(value = "识别操作人姓名")
  public String getRecogUserName() {
    return recogUserName;
  }

  public void setRecogUserName(String recogUserName) {
    this.recogUserName = recogUserName;
  }

  @JsonIgnore
  public MsInvoiceMain recogUploadNum(Integer recogUploadNum) {
    this.recogUploadNum = recogUploadNum;
    return this;
  }

   /**
   * 识别上传次数
   * @return recogUploadNum
  **/
  @ApiModelProperty(value = "识别上传次数")
  public Integer getRecogUploadNum() {
    return recogUploadNum;
  }

  public void setRecogUploadNum(Integer recogUploadNum) {
    this.recogUploadNum = recogUploadNum;
  }

  @JsonIgnore
  public MsInvoiceMain complianceStatus(Integer complianceStatus) {
    this.complianceStatus = complianceStatus;
    return this;
  }

   /**
   * 合规状态  0-待校验（默认）  1-合规  2-不合规
   * @return complianceStatus
  **/
  @ApiModelProperty(value = "合规状态  0-待校验（默认）  1-合规  2-不合规")
  public Integer getComplianceStatus() {
    return complianceStatus;
  }

  public void setComplianceStatus(Integer complianceStatus) {
    this.complianceStatus = complianceStatus;
  }

  @JsonIgnore
  public MsInvoiceMain taxInvoiceId(Long taxInvoiceId) {
    this.taxInvoiceId = taxInvoiceId;
    return this;
  }

   /**
   * 国税底账主表ID
   * @return taxInvoiceId
  **/
  @ApiModelProperty(value = "国税底账主表ID")
  public Long getTaxInvoiceId() {
    return taxInvoiceId;
  }

  public void setTaxInvoiceId(Long taxInvoiceId) {
    this.taxInvoiceId = taxInvoiceId;
  }

  @JsonIgnore
  public MsInvoiceMain authSyncStatus(Integer authSyncStatus) {
    this.authSyncStatus = authSyncStatus;
    return this;
  }

   /**
   * 电子底账状态  0-未获取(默认)  1-未勾选  2-已勾选  3-底账确认失败 4-已确认  5-不可勾选确认
   * @return authSyncStatus
  **/
  @ApiModelProperty(value = "电子底账状态  0-未获取(默认)  1-未勾选  2-已勾选  3-底账确认失败 4-已确认  5-不可勾选确认")
  public Integer getAuthSyncStatus() {
    return authSyncStatus;
  }

  public void setAuthSyncStatus(Integer authSyncStatus) {
    this.authSyncStatus = authSyncStatus;
  }

  @JsonIgnore
  public MsInvoiceMain authSyncTime(String authSyncTime) {
    this.authSyncTime = authSyncTime;
    return this;
  }

   /**
   * 电子底帐获取时间
   * @return authSyncTime
  **/
  @ApiModelProperty(value = "电子底帐获取时间")
  public String getAuthSyncTime() {
    return authSyncTime;
  }

  public void setAuthSyncTime(String authSyncTime) {
    this.authSyncTime = authSyncTime;
  }

  @JsonIgnore
  public MsInvoiceMain veriInvoiceId(Long veriInvoiceId) {
    this.veriInvoiceId = veriInvoiceId;
    return this;
  }

   /**
   * 国税验真主表ID
   * @return veriInvoiceId
  **/
  @ApiModelProperty(value = "国税验真主表ID")
  public Long getVeriInvoiceId() {
    return veriInvoiceId;
  }

  public void setVeriInvoiceId(Long veriInvoiceId) {
    this.veriInvoiceId = veriInvoiceId;
  }

  @JsonIgnore
  public MsInvoiceMain veriStatus(Integer veriStatus) {
    this.veriStatus = veriStatus;
    return this;
  }

   /**
   * 查验 状态 0-未查验(默认) 1-待查验 2-查验中 3-查验成功 4-查验失败
   * @return veriStatus
  **/
  @ApiModelProperty(value = "查验 状态 0-未查验(默认) 1-待查验 2-查验中 3-查验成功 4-查验失败")
  public Integer getVeriStatus() {
    return veriStatus;
  }

  public void setVeriStatus(Integer veriStatus) {
    this.veriStatus = veriStatus;
  }

  @JsonIgnore
  public MsInvoiceMain veriRequestTime(String veriRequestTime) {
    this.veriRequestTime = veriRequestTime;
    return this;
  }

   /**
   * 查验发送时间
   * @return veriRequestTime
  **/
  @ApiModelProperty(value = "查验发送时间")
  public String getVeriRequestTime() {
    return veriRequestTime;
  }

  public void setVeriRequestTime(String veriRequestTime) {
    this.veriRequestTime = veriRequestTime;
  }

  @JsonIgnore
  public MsInvoiceMain veriResponseTime(String veriResponseTime) {
    this.veriResponseTime = veriResponseTime;
    return this;
  }

   /**
   * 查验完成时间
   * @return veriResponseTime
  **/
  @ApiModelProperty(value = "查验完成时间")
  public String getVeriResponseTime() {
    return veriResponseTime;
  }

  public void setVeriResponseTime(String veriResponseTime) {
    this.veriResponseTime = veriResponseTime;
  }

  @JsonIgnore
  public MsInvoiceMain veriUserName(String veriUserName) {
    this.veriUserName = veriUserName;
    return this;
  }

   /**
   * 查验操作人姓名
   * @return veriUserName
  **/
  @ApiModelProperty(value = "查验操作人姓名")
  public String getVeriUserName() {
    return veriUserName;
  }

  public void setVeriUserName(String veriUserName) {
    this.veriUserName = veriUserName;
  }

  @JsonIgnore
  public MsInvoiceMain authStatus(Integer authStatus) {
    this.authStatus = authStatus;
    return this;
  }

   /**
   * 认证状态  0-默认1-不可认证2-未认证3-认证中 4-认证成功5-认证失败 6-认证异常 7-已转出
   * @return authStatus
  **/
  @ApiModelProperty(value = "认证状态  0-默认1-不可认证2-未认证3-认证中 4-认证成功5-认证失败 6-认证异常 7-已转出")
  public Integer getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(Integer authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public MsInvoiceMain authStyle(Integer authStyle) {
    this.authStyle = authStyle;
    return this;
  }

   /**
   * 认证方式  0-默认 10-票易通底账确认 20-票易通扫描认证 30-票易通退税确认 40-票易通代理出口退税 11-票易通底账认证导入 21-票易通扫描认证导入 12-国税底账确认 22-国税扫描认证 32-国税退税认证 42-国税代理出口退税
   * @return authStyle
  **/
  @ApiModelProperty(value = "认证方式  0-默认 10-票易通底账确认 20-票易通扫描认证 30-票易通退税确认 40-票易通代理出口退税 11-票易通底账认证导入 21-票易通扫描认证导入 12-国税底账确认 22-国税扫描认证 32-国税退税认证 42-国税代理出口退税")
  public Integer getAuthStyle() {
    return authStyle;
  }

  public void setAuthStyle(Integer authStyle) {
    this.authStyle = authStyle;
  }

  @JsonIgnore
  public MsInvoiceMain authBussiDate(String authBussiDate) {
    this.authBussiDate = authBussiDate;
    return this;
  }

   /**
   * 认证业务日期
   * @return authBussiDate
  **/
  @ApiModelProperty(value = "认证业务日期")
  public String getAuthBussiDate() {
    return authBussiDate;
  }

  public void setAuthBussiDate(String authBussiDate) {
    this.authBussiDate = authBussiDate;
  }

  @JsonIgnore
  public MsInvoiceMain authTaxPeriod(String authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
    return this;
  }

   /**
   * 认证所属期
   * @return authTaxPeriod
  **/
  @ApiModelProperty(value = "认证所属期")
  public String getAuthTaxPeriod() {
    return authTaxPeriod;
  }

  public void setAuthTaxPeriod(String authTaxPeriod) {
    this.authTaxPeriod = authTaxPeriod;
  }

  @JsonIgnore
  public MsInvoiceMain authRequestTime(String authRequestTime) {
    this.authRequestTime = authRequestTime;
    return this;
  }

   /**
   * 认证发送时间
   * @return authRequestTime
  **/
  @ApiModelProperty(value = "认证发送时间")
  public String getAuthRequestTime() {
    return authRequestTime;
  }

  public void setAuthRequestTime(String authRequestTime) {
    this.authRequestTime = authRequestTime;
  }

  @JsonIgnore
  public MsInvoiceMain authResponseTime(String authResponseTime) {
    this.authResponseTime = authResponseTime;
    return this;
  }

   /**
   * 认证完成时间
   * @return authResponseTime
  **/
  @ApiModelProperty(value = "认证完成时间")
  public String getAuthResponseTime() {
    return authResponseTime;
  }

  public void setAuthResponseTime(String authResponseTime) {
    this.authResponseTime = authResponseTime;
  }

  @JsonIgnore
  public MsInvoiceMain authRequestUserName(String authRequestUserName) {
    this.authRequestUserName = authRequestUserName;
    return this;
  }

   /**
   * 认证操作人姓名
   * @return authRequestUserName
  **/
  @ApiModelProperty(value = "认证操作人姓名")
  public String getAuthRequestUserName() {
    return authRequestUserName;
  }

  public void setAuthRequestUserName(String authRequestUserName) {
    this.authRequestUserName = authRequestUserName;
  }

  @JsonIgnore
  public MsInvoiceMain redStatus(Integer redStatus) {
    this.redStatus = redStatus;
    return this;
  }

   /**
   * 红冲状态 0-默认 1-待红冲 2-待部分红冲 3-红冲 4-部分红冲
   * @return redStatus
  **/
  @ApiModelProperty(value = "红冲状态 0-默认 1-待红冲 2-待部分红冲 3-红冲 4-部分红冲")
  public Integer getRedStatus() {
    return redStatus;
  }

  public void setRedStatus(Integer redStatus) {
    this.redStatus = redStatus;
  }

  @JsonIgnore
  public MsInvoiceMain redTime(String redTime) {
    this.redTime = redTime;
    return this;
  }

   /**
   * 红冲时间
   * @return redTime
  **/
  @ApiModelProperty(value = "红冲时间")
  public String getRedTime() {
    return redTime;
  }

  public void setRedTime(String redTime) {
    this.redTime = redTime;
  }

  @JsonIgnore
  public MsInvoiceMain redNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
    return this;
  }

   /**
   * 红字信息表编号
   * @return redNotificationNo
  **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getRedNotificationNo() {
    return redNotificationNo;
  }

  public void setRedNotificationNo(String redNotificationNo) {
    this.redNotificationNo = redNotificationNo;
  }

  @JsonIgnore
  public MsInvoiceMain redUserName(String redUserName) {
    this.redUserName = redUserName;
    return this;
  }

   /**
   * 红冲人姓名
   * @return redUserName
  **/
  @ApiModelProperty(value = "红冲人姓名")
  public String getRedUserName() {
    return redUserName;
  }

  public void setRedUserName(String redUserName) {
    this.redUserName = redUserName;
  }

  @JsonIgnore
  public MsInvoiceMain retreatStatus(Integer retreatStatus) {
    this.retreatStatus = retreatStatus;
    return this;
  }

   /**
   * 退票状态  0-未退(默认)  1-已退
   * @return retreatStatus
  **/
  @ApiModelProperty(value = "退票状态  0-未退(默认)  1-已退")
  public Integer getRetreatStatus() {
    return retreatStatus;
  }

  public void setRetreatStatus(Integer retreatStatus) {
    this.retreatStatus = retreatStatus;
  }

  @JsonIgnore
  public MsInvoiceMain retreatTime(String retreatTime) {
    this.retreatTime = retreatTime;
    return this;
  }

   /**
   * 退票操作时间
   * @return retreatTime
  **/
  @ApiModelProperty(value = "退票操作时间")
  public String getRetreatTime() {
    return retreatTime;
  }

  public void setRetreatTime(String retreatTime) {
    this.retreatTime = retreatTime;
  }

  @JsonIgnore
  public MsInvoiceMain retreatUserName(String retreatUserName) {
    this.retreatUserName = retreatUserName;
    return this;
  }

   /**
   * 退票操作人姓名
   * @return retreatUserName
  **/
  @ApiModelProperty(value = "退票操作人姓名")
  public String getRetreatUserName() {
    return retreatUserName;
  }

  public void setRetreatUserName(String retreatUserName) {
    this.retreatUserName = retreatUserName;
  }

  @JsonIgnore
  public MsInvoiceMain matchStatus(Integer matchStatus) {
    this.matchStatus = matchStatus;
    return this;
  }

   /**
   * 发票匹配状态  0-未匹配(默认)  1-匹配中  2-已匹配  3-匹配冲突
   * @return matchStatus
  **/
  @ApiModelProperty(value = "发票匹配状态  0-未匹配(默认)  1-匹配中  2-已匹配  3-匹配冲突")
  public Integer getMatchStatus() {
    return matchStatus;
  }

  public void setMatchStatus(Integer matchStatus) {
    this.matchStatus = matchStatus;
  }

  @JsonIgnore
  public MsInvoiceMain matchTime(String matchTime) {
    this.matchTime = matchTime;
    return this;
  }

   /**
   * 发票匹配操作时间
   * @return matchTime
  **/
  @ApiModelProperty(value = "发票匹配操作时间")
  public String getMatchTime() {
    return matchTime;
  }

  public void setMatchTime(String matchTime) {
    this.matchTime = matchTime;
  }

  @JsonIgnore
  public MsInvoiceMain matchUserName(String matchUserName) {
    this.matchUserName = matchUserName;
    return this;
  }

   /**
   * 发票匹配操作人姓名
   * @return matchUserName
  **/
  @ApiModelProperty(value = "发票匹配操作人姓名")
  public String getMatchUserName() {
    return matchUserName;
  }

  public void setMatchUserName(String matchUserName) {
    this.matchUserName = matchUserName;
  }

  @JsonIgnore
  public MsInvoiceMain chargeUpStatus(Integer chargeUpStatus) {
    this.chargeUpStatus = chargeUpStatus;
    return this;
  }

   /**
   * 记账状态 0-未记账(默认)     1-已记账
   * @return chargeUpStatus
  **/
  @ApiModelProperty(value = "记账状态 0-未记账(默认)     1-已记账")
  public Integer getChargeUpStatus() {
    return chargeUpStatus;
  }

  public void setChargeUpStatus(Integer chargeUpStatus) {
    this.chargeUpStatus = chargeUpStatus;
  }

  @JsonIgnore
  public MsInvoiceMain chargeUpNo(String chargeUpNo) {
    this.chargeUpNo = chargeUpNo;
    return this;
  }

   /**
   * 记账单号
   * @return chargeUpNo
  **/
  @ApiModelProperty(value = "记账单号")
  public String getChargeUpNo() {
    return chargeUpNo;
  }

  public void setChargeUpNo(String chargeUpNo) {
    this.chargeUpNo = chargeUpNo;
  }

  @JsonIgnore
  public MsInvoiceMain chargeUpTime(String chargeUpTime) {
    this.chargeUpTime = chargeUpTime;
    return this;
  }

   /**
   * 记账时间
   * @return chargeUpTime
  **/
  @ApiModelProperty(value = "记账时间")
  public String getChargeUpTime() {
    return chargeUpTime;
  }

  public void setChargeUpTime(String chargeUpTime) {
    this.chargeUpTime = chargeUpTime;
  }

  @JsonIgnore
  public MsInvoiceMain chargeUpPeriod(String chargeUpPeriod) {
    this.chargeUpPeriod = chargeUpPeriod;
    return this;
  }

   /**
   * 记账所属期
   * @return chargeUpPeriod
  **/
  @ApiModelProperty(value = "记账所属期")
  public String getChargeUpPeriod() {
    return chargeUpPeriod;
  }

  public void setChargeUpPeriod(String chargeUpPeriod) {
    this.chargeUpPeriod = chargeUpPeriod;
  }

  @JsonIgnore
  public MsInvoiceMain chargeUpUserName(String chargeUpUserName) {
    this.chargeUpUserName = chargeUpUserName;
    return this;
  }

   /**
   * 记账操作人姓名
   * @return chargeUpUserName
  **/
  @ApiModelProperty(value = "记账操作人姓名")
  public String getChargeUpUserName() {
    return chargeUpUserName;
  }

  public void setChargeUpUserName(String chargeUpUserName) {
    this.chargeUpUserName = chargeUpUserName;
  }

  @JsonIgnore
  public MsInvoiceMain saleConfirmStatus(Integer saleConfirmStatus) {
    this.saleConfirmStatus = saleConfirmStatus;
    return this;
  }

   /**
   * 核销状态 0-未核销 (默认)   1-部分核销  2-已核销
   * @return saleConfirmStatus
  **/
  @ApiModelProperty(value = "核销状态 0-未核销 (默认)   1-部分核销  2-已核销")
  public Integer getSaleConfirmStatus() {
    return saleConfirmStatus;
  }

  public void setSaleConfirmStatus(Integer saleConfirmStatus) {
    this.saleConfirmStatus = saleConfirmStatus;
  }

  @JsonIgnore
  public MsInvoiceMain saleConfirmNo(String saleConfirmNo) {
    this.saleConfirmNo = saleConfirmNo;
    return this;
  }

   /**
   * 核销单号
   * @return saleConfirmNo
  **/
  @ApiModelProperty(value = "核销单号")
  public String getSaleConfirmNo() {
    return saleConfirmNo;
  }

  public void setSaleConfirmNo(String saleConfirmNo) {
    this.saleConfirmNo = saleConfirmNo;
  }

  @JsonIgnore
  public MsInvoiceMain saleConfirmTime(String saleConfirmTime) {
    this.saleConfirmTime = saleConfirmTime;
    return this;
  }

   /**
   * 核销时间
   * @return saleConfirmTime
  **/
  @ApiModelProperty(value = "核销时间")
  public String getSaleConfirmTime() {
    return saleConfirmTime;
  }

  public void setSaleConfirmTime(String saleConfirmTime) {
    this.saleConfirmTime = saleConfirmTime;
  }

  @JsonIgnore
  public MsInvoiceMain saleConfirmPeriod(String saleConfirmPeriod) {
    this.saleConfirmPeriod = saleConfirmPeriod;
    return this;
  }

   /**
   * 核销所属期
   * @return saleConfirmPeriod
  **/
  @ApiModelProperty(value = "核销所属期")
  public String getSaleConfirmPeriod() {
    return saleConfirmPeriod;
  }

  public void setSaleConfirmPeriod(String saleConfirmPeriod) {
    this.saleConfirmPeriod = saleConfirmPeriod;
  }

  @JsonIgnore
  public MsInvoiceMain saleConfirmUserName(String saleConfirmUserName) {
    this.saleConfirmUserName = saleConfirmUserName;
    return this;
  }

   /**
   * 核销操作人姓名
   * @return saleConfirmUserName
  **/
  @ApiModelProperty(value = "核销操作人姓名")
  public String getSaleConfirmUserName() {
    return saleConfirmUserName;
  }

  public void setSaleConfirmUserName(String saleConfirmUserName) {
    this.saleConfirmUserName = saleConfirmUserName;
  }

  @JsonIgnore
  public MsInvoiceMain paymentStatus(Integer paymentStatus) {
    this.paymentStatus = paymentStatus;
    return this;
  }

   /**
   * 付款状态  0-未付款(默认)    1-部分付款 2-已付款
   * @return paymentStatus
  **/
  @ApiModelProperty(value = "付款状态  0-未付款(默认)    1-部分付款 2-已付款")
  public Integer getPaymentStatus() {
    return paymentStatus;
  }

  public void setPaymentStatus(Integer paymentStatus) {
    this.paymentStatus = paymentStatus;
  }

  @JsonIgnore
  public MsInvoiceMain paymentNo(String paymentNo) {
    this.paymentNo = paymentNo;
    return this;
  }

   /**
   * 付款单号
   * @return paymentNo
  **/
  @ApiModelProperty(value = "付款单号")
  public String getPaymentNo() {
    return paymentNo;
  }

  public void setPaymentNo(String paymentNo) {
    this.paymentNo = paymentNo;
  }

  @JsonIgnore
  public MsInvoiceMain paymentDate(String paymentDate) {
    this.paymentDate = paymentDate;
    return this;
  }

   /**
   * 付款日期  格式：YYYYMMDD
   * @return paymentDate
  **/
  @ApiModelProperty(value = "付款日期  格式：YYYYMMDD")
  public String getPaymentDate() {
    return paymentDate;
  }

  public void setPaymentDate(String paymentDate) {
    this.paymentDate = paymentDate;
  }

  @JsonIgnore
  public MsInvoiceMain paymentTime(String paymentTime) {
    this.paymentTime = paymentTime;
    return this;
  }

   /**
   * 付款时间
   * @return paymentTime
  **/
  @ApiModelProperty(value = "付款时间")
  public String getPaymentTime() {
    return paymentTime;
  }

  public void setPaymentTime(String paymentTime) {
    this.paymentTime = paymentTime;
  }

  @JsonIgnore
  public MsInvoiceMain paymentUserName(String paymentUserName) {
    this.paymentUserName = paymentUserName;
    return this;
  }

   /**
   * 付款操作人姓名
   * @return paymentUserName
  **/
  @ApiModelProperty(value = "付款操作人姓名")
  public String getPaymentUserName() {
    return paymentUserName;
  }

  public void setPaymentUserName(String paymentUserName) {
    this.paymentUserName = paymentUserName;
  }

  @JsonIgnore
  public MsInvoiceMain freezeStatus(Integer freezeStatus) {
    this.freezeStatus = freezeStatus;
    return this;
  }

   /**
   * 冻结状态  0-未冻结(默认)    1-已冻结
   * @return freezeStatus
  **/
  @ApiModelProperty(value = "冻结状态  0-未冻结(默认)    1-已冻结")
  public Integer getFreezeStatus() {
    return freezeStatus;
  }

  public void setFreezeStatus(Integer freezeStatus) {
    this.freezeStatus = freezeStatus;
  }

  @JsonIgnore
  public MsInvoiceMain freezeTime(String freezeTime) {
    this.freezeTime = freezeTime;
    return this;
  }

   /**
   * 冻结操作时间
   * @return freezeTime
  **/
  @ApiModelProperty(value = "冻结操作时间")
  public String getFreezeTime() {
    return freezeTime;
  }

  public void setFreezeTime(String freezeTime) {
    this.freezeTime = freezeTime;
  }

  @JsonIgnore
  public MsInvoiceMain freezeUserName(String freezeUserName) {
    this.freezeUserName = freezeUserName;
    return this;
  }

   /**
   * 冻结操作人姓名
   * @return freezeUserName
  **/
  @ApiModelProperty(value = "冻结操作人姓名")
  public String getFreezeUserName() {
    return freezeUserName;
  }

  public void setFreezeUserName(String freezeUserName) {
    this.freezeUserName = freezeUserName;
  }

  @JsonIgnore
  public MsInvoiceMain loseStatus(Integer loseStatus) {
    this.loseStatus = loseStatus;
    return this;
  }

   /**
   * 遗失状态  0-未遗失(默认)    1-已遗失
   * @return loseStatus
  **/
  @ApiModelProperty(value = "遗失状态  0-未遗失(默认)    1-已遗失")
  public Integer getLoseStatus() {
    return loseStatus;
  }

  public void setLoseStatus(Integer loseStatus) {
    this.loseStatus = loseStatus;
  }

  @JsonIgnore
  public MsInvoiceMain loseTime(String loseTime) {
    this.loseTime = loseTime;
    return this;
  }

   /**
   * 遗失操作时间
   * @return loseTime
  **/
  @ApiModelProperty(value = "遗失操作时间")
  public String getLoseTime() {
    return loseTime;
  }

  public void setLoseTime(String loseTime) {
    this.loseTime = loseTime;
  }

  @JsonIgnore
  public MsInvoiceMain loseUserName(String loseUserName) {
    this.loseUserName = loseUserName;
    return this;
  }

   /**
   * 遗失操作人姓名
   * @return loseUserName
  **/
  @ApiModelProperty(value = "遗失操作人姓名")
  public String getLoseUserName() {
    return loseUserName;
  }

  public void setLoseUserName(String loseUserName) {
    this.loseUserName = loseUserName;
  }

  @JsonIgnore
  public MsInvoiceMain blackStatus(Integer blackStatus) {
    this.blackStatus = blackStatus;
    return this;
  }

   /**
   * 失信状态  0-(默认) 1-系统黑名单，2-企业黑名单
   * @return blackStatus
  **/
  @ApiModelProperty(value = "失信状态  0-(默认) 1-系统黑名单，2-企业黑名单")
  public Integer getBlackStatus() {
    return blackStatus;
  }

  public void setBlackStatus(Integer blackStatus) {
    this.blackStatus = blackStatus;
  }

  @JsonIgnore
  public MsInvoiceMain blackRemark(String blackRemark) {
    this.blackRemark = blackRemark;
    return this;
  }

   /**
   * 失信原因
   * @return blackRemark
  **/
  @ApiModelProperty(value = "失信原因")
  public String getBlackRemark() {
    return blackRemark;
  }

  public void setBlackRemark(String blackRemark) {
    this.blackRemark = blackRemark;
  }

  @JsonIgnore
  public MsInvoiceMain bizTag1(String bizTag1) {
    this.bizTag1 = bizTag1;
    return this;
  }

   /**
   * 拓展字段1
   * @return bizTag1
  **/
  @ApiModelProperty(value = "拓展字段1")
  public String getBizTag1() {
    return bizTag1;
  }

  public void setBizTag1(String bizTag1) {
    this.bizTag1 = bizTag1;
  }

  @JsonIgnore
  public MsInvoiceMain bizTag2(String bizTag2) {
    this.bizTag2 = bizTag2;
    return this;
  }

   /**
   * 拓展字段2
   * @return bizTag2
  **/
  @ApiModelProperty(value = "拓展字段2")
  public String getBizTag2() {
    return bizTag2;
  }

  public void setBizTag2(String bizTag2) {
    this.bizTag2 = bizTag2;
  }

  @JsonIgnore
  public MsInvoiceMain bizTag3(String bizTag3) {
    this.bizTag3 = bizTag3;
    return this;
  }

   /**
   * 拓展字段3
   * @return bizTag3
  **/
  @ApiModelProperty(value = "拓展字段3")
  public String getBizTag3() {
    return bizTag3;
  }

  public void setBizTag3(String bizTag3) {
    this.bizTag3 = bizTag3;
  }

  @JsonIgnore
  public MsInvoiceMain originBussinessId(Long originBussinessId) {
    this.originBussinessId = originBussinessId;
    return this;
  }

   /**
   * 原业务单ID
   * @return originBussinessId
  **/
  @ApiModelProperty(value = "原业务单ID")
  public Long getOriginBussinessId() {
    return originBussinessId;
  }

  public void setOriginBussinessId(Long originBussinessId) {
    this.originBussinessId = originBussinessId;
  }

  @JsonIgnore
  public MsInvoiceMain originBussinessNo(String originBussinessNo) {
    this.originBussinessNo = originBussinessNo;
    return this;
  }

   /**
   * 原业务单号
   * @return originBussinessNo
  **/
  @ApiModelProperty(value = "原业务单号")
  public String getOriginBussinessNo() {
    return originBussinessNo;
  }

  public void setOriginBussinessNo(String originBussinessNo) {
    this.originBussinessNo = originBussinessNo;
  }

  @JsonIgnore
  public MsInvoiceMain originInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
    return this;
  }

   /**
   * 原发票号码
   * @return originInvoiceNo
  **/
  @ApiModelProperty(value = "原发票号码")
  public String getOriginInvoiceNo() {
    return originInvoiceNo;
  }

  public void setOriginInvoiceNo(String originInvoiceNo) {
    this.originInvoiceNo = originInvoiceNo;
  }

  @JsonIgnore
  public MsInvoiceMain originInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
    return this;
  }

   /**
   * 原发票代码
   * @return originInvoiceCode
  **/
  @ApiModelProperty(value = "原发票代码")
  public String getOriginInvoiceCode() {
    return originInvoiceCode;
  }

  public void setOriginInvoiceCode(String originInvoiceCode) {
    this.originInvoiceCode = originInvoiceCode;
  }

  @JsonIgnore
  public MsInvoiceMain tpStatus(Integer tpStatus) {
    this.tpStatus = tpStatus;
    return this;
  }

   /**
   * 业务状态（预留）  0-默认
   * @return tpStatus
  **/
  @ApiModelProperty(value = "业务状态（预留）  0-默认")
  public Integer getTpStatus() {
    return tpStatus;
  }

  public void setTpStatus(Integer tpStatus) {
    this.tpStatus = tpStatus;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
    return this;
  }

   /**
   * 购方地址
   * @return purchaserAddress
  **/
  @ApiModelProperty(value = "购方地址")
  public String getPurchaserAddress() {
    return purchaserAddress;
  }

  public void setPurchaserAddress(String purchaserAddress) {
    this.purchaserAddress = purchaserAddress;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
    return this;
  }

   /**
   * 购方电话
   * @return purchaserTel
  **/
  @ApiModelProperty(value = "购方电话")
  public String getPurchaserTel() {
    return purchaserTel;
  }

  public void setPurchaserTel(String purchaserTel) {
    this.purchaserTel = purchaserTel;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
    return this;
  }

   /**
   * 购方地址电话
   * @return purchaserAddrTel
  **/
  @ApiModelProperty(value = "购方地址电话")
  public String getPurchaserAddrTel() {
    return purchaserAddrTel;
  }

  public void setPurchaserAddrTel(String purchaserAddrTel) {
    this.purchaserAddrTel = purchaserAddrTel;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
    return this;
  }

   /**
   * 购方银行名称
   * @return purchaserBankName
  **/
  @ApiModelProperty(value = "购方银行名称")
  public String getPurchaserBankName() {
    return purchaserBankName;
  }

  public void setPurchaserBankName(String purchaserBankName) {
    this.purchaserBankName = purchaserBankName;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
    return this;
  }

   /**
   * 购方银行账号
   * @return purchaserBankAccount
  **/
  @ApiModelProperty(value = "购方银行账号")
  public String getPurchaserBankAccount() {
    return purchaserBankAccount;
  }

  public void setPurchaserBankAccount(String purchaserBankAccount) {
    this.purchaserBankAccount = purchaserBankAccount;
  }

  @JsonIgnore
  public MsInvoiceMain purchaserBankNameAccount(String purchaserBankNameAccount) {
    this.purchaserBankNameAccount = purchaserBankNameAccount;
    return this;
  }

   /**
   * 购方银行名称账号
   * @return purchaserBankNameAccount
  **/
  @ApiModelProperty(value = "购方银行名称账号")
  public String getPurchaserBankNameAccount() {
    return purchaserBankNameAccount;
  }

  public void setPurchaserBankNameAccount(String purchaserBankNameAccount) {
    this.purchaserBankNameAccount = purchaserBankNameAccount;
  }

  @JsonIgnore
  public MsInvoiceMain sellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
    return this;
  }

   /**
   * 销方地址
   * @return sellerAddress
  **/
  @ApiModelProperty(value = "销方地址")
  public String getSellerAddress() {
    return sellerAddress;
  }

  public void setSellerAddress(String sellerAddress) {
    this.sellerAddress = sellerAddress;
  }

  @JsonIgnore
  public MsInvoiceMain sellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
    return this;
  }

   /**
   * 销方电话
   * @return sellerTel
  **/
  @ApiModelProperty(value = "销方电话")
  public String getSellerTel() {
    return sellerTel;
  }

  public void setSellerTel(String sellerTel) {
    this.sellerTel = sellerTel;
  }

  @JsonIgnore
  public MsInvoiceMain sellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
    return this;
  }

   /**
   * 销方地址电话
   * @return sellerAddrTel
  **/
  @ApiModelProperty(value = "销方地址电话")
  public String getSellerAddrTel() {
    return sellerAddrTel;
  }

  public void setSellerAddrTel(String sellerAddrTel) {
    this.sellerAddrTel = sellerAddrTel;
  }

  @JsonIgnore
  public MsInvoiceMain sellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
    return this;
  }

   /**
   * 销方银行名称
   * @return sellerBankName
  **/
  @ApiModelProperty(value = "销方银行名称")
  public String getSellerBankName() {
    return sellerBankName;
  }

  public void setSellerBankName(String sellerBankName) {
    this.sellerBankName = sellerBankName;
  }

  @JsonIgnore
  public MsInvoiceMain sellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
    return this;
  }

   /**
   * 销方银行账号
   * @return sellerBankAccount
  **/
  @ApiModelProperty(value = "销方银行账号")
  public String getSellerBankAccount() {
    return sellerBankAccount;
  }

  public void setSellerBankAccount(String sellerBankAccount) {
    this.sellerBankAccount = sellerBankAccount;
  }

  @JsonIgnore
  public MsInvoiceMain sellerBankNameAccount(String sellerBankNameAccount) {
    this.sellerBankNameAccount = sellerBankNameAccount;
    return this;
  }

   /**
   * 销方银行名称账号
   * @return sellerBankNameAccount
  **/
  @ApiModelProperty(value = "销方银行名称账号")
  public String getSellerBankNameAccount() {
    return sellerBankNameAccount;
  }

  public void setSellerBankNameAccount(String sellerBankNameAccount) {
    this.sellerBankNameAccount = sellerBankNameAccount;
  }

  @JsonIgnore
  public MsInvoiceMain sellerUserId(Long sellerUserId) {
    this.sellerUserId = sellerUserId;
    return this;
  }

   /**
   * 销方开票操作人ID
   * @return sellerUserId
  **/
  @ApiModelProperty(value = "销方开票操作人ID")
  public Long getSellerUserId() {
    return sellerUserId;
  }

  public void setSellerUserId(Long sellerUserId) {
    this.sellerUserId = sellerUserId;
  }

  @JsonIgnore
  public MsInvoiceMain cashierName(String cashierName) {
    this.cashierName = cashierName;
    return this;
  }

   /**
   * 收款人姓名
   * @return cashierName
  **/
  @ApiModelProperty(value = "收款人姓名")
  public String getCashierName() {
    return cashierName;
  }

  public void setCashierName(String cashierName) {
    this.cashierName = cashierName;
  }

  @JsonIgnore
  public MsInvoiceMain checkerName(String checkerName) {
    this.checkerName = checkerName;
    return this;
  }

   /**
   * 复核人姓名
   * @return checkerName
  **/
  @ApiModelProperty(value = "复核人姓名")
  public String getCheckerName() {
    return checkerName;
  }

  public void setCheckerName(String checkerName) {
    this.checkerName = checkerName;
  }

  @JsonIgnore
  public MsInvoiceMain invoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
    return this;
  }

   /**
   * 开票人姓名
   * @return invoicerName
  **/
  @ApiModelProperty(value = "开票人姓名")
  public String getInvoicerName() {
    return invoicerName;
  }

  public void setInvoicerName(String invoicerName) {
    this.invoicerName = invoicerName;
  }

  @JsonIgnore
  public MsInvoiceMain recogUserId(Long recogUserId) {
    this.recogUserId = recogUserId;
    return this;
  }

   /**
   * 识别操作人ID
   * @return recogUserId
  **/
  @ApiModelProperty(value = "识别操作人ID")
  public Long getRecogUserId() {
    return recogUserId;
  }

  public void setRecogUserId(Long recogUserId) {
    this.recogUserId = recogUserId;
  }

  @JsonIgnore
  public MsInvoiceMain recogDeductionImageUrl(String recogDeductionImageUrl) {
    this.recogDeductionImageUrl = recogDeductionImageUrl;
    return this;
  }

   /**
   * 识别影像抵扣联路径
   * @return recogDeductionImageUrl
  **/
  @ApiModelProperty(value = "识别影像抵扣联路径")
  public String getRecogDeductionImageUrl() {
    return recogDeductionImageUrl;
  }

  public void setRecogDeductionImageUrl(String recogDeductionImageUrl) {
    this.recogDeductionImageUrl = recogDeductionImageUrl;
  }

  @JsonIgnore
  public MsInvoiceMain recogInvoiceImageUrl(String recogInvoiceImageUrl) {
    this.recogInvoiceImageUrl = recogInvoiceImageUrl;
    return this;
  }

   /**
   * 识别影像发票联路径
   * @return recogInvoiceImageUrl
  **/
  @ApiModelProperty(value = "识别影像发票联路径")
  public String getRecogInvoiceImageUrl() {
    return recogInvoiceImageUrl;
  }

  public void setRecogInvoiceImageUrl(String recogInvoiceImageUrl) {
    this.recogInvoiceImageUrl = recogInvoiceImageUrl;
  }

  @JsonIgnore
  public MsInvoiceMain pdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
    return this;
  }

   /**
   * PDF文件地址
   * @return pdfUrl
  **/
  @ApiModelProperty(value = "PDF文件地址")
  public String getPdfUrl() {
    return pdfUrl;
  }

  public void setPdfUrl(String pdfUrl) {
    this.pdfUrl = pdfUrl;
  }

  @JsonIgnore
  public MsInvoiceMain vehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
    return this;
  }

   /**
   * 车辆类型
   * @return vehicleType
  **/
  @ApiModelProperty(value = "车辆类型")
  public String getVehicleType() {
    return vehicleType;
  }

  public void setVehicleType(String vehicleType) {
    this.vehicleType = vehicleType;
  }

  @JsonIgnore
  public MsInvoiceMain vehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
    return this;
  }

   /**
   * 厂牌型号
   * @return vehicleBrand
  **/
  @ApiModelProperty(value = "厂牌型号")
  public String getVehicleBrand() {
    return vehicleBrand;
  }

  public void setVehicleBrand(String vehicleBrand) {
    this.vehicleBrand = vehicleBrand;
  }

  @JsonIgnore
  public MsInvoiceMain productionArea(String productionArea) {
    this.productionArea = productionArea;
    return this;
  }

   /**
   * 产地
   * @return productionArea
  **/
  @ApiModelProperty(value = "产地")
  public String getProductionArea() {
    return productionArea;
  }

  public void setProductionArea(String productionArea) {
    this.productionArea = productionArea;
  }

  @JsonIgnore
  public MsInvoiceMain certNo(String certNo) {
    this.certNo = certNo;
    return this;
  }

   /**
   * 合格证号
   * @return certNo
  **/
  @ApiModelProperty(value = "合格证号")
  public String getCertNo() {
    return certNo;
  }

  public void setCertNo(String certNo) {
    this.certNo = certNo;
  }

  @JsonIgnore
  public MsInvoiceMain importCertNo(String importCertNo) {
    this.importCertNo = importCertNo;
    return this;
  }

   /**
   * 进口证明书编号
   * @return importCertNo
  **/
  @ApiModelProperty(value = "进口证明书编号")
  public String getImportCertNo() {
    return importCertNo;
  }

  public void setImportCertNo(String importCertNo) {
    this.importCertNo = importCertNo;
  }

  @JsonIgnore
  public MsInvoiceMain inspectionNo(String inspectionNo) {
    this.inspectionNo = inspectionNo;
    return this;
  }

   /**
   * 商检单号
   * @return inspectionNo
  **/
  @ApiModelProperty(value = "商检单号")
  public String getInspectionNo() {
    return inspectionNo;
  }

  public void setInspectionNo(String inspectionNo) {
    this.inspectionNo = inspectionNo;
  }

  @JsonIgnore
  public MsInvoiceMain engineNo(String engineNo) {
    this.engineNo = engineNo;
    return this;
  }

   /**
   * 发动机号码
   * @return engineNo
  **/
  @ApiModelProperty(value = "发动机号码")
  public String getEngineNo() {
    return engineNo;
  }

  public void setEngineNo(String engineNo) {
    this.engineNo = engineNo;
  }

  @JsonIgnore
  public MsInvoiceMain organizationCode(String organizationCode) {
    this.organizationCode = organizationCode;
    return this;
  }

   /**
   * 身份证号码/组织机构码
   * @return organizationCode
  **/
  @ApiModelProperty(value = "身份证号码/组织机构码")
  public String getOrganizationCode() {
    return organizationCode;
  }

  public void setOrganizationCode(String organizationCode) {
    this.organizationCode = organizationCode;
  }

  @JsonIgnore
  public MsInvoiceMain vin(String vin) {
    this.vin = vin;
    return this;
  }

   /**
   * 车辆识别代号/车架号码
   * @return vin
  **/
  @ApiModelProperty(value = "车辆识别代号/车架号码")
  public String getVin() {
    return vin;
  }

  public void setVin(String vin) {
    this.vin = vin;
  }

  @JsonIgnore
  public MsInvoiceMain tonnage(String tonnage) {
    this.tonnage = tonnage;
    return this;
  }

   /**
   * 吨位
   * @return tonnage
  **/
  @ApiModelProperty(value = "吨位")
  public String getTonnage() {
    return tonnage;
  }

  public void setTonnage(String tonnage) {
    this.tonnage = tonnage;
  }

  @JsonIgnore
  public MsInvoiceMain taxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
    return this;
  }

   /**
   * 完税凭证号
   * @return taxPaidProof
  **/
  @ApiModelProperty(value = "完税凭证号")
  public String getTaxPaidProof() {
    return taxPaidProof;
  }

  public void setTaxPaidProof(String taxPaidProof) {
    this.taxPaidProof = taxPaidProof;
  }

  @JsonIgnore
  public MsInvoiceMain maxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
    return this;
  }

   /**
   * 限乘人数
   * @return maxCapacity
  **/
  @ApiModelProperty(value = "限乘人数")
  public String getMaxCapacity() {
    return maxCapacity;
  }

  public void setMaxCapacity(String maxCapacity) {
    this.maxCapacity = maxCapacity;
  }

  @JsonIgnore
  public MsInvoiceMain taxAuthName(String taxAuthName) {
    this.taxAuthName = taxAuthName;
    return this;
  }

   /**
   * 主管税务机关名称
   * @return taxAuthName
  **/
  @ApiModelProperty(value = "主管税务机关名称")
  public String getTaxAuthName() {
    return taxAuthName;
  }

  public void setTaxAuthName(String taxAuthName) {
    this.taxAuthName = taxAuthName;
  }

  @JsonIgnore
  public MsInvoiceMain taxAuthCode(String taxAuthCode) {
    this.taxAuthCode = taxAuthCode;
    return this;
  }

   /**
   * 主管税务机关代码
   * @return taxAuthCode
  **/
  @ApiModelProperty(value = "主管税务机关代码")
  public String getTaxAuthCode() {
    return taxAuthCode;
  }

  public void setTaxAuthCode(String taxAuthCode) {
    this.taxAuthCode = taxAuthCode;
  }

  @JsonIgnore
  public MsInvoiceMain veriUserId(Long veriUserId) {
    this.veriUserId = veriUserId;
    return this;
  }

   /**
   * 查验操作人ID
   * @return veriUserId
  **/
  @ApiModelProperty(value = "查验操作人ID")
  public Long getVeriUserId() {
    return veriUserId;
  }

  public void setVeriUserId(Long veriUserId) {
    this.veriUserId = veriUserId;
  }

  @JsonIgnore
  public MsInvoiceMain veriRemark(String veriRemark) {
    this.veriRemark = veriRemark;
    return this;
  }

   /**
   * 查验备注
   * @return veriRemark
  **/
  @ApiModelProperty(value = "查验备注")
  public String getVeriRemark() {
    return veriRemark;
  }

  public void setVeriRemark(String veriRemark) {
    this.veriRemark = veriRemark;
  }

  @JsonIgnore
  public MsInvoiceMain authRequestUserId(Long authRequestUserId) {
    this.authRequestUserId = authRequestUserId;
    return this;
  }

   /**
   * 认证操作员ID
   * @return authRequestUserId
  **/
  @ApiModelProperty(value = "认证操作员ID")
  public Long getAuthRequestUserId() {
    return authRequestUserId;
  }

  public void setAuthRequestUserId(Long authRequestUserId) {
    this.authRequestUserId = authRequestUserId;
  }

  @JsonIgnore
  public MsInvoiceMain authRemark(String authRemark) {
    this.authRemark = authRemark;
    return this;
  }

   /**
   * 认证备注
   * @return authRemark
  **/
  @ApiModelProperty(value = "认证备注")
  public String getAuthRemark() {
    return authRemark;
  }

  public void setAuthRemark(String authRemark) {
    this.authRemark = authRemark;
  }

  @JsonIgnore
  public MsInvoiceMain redUserId(Long redUserId) {
    this.redUserId = redUserId;
    return this;
  }

   /**
   * 红冲人ID
   * @return redUserId
  **/
  @ApiModelProperty(value = "红冲人ID")
  public Long getRedUserId() {
    return redUserId;
  }

  public void setRedUserId(Long redUserId) {
    this.redUserId = redUserId;
  }

  @JsonIgnore
  public MsInvoiceMain redRemark(String redRemark) {
    this.redRemark = redRemark;
    return this;
  }

   /**
   * 红冲备注
   * @return redRemark
  **/
  @ApiModelProperty(value = "红冲备注")
  public String getRedRemark() {
    return redRemark;
  }

  public void setRedRemark(String redRemark) {
    this.redRemark = redRemark;
  }

  @JsonIgnore
  public MsInvoiceMain retreatUserId(Long retreatUserId) {
    this.retreatUserId = retreatUserId;
    return this;
  }

   /**
   * 退票操作人ID
   * @return retreatUserId
  **/
  @ApiModelProperty(value = "退票操作人ID")
  public Long getRetreatUserId() {
    return retreatUserId;
  }

  public void setRetreatUserId(Long retreatUserId) {
    this.retreatUserId = retreatUserId;
  }

  @JsonIgnore
  public MsInvoiceMain retreatRemark(String retreatRemark) {
    this.retreatRemark = retreatRemark;
    return this;
  }

   /**
   * 退票备注
   * @return retreatRemark
  **/
  @ApiModelProperty(value = "退票备注")
  public String getRetreatRemark() {
    return retreatRemark;
  }

  public void setRetreatRemark(String retreatRemark) {
    this.retreatRemark = retreatRemark;
  }

  @JsonIgnore
  public MsInvoiceMain matchUserId(Long matchUserId) {
    this.matchUserId = matchUserId;
    return this;
  }

   /**
   * 发票匹配操作人ID
   * @return matchUserId
  **/
  @ApiModelProperty(value = "发票匹配操作人ID")
  public Long getMatchUserId() {
    return matchUserId;
  }

  public void setMatchUserId(Long matchUserId) {
    this.matchUserId = matchUserId;
  }

  @JsonIgnore
  public MsInvoiceMain matchRemark(String matchRemark) {
    this.matchRemark = matchRemark;
    return this;
  }

   /**
   * 发票匹配备注
   * @return matchRemark
  **/
  @ApiModelProperty(value = "发票匹配备注")
  public String getMatchRemark() {
    return matchRemark;
  }

  public void setMatchRemark(String matchRemark) {
    this.matchRemark = matchRemark;
  }

  @JsonIgnore
  public MsInvoiceMain chargeUpUserId(Long chargeUpUserId) {
    this.chargeUpUserId = chargeUpUserId;
    return this;
  }

   /**
   * 记账操作人ID
   * @return chargeUpUserId
  **/
  @ApiModelProperty(value = "记账操作人ID")
  public Long getChargeUpUserId() {
    return chargeUpUserId;
  }

  public void setChargeUpUserId(Long chargeUpUserId) {
    this.chargeUpUserId = chargeUpUserId;
  }

  @JsonIgnore
  public MsInvoiceMain chargeUpRemark(String chargeUpRemark) {
    this.chargeUpRemark = chargeUpRemark;
    return this;
  }

   /**
   * 记账备注
   * @return chargeUpRemark
  **/
  @ApiModelProperty(value = "记账备注")
  public String getChargeUpRemark() {
    return chargeUpRemark;
  }

  public void setChargeUpRemark(String chargeUpRemark) {
    this.chargeUpRemark = chargeUpRemark;
  }

  @JsonIgnore
  public MsInvoiceMain saleConfirmUserId(Long saleConfirmUserId) {
    this.saleConfirmUserId = saleConfirmUserId;
    return this;
  }

   /**
   * 核销操作人ID
   * @return saleConfirmUserId
  **/
  @ApiModelProperty(value = "核销操作人ID")
  public Long getSaleConfirmUserId() {
    return saleConfirmUserId;
  }

  public void setSaleConfirmUserId(Long saleConfirmUserId) {
    this.saleConfirmUserId = saleConfirmUserId;
  }

  @JsonIgnore
  public MsInvoiceMain saleConfirmRemark(String saleConfirmRemark) {
    this.saleConfirmRemark = saleConfirmRemark;
    return this;
  }

   /**
   * 核销备注
   * @return saleConfirmRemark
  **/
  @ApiModelProperty(value = "核销备注")
  public String getSaleConfirmRemark() {
    return saleConfirmRemark;
  }

  public void setSaleConfirmRemark(String saleConfirmRemark) {
    this.saleConfirmRemark = saleConfirmRemark;
  }

  @JsonIgnore
  public MsInvoiceMain paymentUserId(Long paymentUserId) {
    this.paymentUserId = paymentUserId;
    return this;
  }

   /**
   * 付款操作人ID
   * @return paymentUserId
  **/
  @ApiModelProperty(value = "付款操作人ID")
  public Long getPaymentUserId() {
    return paymentUserId;
  }

  public void setPaymentUserId(Long paymentUserId) {
    this.paymentUserId = paymentUserId;
  }

  @JsonIgnore
  public MsInvoiceMain paymentRemark(String paymentRemark) {
    this.paymentRemark = paymentRemark;
    return this;
  }

   /**
   * 付款备注
   * @return paymentRemark
  **/
  @ApiModelProperty(value = "付款备注")
  public String getPaymentRemark() {
    return paymentRemark;
  }

  public void setPaymentRemark(String paymentRemark) {
    this.paymentRemark = paymentRemark;
  }

  @JsonIgnore
  public MsInvoiceMain freezeUserId(Long freezeUserId) {
    this.freezeUserId = freezeUserId;
    return this;
  }

   /**
   * 冻结操作人ID
   * @return freezeUserId
  **/
  @ApiModelProperty(value = "冻结操作人ID")
  public Long getFreezeUserId() {
    return freezeUserId;
  }

  public void setFreezeUserId(Long freezeUserId) {
    this.freezeUserId = freezeUserId;
  }

  @JsonIgnore
  public MsInvoiceMain freezeRemark(String freezeRemark) {
    this.freezeRemark = freezeRemark;
    return this;
  }

   /**
   * 冻结备注
   * @return freezeRemark
  **/
  @ApiModelProperty(value = "冻结备注")
  public String getFreezeRemark() {
    return freezeRemark;
  }

  public void setFreezeRemark(String freezeRemark) {
    this.freezeRemark = freezeRemark;
  }

  @JsonIgnore
  public MsInvoiceMain loseUserId(Long loseUserId) {
    this.loseUserId = loseUserId;
    return this;
  }

   /**
   * 遗失操作人ID
   * @return loseUserId
  **/
  @ApiModelProperty(value = "遗失操作人ID")
  public Long getLoseUserId() {
    return loseUserId;
  }

  public void setLoseUserId(Long loseUserId) {
    this.loseUserId = loseUserId;
  }

  @JsonIgnore
  public MsInvoiceMain loseRemark(String loseRemark) {
    this.loseRemark = loseRemark;
    return this;
  }

   /**
   * 遗失备注
   * @return loseRemark
  **/
  @ApiModelProperty(value = "遗失备注")
  public String getLoseRemark() {
    return loseRemark;
  }

  public void setLoseRemark(String loseRemark) {
    this.loseRemark = loseRemark;
  }

  @JsonIgnore
  public MsInvoiceMain remark(String remark) {
    this.remark = remark;
    return this;
  }

   /**
   * 发票备注
   * @return remark
  **/
  @ApiModelProperty(value = "发票备注")
  public String getRemark() {
    return remark;
  }

  public void setRemark(String remark) {
    this.remark = remark;
  }

  @JsonIgnore
  public MsInvoiceMain noComplianceDesc(List<String> noComplianceDesc) {
    this.noComplianceDesc = noComplianceDesc;
    return this;
  }

  public MsInvoiceMain addNoComplianceDescItem(String noComplianceDescItem) {
    this.noComplianceDesc.add(noComplianceDescItem);
    return this;
  }

   /**
   * 不合规原因
   * @return noComplianceDesc
  **/
  @ApiModelProperty(value = "不合规原因")
  public List<String> getNoComplianceDesc() {
    return noComplianceDesc;
  }

  public void setNoComplianceDesc(List<String> noComplianceDesc) {
    this.noComplianceDesc = noComplianceDesc;
  }

  @JsonIgnore
  public MsInvoiceMain imageNum(Integer imageNum) {
    this.imageNum = imageNum;
    return this;
  }

   /**
   * 影像数
   * @return imageNum
  **/
  @ApiModelProperty(value = "影像数")
  public Integer getImageNum() {
    return imageNum;
  }

  public void setImageNum(Integer imageNum) {
    this.imageNum = imageNum;
  }

  @JsonIgnore
  public MsInvoiceMain cooperationFlag(Boolean cooperationFlag) {
    this.cooperationFlag = cooperationFlag;
    return this;
  }

   /**
   * 购销方协同 true-是，false-否
   * @return cooperationFlag
  **/
  @ApiModelProperty(value = "购销方协同 true-是，false-否")
  public Boolean getCooperationFlag() {
    return cooperationFlag;
  }

  public void setCooperationFlag(Boolean cooperationFlag) {
    this.cooperationFlag = cooperationFlag;
  }

  @JsonIgnore
  public MsInvoiceMain authWarningDays(Integer authWarningDays) {
    this.authWarningDays = authWarningDays;
    return this;
  }

   /**
   * 预警天数
   * @return authWarningDays
  **/
  @ApiModelProperty(value = "预警天数")
  public Integer getAuthWarningDays() {
    return authWarningDays;
  }

  public void setAuthWarningDays(Integer authWarningDays) {
    this.authWarningDays = authWarningDays;
  }

  @JsonIgnore
  public MsInvoiceMain remarkFlag(Boolean remarkFlag) {
    this.remarkFlag = remarkFlag;
    return this;
  }

   /**
   * 显示提示信息 true-是，false-否
   * @return remarkFlag
  **/
  @ApiModelProperty(value = "显示提示信息 true-是，false-否")
  public Boolean getRemarkFlag() {
    return remarkFlag;
  }

  public void setRemarkFlag(Boolean remarkFlag) {
    this.remarkFlag = remarkFlag;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceMain invoiceMain = (MsInvoiceMain) o;
    return Objects.equals(this.invoiceId, invoiceMain.invoiceId) &&
        Objects.equals(this.invoiceType, invoiceMain.invoiceType) &&
        Objects.equals(this.invoiceNo, invoiceMain.invoiceNo) &&
        Objects.equals(this.invoiceCode, invoiceMain.invoiceCode) &&
        Objects.equals(this.status, invoiceMain.status) &&
        Objects.equals(this.createTime, invoiceMain.createTime) &&
        Objects.equals(this.updateTime, invoiceMain.updateTime) &&
        Objects.equals(this.createUserId, invoiceMain.createUserId) &&
        Objects.equals(this.createUserName, invoiceMain.createUserName) &&
        Objects.equals(this.updateUserId, invoiceMain.updateUserId) &&
        Objects.equals(this.updateUserName, invoiceMain.updateUserName) &&
        Objects.equals(this.bussinessId, invoiceMain.bussinessId) &&
        Objects.equals(this.bussinessNo, invoiceMain.bussinessNo) &&
        Objects.equals(this.purchaserName, invoiceMain.purchaserName) &&
        Objects.equals(this.purchaserTaxNo, invoiceMain.purchaserTaxNo) &&
        Objects.equals(this.purchaserGroupId, invoiceMain.purchaserGroupId) &&
        Objects.equals(this.purchaserOrgId, invoiceMain.purchaserOrgId) &&
        Objects.equals(this.purchaserExternalCode, invoiceMain.purchaserExternalCode) &&
        Objects.equals(this.purchaserLabel, invoiceMain.purchaserLabel) &&
        Objects.equals(this.sellerName, invoiceMain.sellerName) &&
        Objects.equals(this.sellerTaxNo, invoiceMain.sellerTaxNo) &&
        Objects.equals(this.sellerRootOrgId, invoiceMain.sellerRootOrgId) &&
        Objects.equals(this.sellerOrgId, invoiceMain.sellerOrgId) &&
        Objects.equals(this.sellerExternalCode, invoiceMain.sellerExternalCode) &&
        Objects.equals(this.sellerInvoiceId, invoiceMain.sellerInvoiceId) &&
        Objects.equals(this.sellerUserName, invoiceMain.sellerUserName) &&
        Objects.equals(this.sellerViewImageFlag, invoiceMain.sellerViewImageFlag) &&
        Objects.equals(this.invoiceColor, invoiceMain.invoiceColor) &&
        Objects.equals(this.sellerSyncStatus, invoiceMain.sellerSyncStatus) &&
        Objects.equals(this.sellerSyncTime, invoiceMain.sellerSyncTime) &&
        Objects.equals(this.sellerLabel, invoiceMain.sellerLabel) &&
        Objects.equals(this.taxRate, invoiceMain.taxRate) &&
        Objects.equals(this.amountWithoutTax, invoiceMain.amountWithoutTax) &&
        Objects.equals(this.taxAmount, invoiceMain.taxAmount) &&
        Objects.equals(this.amountWithTax, invoiceMain.amountWithTax) &&
        Objects.equals(this.amountWithTaxCapital, invoiceMain.amountWithTaxCapital) &&
        Objects.equals(this.paperDrewDate, invoiceMain.paperDrewDate) &&
        Objects.equals(this.machineCode, invoiceMain.machineCode) &&
        Objects.equals(this.checkCode, invoiceMain.checkCode) &&
        Objects.equals(this.cipherText, invoiceMain.cipherText) &&
        Objects.equals(this.invoiceOrig, invoiceMain.invoiceOrig) &&
        Objects.equals(this.specialInvoiceFlag, invoiceMain.specialInvoiceFlag) &&
        Objects.equals(this.titleOkFlag, invoiceMain.titleOkFlag) &&
        Objects.equals(this.saleListFlag, invoiceMain.saleListFlag) &&
        Objects.equals(this.dataOkFlag, invoiceMain.dataOkFlag) &&
        Objects.equals(this.recogStatus, invoiceMain.recogStatus) &&
        Objects.equals(this.recogInvoiceId, invoiceMain.recogInvoiceId) &&
        Objects.equals(this.recogResponseTime, invoiceMain.recogResponseTime) &&
        Objects.equals(this.recogUserName, invoiceMain.recogUserName) &&
        Objects.equals(this.recogUploadNum, invoiceMain.recogUploadNum) &&
        Objects.equals(this.complianceStatus, invoiceMain.complianceStatus) &&
        Objects.equals(this.taxInvoiceId, invoiceMain.taxInvoiceId) &&
        Objects.equals(this.authSyncStatus, invoiceMain.authSyncStatus) &&
        Objects.equals(this.authSyncTime, invoiceMain.authSyncTime) &&
        Objects.equals(this.veriInvoiceId, invoiceMain.veriInvoiceId) &&
        Objects.equals(this.veriStatus, invoiceMain.veriStatus) &&
        Objects.equals(this.veriRequestTime, invoiceMain.veriRequestTime) &&
        Objects.equals(this.veriResponseTime, invoiceMain.veriResponseTime) &&
        Objects.equals(this.veriUserName, invoiceMain.veriUserName) &&
        Objects.equals(this.authStatus, invoiceMain.authStatus) &&
        Objects.equals(this.authStyle, invoiceMain.authStyle) &&
        Objects.equals(this.authBussiDate, invoiceMain.authBussiDate) &&
        Objects.equals(this.authTaxPeriod, invoiceMain.authTaxPeriod) &&
        Objects.equals(this.authRequestTime, invoiceMain.authRequestTime) &&
        Objects.equals(this.authResponseTime, invoiceMain.authResponseTime) &&
        Objects.equals(this.authRequestUserName, invoiceMain.authRequestUserName) &&
        Objects.equals(this.redStatus, invoiceMain.redStatus) &&
        Objects.equals(this.redTime, invoiceMain.redTime) &&
        Objects.equals(this.redNotificationNo, invoiceMain.redNotificationNo) &&
        Objects.equals(this.redUserName, invoiceMain.redUserName) &&
        Objects.equals(this.retreatStatus, invoiceMain.retreatStatus) &&
        Objects.equals(this.retreatTime, invoiceMain.retreatTime) &&
        Objects.equals(this.retreatUserName, invoiceMain.retreatUserName) &&
        Objects.equals(this.matchStatus, invoiceMain.matchStatus) &&
        Objects.equals(this.matchTime, invoiceMain.matchTime) &&
        Objects.equals(this.matchUserName, invoiceMain.matchUserName) &&
        Objects.equals(this.chargeUpStatus, invoiceMain.chargeUpStatus) &&
        Objects.equals(this.chargeUpNo, invoiceMain.chargeUpNo) &&
        Objects.equals(this.chargeUpTime, invoiceMain.chargeUpTime) &&
        Objects.equals(this.chargeUpPeriod, invoiceMain.chargeUpPeriod) &&
        Objects.equals(this.chargeUpUserName, invoiceMain.chargeUpUserName) &&
        Objects.equals(this.saleConfirmStatus, invoiceMain.saleConfirmStatus) &&
        Objects.equals(this.saleConfirmNo, invoiceMain.saleConfirmNo) &&
        Objects.equals(this.saleConfirmTime, invoiceMain.saleConfirmTime) &&
        Objects.equals(this.saleConfirmPeriod, invoiceMain.saleConfirmPeriod) &&
        Objects.equals(this.saleConfirmUserName, invoiceMain.saleConfirmUserName) &&
        Objects.equals(this.paymentStatus, invoiceMain.paymentStatus) &&
        Objects.equals(this.paymentNo, invoiceMain.paymentNo) &&
        Objects.equals(this.paymentDate, invoiceMain.paymentDate) &&
        Objects.equals(this.paymentTime, invoiceMain.paymentTime) &&
        Objects.equals(this.paymentUserName, invoiceMain.paymentUserName) &&
        Objects.equals(this.freezeStatus, invoiceMain.freezeStatus) &&
        Objects.equals(this.freezeTime, invoiceMain.freezeTime) &&
        Objects.equals(this.freezeUserName, invoiceMain.freezeUserName) &&
        Objects.equals(this.loseStatus, invoiceMain.loseStatus) &&
        Objects.equals(this.loseTime, invoiceMain.loseTime) &&
        Objects.equals(this.loseUserName, invoiceMain.loseUserName) &&
        Objects.equals(this.blackStatus, invoiceMain.blackStatus) &&
        Objects.equals(this.blackRemark, invoiceMain.blackRemark) &&
        Objects.equals(this.bizTag1, invoiceMain.bizTag1) &&
        Objects.equals(this.bizTag2, invoiceMain.bizTag2) &&
        Objects.equals(this.bizTag3, invoiceMain.bizTag3) &&
        Objects.equals(this.originBussinessId, invoiceMain.originBussinessId) &&
        Objects.equals(this.originBussinessNo, invoiceMain.originBussinessNo) &&
        Objects.equals(this.originInvoiceNo, invoiceMain.originInvoiceNo) &&
        Objects.equals(this.originInvoiceCode, invoiceMain.originInvoiceCode) &&
        Objects.equals(this.tpStatus, invoiceMain.tpStatus) &&
        Objects.equals(this.purchaserAddress, invoiceMain.purchaserAddress) &&
        Objects.equals(this.purchaserTel, invoiceMain.purchaserTel) &&
        Objects.equals(this.purchaserAddrTel, invoiceMain.purchaserAddrTel) &&
        Objects.equals(this.purchaserBankName, invoiceMain.purchaserBankName) &&
        Objects.equals(this.purchaserBankAccount, invoiceMain.purchaserBankAccount) &&
        Objects.equals(this.purchaserBankNameAccount, invoiceMain.purchaserBankNameAccount) &&
        Objects.equals(this.sellerAddress, invoiceMain.sellerAddress) &&
        Objects.equals(this.sellerTel, invoiceMain.sellerTel) &&
        Objects.equals(this.sellerAddrTel, invoiceMain.sellerAddrTel) &&
        Objects.equals(this.sellerBankName, invoiceMain.sellerBankName) &&
        Objects.equals(this.sellerBankAccount, invoiceMain.sellerBankAccount) &&
        Objects.equals(this.sellerBankNameAccount, invoiceMain.sellerBankNameAccount) &&
        Objects.equals(this.sellerUserId, invoiceMain.sellerUserId) &&
        Objects.equals(this.cashierName, invoiceMain.cashierName) &&
        Objects.equals(this.checkerName, invoiceMain.checkerName) &&
        Objects.equals(this.invoicerName, invoiceMain.invoicerName) &&
        Objects.equals(this.recogUserId, invoiceMain.recogUserId) &&
        Objects.equals(this.recogDeductionImageUrl, invoiceMain.recogDeductionImageUrl) &&
        Objects.equals(this.recogInvoiceImageUrl, invoiceMain.recogInvoiceImageUrl) &&
        Objects.equals(this.pdfUrl, invoiceMain.pdfUrl) &&
        Objects.equals(this.vehicleType, invoiceMain.vehicleType) &&
        Objects.equals(this.vehicleBrand, invoiceMain.vehicleBrand) &&
        Objects.equals(this.productionArea, invoiceMain.productionArea) &&
        Objects.equals(this.certNo, invoiceMain.certNo) &&
        Objects.equals(this.importCertNo, invoiceMain.importCertNo) &&
        Objects.equals(this.inspectionNo, invoiceMain.inspectionNo) &&
        Objects.equals(this.engineNo, invoiceMain.engineNo) &&
        Objects.equals(this.organizationCode, invoiceMain.organizationCode) &&
        Objects.equals(this.vin, invoiceMain.vin) &&
        Objects.equals(this.tonnage, invoiceMain.tonnage) &&
        Objects.equals(this.taxPaidProof, invoiceMain.taxPaidProof) &&
        Objects.equals(this.maxCapacity, invoiceMain.maxCapacity) &&
        Objects.equals(this.taxAuthName, invoiceMain.taxAuthName) &&
        Objects.equals(this.taxAuthCode, invoiceMain.taxAuthCode) &&
        Objects.equals(this.veriUserId, invoiceMain.veriUserId) &&
        Objects.equals(this.veriRemark, invoiceMain.veriRemark) &&
        Objects.equals(this.authRequestUserId, invoiceMain.authRequestUserId) &&
        Objects.equals(this.authRemark, invoiceMain.authRemark) &&
        Objects.equals(this.redUserId, invoiceMain.redUserId) &&
        Objects.equals(this.redRemark, invoiceMain.redRemark) &&
        Objects.equals(this.retreatUserId, invoiceMain.retreatUserId) &&
        Objects.equals(this.retreatRemark, invoiceMain.retreatRemark) &&
        Objects.equals(this.matchUserId, invoiceMain.matchUserId) &&
        Objects.equals(this.matchRemark, invoiceMain.matchRemark) &&
        Objects.equals(this.chargeUpUserId, invoiceMain.chargeUpUserId) &&
        Objects.equals(this.chargeUpRemark, invoiceMain.chargeUpRemark) &&
        Objects.equals(this.saleConfirmUserId, invoiceMain.saleConfirmUserId) &&
        Objects.equals(this.saleConfirmRemark, invoiceMain.saleConfirmRemark) &&
        Objects.equals(this.paymentUserId, invoiceMain.paymentUserId) &&
        Objects.equals(this.paymentRemark, invoiceMain.paymentRemark) &&
        Objects.equals(this.freezeUserId, invoiceMain.freezeUserId) &&
        Objects.equals(this.freezeRemark, invoiceMain.freezeRemark) &&
        Objects.equals(this.loseUserId, invoiceMain.loseUserId) &&
        Objects.equals(this.loseRemark, invoiceMain.loseRemark) &&
        Objects.equals(this.remark, invoiceMain.remark) &&
        Objects.equals(this.noComplianceDesc, invoiceMain.noComplianceDesc) &&
        Objects.equals(this.imageNum, invoiceMain.imageNum) &&
        Objects.equals(this.cooperationFlag, invoiceMain.cooperationFlag) &&
        Objects.equals(this.authWarningDays, invoiceMain.authWarningDays) &&
        Objects.equals(this.remarkFlag, invoiceMain.remarkFlag);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, invoiceType, invoiceNo, invoiceCode, status, createTime, updateTime, createUserId, createUserName, updateUserId, updateUserName, bussinessId, bussinessNo, purchaserName, purchaserTaxNo, purchaserGroupId, purchaserOrgId, purchaserExternalCode, purchaserLabel, sellerName, sellerTaxNo, sellerRootOrgId, sellerOrgId, sellerExternalCode, sellerInvoiceId, sellerUserName, sellerViewImageFlag, invoiceColor, sellerSyncStatus, sellerSyncTime, sellerLabel, taxRate, amountWithoutTax, taxAmount, amountWithTax, amountWithTaxCapital, paperDrewDate, machineCode, checkCode, cipherText, invoiceOrig, specialInvoiceFlag, titleOkFlag, saleListFlag, dataOkFlag, recogStatus, recogInvoiceId, recogResponseTime, recogUserName, recogUploadNum, complianceStatus, taxInvoiceId, authSyncStatus, authSyncTime, veriInvoiceId, veriStatus, veriRequestTime, veriResponseTime, veriUserName, authStatus, authStyle, authBussiDate, authTaxPeriod, authRequestTime, authResponseTime, authRequestUserName, redStatus, redTime, redNotificationNo, redUserName, retreatStatus, retreatTime, retreatUserName, matchStatus, matchTime, matchUserName, chargeUpStatus, chargeUpNo, chargeUpTime, chargeUpPeriod, chargeUpUserName, saleConfirmStatus, saleConfirmNo, saleConfirmTime, saleConfirmPeriod, saleConfirmUserName, paymentStatus, paymentNo, paymentDate, paymentTime, paymentUserName, freezeStatus, freezeTime, freezeUserName, loseStatus, loseTime, loseUserName, blackStatus, blackRemark, bizTag1, bizTag2, bizTag3, originBussinessId, originBussinessNo, originInvoiceNo, originInvoiceCode, tpStatus, purchaserAddress, purchaserTel, purchaserAddrTel, purchaserBankName, purchaserBankAccount, purchaserBankNameAccount, sellerAddress, sellerTel, sellerAddrTel, sellerBankName, sellerBankAccount, sellerBankNameAccount, sellerUserId, cashierName, checkerName, invoicerName, recogUserId, recogDeductionImageUrl, recogInvoiceImageUrl, pdfUrl, vehicleType, vehicleBrand, productionArea, certNo, importCertNo, inspectionNo, engineNo, organizationCode, vin, tonnage, taxPaidProof, maxCapacity, taxAuthName, taxAuthCode, veriUserId, veriRemark, authRequestUserId, authRemark, redUserId, redRemark, retreatUserId, retreatRemark, matchUserId, matchRemark, chargeUpUserId, chargeUpRemark, saleConfirmUserId, saleConfirmRemark, paymentUserId, paymentRemark, freezeUserId, freezeRemark, loseUserId, loseRemark, remark, noComplianceDesc, imageNum, cooperationFlag, authWarningDays, remarkFlag);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceMain {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    createUserId: ").append(toIndentedString(createUserId)).append("\n");
    sb.append("    createUserName: ").append(toIndentedString(createUserName)).append("\n");
    sb.append("    updateUserId: ").append(toIndentedString(updateUserId)).append("\n");
    sb.append("    updateUserName: ").append(toIndentedString(updateUserName)).append("\n");
    sb.append("    bussinessId: ").append(toIndentedString(bussinessId)).append("\n");
    sb.append("    bussinessNo: ").append(toIndentedString(bussinessNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    purchaserOrgId: ").append(toIndentedString(purchaserOrgId)).append("\n");
    sb.append("    purchaserExternalCode: ").append(toIndentedString(purchaserExternalCode)).append("\n");
    sb.append("    purchaserLabel: ").append(toIndentedString(purchaserLabel)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerRootOrgId: ").append(toIndentedString(sellerRootOrgId)).append("\n");
    sb.append("    sellerOrgId: ").append(toIndentedString(sellerOrgId)).append("\n");
    sb.append("    sellerExternalCode: ").append(toIndentedString(sellerExternalCode)).append("\n");
    sb.append("    sellerInvoiceId: ").append(toIndentedString(sellerInvoiceId)).append("\n");
    sb.append("    sellerUserName: ").append(toIndentedString(sellerUserName)).append("\n");
    sb.append("    sellerViewImageFlag: ").append(toIndentedString(sellerViewImageFlag)).append("\n");
    sb.append("    invoiceColor: ").append(toIndentedString(invoiceColor)).append("\n");
    sb.append("    sellerSyncStatus: ").append(toIndentedString(sellerSyncStatus)).append("\n");
    sb.append("    sellerSyncTime: ").append(toIndentedString(sellerSyncTime)).append("\n");
    sb.append("    sellerLabel: ").append(toIndentedString(sellerLabel)).append("\n");
    sb.append("    taxRate: ").append(toIndentedString(taxRate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    amountWithTaxCapital: ").append(toIndentedString(amountWithTaxCapital)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    machineCode: ").append(toIndentedString(machineCode)).append("\n");
    sb.append("    checkCode: ").append(toIndentedString(checkCode)).append("\n");
    sb.append("    cipherText: ").append(toIndentedString(cipherText)).append("\n");
    sb.append("    invoiceOrig: ").append(toIndentedString(invoiceOrig)).append("\n");
    sb.append("    specialInvoiceFlag: ").append(toIndentedString(specialInvoiceFlag)).append("\n");
    sb.append("    titleOkFlag: ").append(toIndentedString(titleOkFlag)).append("\n");
    sb.append("    saleListFlag: ").append(toIndentedString(saleListFlag)).append("\n");
    sb.append("    dataOkFlag: ").append(toIndentedString(dataOkFlag)).append("\n");
    sb.append("    recogStatus: ").append(toIndentedString(recogStatus)).append("\n");
    sb.append("    recogInvoiceId: ").append(toIndentedString(recogInvoiceId)).append("\n");
    sb.append("    recogResponseTime: ").append(toIndentedString(recogResponseTime)).append("\n");
    sb.append("    recogUserName: ").append(toIndentedString(recogUserName)).append("\n");
    sb.append("    recogUploadNum: ").append(toIndentedString(recogUploadNum)).append("\n");
    sb.append("    complianceStatus: ").append(toIndentedString(complianceStatus)).append("\n");
    sb.append("    taxInvoiceId: ").append(toIndentedString(taxInvoiceId)).append("\n");
    sb.append("    authSyncStatus: ").append(toIndentedString(authSyncStatus)).append("\n");
    sb.append("    authSyncTime: ").append(toIndentedString(authSyncTime)).append("\n");
    sb.append("    veriInvoiceId: ").append(toIndentedString(veriInvoiceId)).append("\n");
    sb.append("    veriStatus: ").append(toIndentedString(veriStatus)).append("\n");
    sb.append("    veriRequestTime: ").append(toIndentedString(veriRequestTime)).append("\n");
    sb.append("    veriResponseTime: ").append(toIndentedString(veriResponseTime)).append("\n");
    sb.append("    veriUserName: ").append(toIndentedString(veriUserName)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    authStyle: ").append(toIndentedString(authStyle)).append("\n");
    sb.append("    authBussiDate: ").append(toIndentedString(authBussiDate)).append("\n");
    sb.append("    authTaxPeriod: ").append(toIndentedString(authTaxPeriod)).append("\n");
    sb.append("    authRequestTime: ").append(toIndentedString(authRequestTime)).append("\n");
    sb.append("    authResponseTime: ").append(toIndentedString(authResponseTime)).append("\n");
    sb.append("    authRequestUserName: ").append(toIndentedString(authRequestUserName)).append("\n");
    sb.append("    redStatus: ").append(toIndentedString(redStatus)).append("\n");
    sb.append("    redTime: ").append(toIndentedString(redTime)).append("\n");
    sb.append("    redNotificationNo: ").append(toIndentedString(redNotificationNo)).append("\n");
    sb.append("    redUserName: ").append(toIndentedString(redUserName)).append("\n");
    sb.append("    retreatStatus: ").append(toIndentedString(retreatStatus)).append("\n");
    sb.append("    retreatTime: ").append(toIndentedString(retreatTime)).append("\n");
    sb.append("    retreatUserName: ").append(toIndentedString(retreatUserName)).append("\n");
    sb.append("    matchStatus: ").append(toIndentedString(matchStatus)).append("\n");
    sb.append("    matchTime: ").append(toIndentedString(matchTime)).append("\n");
    sb.append("    matchUserName: ").append(toIndentedString(matchUserName)).append("\n");
    sb.append("    chargeUpStatus: ").append(toIndentedString(chargeUpStatus)).append("\n");
    sb.append("    chargeUpNo: ").append(toIndentedString(chargeUpNo)).append("\n");
    sb.append("    chargeUpTime: ").append(toIndentedString(chargeUpTime)).append("\n");
    sb.append("    chargeUpPeriod: ").append(toIndentedString(chargeUpPeriod)).append("\n");
    sb.append("    chargeUpUserName: ").append(toIndentedString(chargeUpUserName)).append("\n");
    sb.append("    saleConfirmStatus: ").append(toIndentedString(saleConfirmStatus)).append("\n");
    sb.append("    saleConfirmNo: ").append(toIndentedString(saleConfirmNo)).append("\n");
    sb.append("    saleConfirmTime: ").append(toIndentedString(saleConfirmTime)).append("\n");
    sb.append("    saleConfirmPeriod: ").append(toIndentedString(saleConfirmPeriod)).append("\n");
    sb.append("    saleConfirmUserName: ").append(toIndentedString(saleConfirmUserName)).append("\n");
    sb.append("    paymentStatus: ").append(toIndentedString(paymentStatus)).append("\n");
    sb.append("    paymentNo: ").append(toIndentedString(paymentNo)).append("\n");
    sb.append("    paymentDate: ").append(toIndentedString(paymentDate)).append("\n");
    sb.append("    paymentTime: ").append(toIndentedString(paymentTime)).append("\n");
    sb.append("    paymentUserName: ").append(toIndentedString(paymentUserName)).append("\n");
    sb.append("    freezeStatus: ").append(toIndentedString(freezeStatus)).append("\n");
    sb.append("    freezeTime: ").append(toIndentedString(freezeTime)).append("\n");
    sb.append("    freezeUserName: ").append(toIndentedString(freezeUserName)).append("\n");
    sb.append("    loseStatus: ").append(toIndentedString(loseStatus)).append("\n");
    sb.append("    loseTime: ").append(toIndentedString(loseTime)).append("\n");
    sb.append("    loseUserName: ").append(toIndentedString(loseUserName)).append("\n");
    sb.append("    blackStatus: ").append(toIndentedString(blackStatus)).append("\n");
    sb.append("    blackRemark: ").append(toIndentedString(blackRemark)).append("\n");
    sb.append("    bizTag1: ").append(toIndentedString(bizTag1)).append("\n");
    sb.append("    bizTag2: ").append(toIndentedString(bizTag2)).append("\n");
    sb.append("    bizTag3: ").append(toIndentedString(bizTag3)).append("\n");
    sb.append("    originBussinessId: ").append(toIndentedString(originBussinessId)).append("\n");
    sb.append("    originBussinessNo: ").append(toIndentedString(originBussinessNo)).append("\n");
    sb.append("    originInvoiceNo: ").append(toIndentedString(originInvoiceNo)).append("\n");
    sb.append("    originInvoiceCode: ").append(toIndentedString(originInvoiceCode)).append("\n");
    sb.append("    tpStatus: ").append(toIndentedString(tpStatus)).append("\n");
    sb.append("    purchaserAddress: ").append(toIndentedString(purchaserAddress)).append("\n");
    sb.append("    purchaserTel: ").append(toIndentedString(purchaserTel)).append("\n");
    sb.append("    purchaserAddrTel: ").append(toIndentedString(purchaserAddrTel)).append("\n");
    sb.append("    purchaserBankName: ").append(toIndentedString(purchaserBankName)).append("\n");
    sb.append("    purchaserBankAccount: ").append(toIndentedString(purchaserBankAccount)).append("\n");
    sb.append("    purchaserBankNameAccount: ").append(toIndentedString(purchaserBankNameAccount)).append("\n");
    sb.append("    sellerAddress: ").append(toIndentedString(sellerAddress)).append("\n");
    sb.append("    sellerTel: ").append(toIndentedString(sellerTel)).append("\n");
    sb.append("    sellerAddrTel: ").append(toIndentedString(sellerAddrTel)).append("\n");
    sb.append("    sellerBankName: ").append(toIndentedString(sellerBankName)).append("\n");
    sb.append("    sellerBankAccount: ").append(toIndentedString(sellerBankAccount)).append("\n");
    sb.append("    sellerBankNameAccount: ").append(toIndentedString(sellerBankNameAccount)).append("\n");
    sb.append("    sellerUserId: ").append(toIndentedString(sellerUserId)).append("\n");
    sb.append("    cashierName: ").append(toIndentedString(cashierName)).append("\n");
    sb.append("    checkerName: ").append(toIndentedString(checkerName)).append("\n");
    sb.append("    invoicerName: ").append(toIndentedString(invoicerName)).append("\n");
    sb.append("    recogUserId: ").append(toIndentedString(recogUserId)).append("\n");
    sb.append("    recogDeductionImageUrl: ").append(toIndentedString(recogDeductionImageUrl)).append("\n");
    sb.append("    recogInvoiceImageUrl: ").append(toIndentedString(recogInvoiceImageUrl)).append("\n");
    sb.append("    pdfUrl: ").append(toIndentedString(pdfUrl)).append("\n");
    sb.append("    vehicleType: ").append(toIndentedString(vehicleType)).append("\n");
    sb.append("    vehicleBrand: ").append(toIndentedString(vehicleBrand)).append("\n");
    sb.append("    productionArea: ").append(toIndentedString(productionArea)).append("\n");
    sb.append("    certNo: ").append(toIndentedString(certNo)).append("\n");
    sb.append("    importCertNo: ").append(toIndentedString(importCertNo)).append("\n");
    sb.append("    inspectionNo: ").append(toIndentedString(inspectionNo)).append("\n");
    sb.append("    engineNo: ").append(toIndentedString(engineNo)).append("\n");
    sb.append("    organizationCode: ").append(toIndentedString(organizationCode)).append("\n");
    sb.append("    vin: ").append(toIndentedString(vin)).append("\n");
    sb.append("    tonnage: ").append(toIndentedString(tonnage)).append("\n");
    sb.append("    taxPaidProof: ").append(toIndentedString(taxPaidProof)).append("\n");
    sb.append("    maxCapacity: ").append(toIndentedString(maxCapacity)).append("\n");
    sb.append("    taxAuthName: ").append(toIndentedString(taxAuthName)).append("\n");
    sb.append("    taxAuthCode: ").append(toIndentedString(taxAuthCode)).append("\n");
    sb.append("    veriUserId: ").append(toIndentedString(veriUserId)).append("\n");
    sb.append("    veriRemark: ").append(toIndentedString(veriRemark)).append("\n");
    sb.append("    authRequestUserId: ").append(toIndentedString(authRequestUserId)).append("\n");
    sb.append("    authRemark: ").append(toIndentedString(authRemark)).append("\n");
    sb.append("    redUserId: ").append(toIndentedString(redUserId)).append("\n");
    sb.append("    redRemark: ").append(toIndentedString(redRemark)).append("\n");
    sb.append("    retreatUserId: ").append(toIndentedString(retreatUserId)).append("\n");
    sb.append("    retreatRemark: ").append(toIndentedString(retreatRemark)).append("\n");
    sb.append("    matchUserId: ").append(toIndentedString(matchUserId)).append("\n");
    sb.append("    matchRemark: ").append(toIndentedString(matchRemark)).append("\n");
    sb.append("    chargeUpUserId: ").append(toIndentedString(chargeUpUserId)).append("\n");
    sb.append("    chargeUpRemark: ").append(toIndentedString(chargeUpRemark)).append("\n");
    sb.append("    saleConfirmUserId: ").append(toIndentedString(saleConfirmUserId)).append("\n");
    sb.append("    saleConfirmRemark: ").append(toIndentedString(saleConfirmRemark)).append("\n");
    sb.append("    paymentUserId: ").append(toIndentedString(paymentUserId)).append("\n");
    sb.append("    paymentRemark: ").append(toIndentedString(paymentRemark)).append("\n");
    sb.append("    freezeUserId: ").append(toIndentedString(freezeUserId)).append("\n");
    sb.append("    freezeRemark: ").append(toIndentedString(freezeRemark)).append("\n");
    sb.append("    loseUserId: ").append(toIndentedString(loseUserId)).append("\n");
    sb.append("    loseRemark: ").append(toIndentedString(loseRemark)).append("\n");
    sb.append("    remark: ").append(toIndentedString(remark)).append("\n");
    sb.append("    noComplianceDesc: ").append(toIndentedString(noComplianceDesc)).append("\n");
    sb.append("    imageNum: ").append(toIndentedString(imageNum)).append("\n");
    sb.append("    cooperationFlag: ").append(toIndentedString(cooperationFlag)).append("\n");
    sb.append("    authWarningDays: ").append(toIndentedString(authWarningDays)).append("\n");
    sb.append("    remarkFlag: ").append(toIndentedString(remarkFlag)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
