package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsInvoiceParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 自定义查询参数分组
 */
@ApiModel(description = "自定义查询参数分组")

@JsonInclude(NON_NULL)
public class MsInvoiceParamGroup {
  @JsonProperty("params")
  private List<MsInvoiceParam> params = new ArrayList<MsInvoiceParam>();

  @JsonIgnore
  public MsInvoiceParamGroup params(List<MsInvoiceParam> params) {
    this.params = params;
    return this;
  }

  public MsInvoiceParamGroup addParamsItem(MsInvoiceParam paramsItem) {
    this.params.add(paramsItem);
    return this;
  }

   /**
   * Get params
   * @return params
  **/
  @ApiModelProperty(value = "")
  public List<MsInvoiceParam> getParams() {
    return params;
  }

  public void setParams(List<MsInvoiceParam> params) {
    this.params = params;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceParamGroup invoiceParamGroup = (MsInvoiceParamGroup) o;
    return Objects.equals(this.params, invoiceParamGroup.params);
  }

  @Override
  public int hashCode() {
    return Objects.hash(params);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceParamGroup {\n");
    
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
