package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsUndeclaredCompanyObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 未申报公司返回对象
 */
@ApiModel(description = "未申报公司返回对象")

@JsonInclude(NON_NULL)
public class MsListUndeclaredCompanyResponseObj {
  @JsonProperty("undeclaredDate")
  private String undeclaredDate = null;

  @JsonProperty("declaredDate")
  private String declaredDate = null;

  @JsonProperty("companyList")
  private List<MsUndeclaredCompanyObj> companyList = new ArrayList<MsUndeclaredCompanyObj>();

  @JsonIgnore
  public MsListUndeclaredCompanyResponseObj undeclaredDate(String undeclaredDate) {
    this.undeclaredDate = undeclaredDate;
    return this;
  }

   /**
   * 未申报日期
   * @return undeclaredDate
  **/
  @ApiModelProperty(value = "未申报日期")
  public String getUndeclaredDate() {
    return undeclaredDate;
  }

  public void setUndeclaredDate(String undeclaredDate) {
    this.undeclaredDate = undeclaredDate;
  }

  @JsonIgnore
  public MsListUndeclaredCompanyResponseObj declaredDate(String declaredDate) {
    this.declaredDate = declaredDate;
    return this;
  }

   /**
   * 已申报日期
   * @return declaredDate
  **/
  @ApiModelProperty(value = "已申报日期")
  public String getDeclaredDate() {
    return declaredDate;
  }

  public void setDeclaredDate(String declaredDate) {
    this.declaredDate = declaredDate;
  }

  @JsonIgnore
  public MsListUndeclaredCompanyResponseObj companyList(List<MsUndeclaredCompanyObj> companyList) {
    this.companyList = companyList;
    return this;
  }

  public MsListUndeclaredCompanyResponseObj addCompanyListItem(MsUndeclaredCompanyObj companyListItem) {
    this.companyList.add(companyListItem);
    return this;
  }

   /**
   * Get companyList
   * @return companyList
  **/
  @ApiModelProperty(value = "")
  public List<MsUndeclaredCompanyObj> getCompanyList() {
    return companyList;
  }

  public void setCompanyList(List<MsUndeclaredCompanyObj> companyList) {
    this.companyList = companyList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListUndeclaredCompanyResponseObj listUndeclaredCompanyResponseObj = (MsListUndeclaredCompanyResponseObj) o;
    return Objects.equals(this.undeclaredDate, listUndeclaredCompanyResponseObj.undeclaredDate) &&
        Objects.equals(this.declaredDate, listUndeclaredCompanyResponseObj.declaredDate) &&
        Objects.equals(this.companyList, listUndeclaredCompanyResponseObj.companyList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(undeclaredDate, declaredDate, companyList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListUndeclaredCompanyResponseObj {\n");
    
    sb.append("    undeclaredDate: ").append(toIndentedString(undeclaredDate)).append("\n");
    sb.append("    declaredDate: ").append(toIndentedString(declaredDate)).append("\n");
    sb.append("    companyList: ").append(toIndentedString(companyList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
