package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsRetreatInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class MsRetreatInvoiceRequest {
  @JsonProperty("retreatDesc")
  private String retreatDesc = null;

  @JsonProperty("invoiceIds")
  private List<String> invoiceIds = new ArrayList<String>();

  @JsonProperty("sellerViewImageFlag")
  private Integer sellerViewImageFlag = null;

  @JsonProperty("retreatUserId")
  private Long retreatUserId = null;

  @JsonProperty("retreatUserName")
  private String retreatUserName = null;

  @JsonIgnore
  public MsRetreatInvoiceRequest retreatDesc(String retreatDesc) {
    this.retreatDesc = retreatDesc;
    return this;
  }

   /**
   * 退票描述
   * @return retreatDesc
  **/
  @ApiModelProperty(value = "退票描述")
  public String getRetreatDesc() {
    return retreatDesc;
  }

  public void setRetreatDesc(String retreatDesc) {
    this.retreatDesc = retreatDesc;
  }

  @JsonIgnore
  public MsRetreatInvoiceRequest invoiceIds(List<String> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsRetreatInvoiceRequest addInvoiceIdsItem(String invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<String> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<String> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public MsRetreatInvoiceRequest sellerViewImageFlag(Integer sellerViewImageFlag) {
    this.sellerViewImageFlag = sellerViewImageFlag;
    return this;
  }

   /**
   * 销方查看影像标志   0-默认  1-允许销方查看影像
   * @return sellerViewImageFlag
  **/
  @ApiModelProperty(value = "销方查看影像标志   0-默认  1-允许销方查看影像")
  public Integer getSellerViewImageFlag() {
    return sellerViewImageFlag;
  }

  public void setSellerViewImageFlag(Integer sellerViewImageFlag) {
    this.sellerViewImageFlag = sellerViewImageFlag;
  }

  @JsonIgnore
  public MsRetreatInvoiceRequest retreatUserId(Long retreatUserId) {
    this.retreatUserId = retreatUserId;
    return this;
  }

   /**
   * 退票操作人ID
   * @return retreatUserId
  **/
  @ApiModelProperty(value = "退票操作人ID")
  public Long getRetreatUserId() {
    return retreatUserId;
  }

  public void setRetreatUserId(Long retreatUserId) {
    this.retreatUserId = retreatUserId;
  }

  @JsonIgnore
  public MsRetreatInvoiceRequest retreatUserName(String retreatUserName) {
    this.retreatUserName = retreatUserName;
    return this;
  }

   /**
   * 退票操作人姓名
   * @return retreatUserName
  **/
  @ApiModelProperty(value = "退票操作人姓名")
  public String getRetreatUserName() {
    return retreatUserName;
  }

  public void setRetreatUserName(String retreatUserName) {
    this.retreatUserName = retreatUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsRetreatInvoiceRequest retreatInvoiceRequest = (MsRetreatInvoiceRequest) o;
    return Objects.equals(this.retreatDesc, retreatInvoiceRequest.retreatDesc) &&
        Objects.equals(this.invoiceIds, retreatInvoiceRequest.invoiceIds) &&
        Objects.equals(this.sellerViewImageFlag, retreatInvoiceRequest.sellerViewImageFlag) &&
        Objects.equals(this.retreatUserId, retreatInvoiceRequest.retreatUserId) &&
        Objects.equals(this.retreatUserName, retreatInvoiceRequest.retreatUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(retreatDesc, invoiceIds, sellerViewImageFlag, retreatUserId, retreatUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsRetreatInvoiceRequest {\n");
    
    sb.append("    retreatDesc: ").append(toIndentedString(retreatDesc)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    sellerViewImageFlag: ").append(toIndentedString(sellerViewImageFlag)).append("\n");
    sb.append("    retreatUserId: ").append(toIndentedString(retreatUserId)).append("\n");
    sb.append("    retreatUserName: ").append(toIndentedString(retreatUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
