package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthStatisticRequestObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发送认证确认请求参数
 */
@ApiModel(description = "发送认证确认请求参数")

@JsonInclude(NON_NULL)
public class MsSendAuthConfirmRequest {
  @JsonProperty("authTabStatus")
  private Integer authTabStatus = null;

  @JsonProperty("invoiceList")
  private List<Long> invoiceList = new ArrayList<Long>();

  @JsonProperty("paramRequests")
  private List<MsSendAuthStatisticRequestObj> paramRequests = new ArrayList<MsSendAuthStatisticRequestObj>();

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonIgnore
  public MsSendAuthConfirmRequest authTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
    return this;
  }

   /**
   * 认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税
   * @return authTabStatus
  **/
  @ApiModelProperty(value = "认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税")
  public Integer getAuthTabStatus() {
    return authTabStatus;
  }

  public void setAuthTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
  }

  @JsonIgnore
  public MsSendAuthConfirmRequest invoiceList(List<Long> invoiceList) {
    this.invoiceList = invoiceList;
    return this;
  }

  public MsSendAuthConfirmRequest addInvoiceListItem(Long invoiceListItem) {
    this.invoiceList.add(invoiceListItem);
    return this;
  }

   /**
   * 发票id集合(传统认证)
   * @return invoiceList
  **/
  @ApiModelProperty(value = "发票id集合(传统认证)")
  public List<Long> getInvoiceList() {
    return invoiceList;
  }

  public void setInvoiceList(List<Long> invoiceList) {
    this.invoiceList = invoiceList;
  }

  @JsonIgnore
  public MsSendAuthConfirmRequest paramRequests(List<MsSendAuthStatisticRequestObj> paramRequests) {
    this.paramRequests = paramRequests;
    return this;
  }

  public MsSendAuthConfirmRequest addParamRequestsItem(MsSendAuthStatisticRequestObj paramRequestsItem) {
    this.paramRequests.add(paramRequestsItem);
    return this;
  }

   /**
   * 公司，征期，发票id集合(其他认证)
   * @return paramRequests
  **/
  @ApiModelProperty(value = "公司，征期，发票id集合(其他认证)")
  public List<MsSendAuthStatisticRequestObj> getParamRequests() {
    return paramRequests;
  }

  public void setParamRequests(List<MsSendAuthStatisticRequestObj> paramRequests) {
    this.paramRequests = paramRequests;
  }

  @JsonIgnore
  public MsSendAuthConfirmRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsSendAuthConfirmRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id集合
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id集合")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsSendAuthConfirmRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsSendAuthConfirmRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSendAuthConfirmRequest sendAuthConfirmRequest = (MsSendAuthConfirmRequest) o;
    return Objects.equals(this.authTabStatus, sendAuthConfirmRequest.authTabStatus) &&
        Objects.equals(this.invoiceList, sendAuthConfirmRequest.invoiceList) &&
        Objects.equals(this.paramRequests, sendAuthConfirmRequest.paramRequests) &&
        Objects.equals(this.orgIdList, sendAuthConfirmRequest.orgIdList) &&
        Objects.equals(this.sysUserId, sendAuthConfirmRequest.sysUserId) &&
        Objects.equals(this.sysUserName, sendAuthConfirmRequest.sysUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authTabStatus, invoiceList, paramRequests, orgIdList, sysUserId, sysUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSendAuthConfirmRequest {\n");
    
    sb.append("    authTabStatus: ").append(toIndentedString(authTabStatus)).append("\n");
    sb.append("    invoiceList: ").append(toIndentedString(invoiceList)).append("\n");
    sb.append("    paramRequests: ").append(toIndentedString(paramRequests)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
