package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsSendAuthCompanyObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发送认证返回对象
 */
@ApiModel(description = "发送认证返回对象")

@JsonInclude(NON_NULL)
public class MsSendAuthObj {
  @JsonProperty("checkInvoiceNum")
  private Integer checkInvoiceNum = null;

  @JsonProperty("authInvoiceNum")
  private Integer authInvoiceNum = null;

  @JsonProperty("noauthInvoiceNum")
  private Integer noauthInvoiceNum = null;

  @JsonProperty("authTaxAmount")
  private String authTaxAmount = null;

  @JsonProperty("authAmountWithoutTax")
  private String authAmountWithoutTax = null;

  @JsonProperty("authAmountWithTax")
  private String authAmountWithTax = null;

  @JsonProperty("companyList")
  private List<MsSendAuthCompanyObj> companyList = new ArrayList<MsSendAuthCompanyObj>();

  @JsonIgnore
  public MsSendAuthObj checkInvoiceNum(Integer checkInvoiceNum) {
    this.checkInvoiceNum = checkInvoiceNum;
    return this;
  }

   /**
   * 当前勾选发票数
   * @return checkInvoiceNum
  **/
  @ApiModelProperty(value = "当前勾选发票数")
  public Integer getCheckInvoiceNum() {
    return checkInvoiceNum;
  }

  public void setCheckInvoiceNum(Integer checkInvoiceNum) {
    this.checkInvoiceNum = checkInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthObj authInvoiceNum(Integer authInvoiceNum) {
    this.authInvoiceNum = authInvoiceNum;
    return this;
  }

   /**
   * 可认证发票数
   * @return authInvoiceNum
  **/
  @ApiModelProperty(value = "可认证发票数")
  public Integer getAuthInvoiceNum() {
    return authInvoiceNum;
  }

  public void setAuthInvoiceNum(Integer authInvoiceNum) {
    this.authInvoiceNum = authInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthObj noauthInvoiceNum(Integer noauthInvoiceNum) {
    this.noauthInvoiceNum = noauthInvoiceNum;
    return this;
  }

   /**
   * 不可认证发票数
   * @return noauthInvoiceNum
  **/
  @ApiModelProperty(value = "不可认证发票数")
  public Integer getNoauthInvoiceNum() {
    return noauthInvoiceNum;
  }

  public void setNoauthInvoiceNum(Integer noauthInvoiceNum) {
    this.noauthInvoiceNum = noauthInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthObj authTaxAmount(String authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
    return this;
  }

   /**
   * 可认证税额
   * @return authTaxAmount
  **/
  @ApiModelProperty(value = "可认证税额")
  public String getAuthTaxAmount() {
    return authTaxAmount;
  }

  public void setAuthTaxAmount(String authTaxAmount) {
    this.authTaxAmount = authTaxAmount;
  }

  @JsonIgnore
  public MsSendAuthObj authAmountWithoutTax(String authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
    return this;
  }

   /**
   * 可认证不含税金额
   * @return authAmountWithoutTax
  **/
  @ApiModelProperty(value = "可认证不含税金额")
  public String getAuthAmountWithoutTax() {
    return authAmountWithoutTax;
  }

  public void setAuthAmountWithoutTax(String authAmountWithoutTax) {
    this.authAmountWithoutTax = authAmountWithoutTax;
  }

  @JsonIgnore
  public MsSendAuthObj authAmountWithTax(String authAmountWithTax) {
    this.authAmountWithTax = authAmountWithTax;
    return this;
  }

   /**
   * 可认证含税金额
   * @return authAmountWithTax
  **/
  @ApiModelProperty(value = "可认证含税金额")
  public String getAuthAmountWithTax() {
    return authAmountWithTax;
  }

  public void setAuthAmountWithTax(String authAmountWithTax) {
    this.authAmountWithTax = authAmountWithTax;
  }

  @JsonIgnore
  public MsSendAuthObj companyList(List<MsSendAuthCompanyObj> companyList) {
    this.companyList = companyList;
    return this;
  }

  public MsSendAuthObj addCompanyListItem(MsSendAuthCompanyObj companyListItem) {
    this.companyList.add(companyListItem);
    return this;
  }

   /**
   * Get companyList
   * @return companyList
  **/
  @ApiModelProperty(value = "")
  public List<MsSendAuthCompanyObj> getCompanyList() {
    return companyList;
  }

  public void setCompanyList(List<MsSendAuthCompanyObj> companyList) {
    this.companyList = companyList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSendAuthObj sendAuthObj = (MsSendAuthObj) o;
    return Objects.equals(this.checkInvoiceNum, sendAuthObj.checkInvoiceNum) &&
        Objects.equals(this.authInvoiceNum, sendAuthObj.authInvoiceNum) &&
        Objects.equals(this.noauthInvoiceNum, sendAuthObj.noauthInvoiceNum) &&
        Objects.equals(this.authTaxAmount, sendAuthObj.authTaxAmount) &&
        Objects.equals(this.authAmountWithoutTax, sendAuthObj.authAmountWithoutTax) &&
        Objects.equals(this.authAmountWithTax, sendAuthObj.authAmountWithTax) &&
        Objects.equals(this.companyList, sendAuthObj.companyList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(checkInvoiceNum, authInvoiceNum, noauthInvoiceNum, authTaxAmount, authAmountWithoutTax, authAmountWithTax, companyList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSendAuthObj {\n");
    
    sb.append("    checkInvoiceNum: ").append(toIndentedString(checkInvoiceNum)).append("\n");
    sb.append("    authInvoiceNum: ").append(toIndentedString(authInvoiceNum)).append("\n");
    sb.append("    noauthInvoiceNum: ").append(toIndentedString(noauthInvoiceNum)).append("\n");
    sb.append("    authTaxAmount: ").append(toIndentedString(authTaxAmount)).append("\n");
    sb.append("    authAmountWithoutTax: ").append(toIndentedString(authAmountWithoutTax)).append("\n");
    sb.append("    authAmountWithTax: ").append(toIndentedString(authAmountWithTax)).append("\n");
    sb.append("    companyList: ").append(toIndentedString(companyList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
