package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsAuthStatisticDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发送认证返回对象
 */
@ApiModel(description = "发送认证返回对象")

@JsonInclude(NON_NULL)
public class MsSendAuthStatisticResponseObj {
  @JsonProperty("tenantName")
  private String tenantName = null;

  @JsonProperty("totalInvoiceNum")
  private Integer totalInvoiceNum = null;

  @JsonProperty("totalAmountWithTax")
  private String totalAmountWithTax = null;

  @JsonProperty("totalTaxAmount")
  private String totalTaxAmount = null;

  @JsonProperty("invoiceNum")
  private Integer invoiceNum = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("sInvoiceNum")
  private Integer sInvoiceNum = null;

  @JsonProperty("sAmountWithTax")
  private String sAmountWithTax = null;

  @JsonProperty("sTaxAmount")
  private String sTaxAmount = null;

  @JsonProperty("jInvoiceNum")
  private Integer jInvoiceNum = null;

  @JsonProperty("jAmountWithTax")
  private String jAmountWithTax = null;

  @JsonProperty("jTaxAmount")
  private String jTaxAmount = null;

  @JsonProperty("ctInvoiceNum")
  private Integer ctInvoiceNum = null;

  @JsonProperty("ctAmountWithTax")
  private String ctAmountWithTax = null;

  @JsonProperty("ctTaxAmount")
  private String ctTaxAmount = null;

  @JsonProperty("unauthCompanyInfo")
  private List<MsAuthStatisticDetail> unauthCompanyInfo = new ArrayList<MsAuthStatisticDetail>();

  @JsonProperty("authCompanyInfo")
  private List<MsAuthStatisticDetail> authCompanyInfo = new ArrayList<MsAuthStatisticDetail>();

  @JsonIgnore
  public MsSendAuthStatisticResponseObj tenantName(String tenantName) {
    this.tenantName = tenantName;
    return this;
  }

   /**
   * 集团名
   * @return tenantName
  **/
  @ApiModelProperty(value = "集团名")
  public String getTenantName() {
    return tenantName;
  }

  public void setTenantName(String tenantName) {
    this.tenantName = tenantName;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj totalInvoiceNum(Integer totalInvoiceNum) {
    this.totalInvoiceNum = totalInvoiceNum;
    return this;
  }

   /**
   * 有效发票总数
   * @return totalInvoiceNum
  **/
  @ApiModelProperty(value = "有效发票总数")
  public Integer getTotalInvoiceNum() {
    return totalInvoiceNum;
  }

  public void setTotalInvoiceNum(Integer totalInvoiceNum) {
    this.totalInvoiceNum = totalInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj totalAmountWithTax(String totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
    return this;
  }

   /**
   * 总含税金额
   * @return totalAmountWithTax
  **/
  @ApiModelProperty(value = "总含税金额")
  public String getTotalAmountWithTax() {
    return totalAmountWithTax;
  }

  public void setTotalAmountWithTax(String totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj totalTaxAmount(String totalTaxAmount) {
    this.totalTaxAmount = totalTaxAmount;
    return this;
  }

   /**
   * 总税额
   * @return totalTaxAmount
  **/
  @ApiModelProperty(value = "总税额")
  public String getTotalTaxAmount() {
    return totalTaxAmount;
  }

  public void setTotalTaxAmount(String totalTaxAmount) {
    this.totalTaxAmount = totalTaxAmount;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj invoiceNum(Integer invoiceNum) {
    this.invoiceNum = invoiceNum;
    return this;
  }

   /**
   * 有效发票数
   * @return invoiceNum
  **/
  @ApiModelProperty(value = "有效发票数")
  public Integer getInvoiceNum() {
    return invoiceNum;
  }

  public void setInvoiceNum(Integer invoiceNum) {
    this.invoiceNum = invoiceNum;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj sInvoiceNum(Integer sInvoiceNum) {
    this.sInvoiceNum = sInvoiceNum;
    return this;
  }

   /**
   * 增值税专用发票数
   * @return sInvoiceNum
  **/
  @ApiModelProperty(value = "增值税专用发票数")
  public Integer getSInvoiceNum() {
    return sInvoiceNum;
  }

  public void setSInvoiceNum(Integer sInvoiceNum) {
    this.sInvoiceNum = sInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj sAmountWithTax(String sAmountWithTax) {
    this.sAmountWithTax = sAmountWithTax;
    return this;
  }

   /**
   * Get sAmountWithTax
   * @return sAmountWithTax
  **/
  @ApiModelProperty(value = "")
  public String getSAmountWithTax() {
    return sAmountWithTax;
  }

  public void setSAmountWithTax(String sAmountWithTax) {
    this.sAmountWithTax = sAmountWithTax;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj sTaxAmount(String sTaxAmount) {
    this.sTaxAmount = sTaxAmount;
    return this;
  }

   /**
   * Get sTaxAmount
   * @return sTaxAmount
  **/
  @ApiModelProperty(value = "")
  public String getSTaxAmount() {
    return sTaxAmount;
  }

  public void setSTaxAmount(String sTaxAmount) {
    this.sTaxAmount = sTaxAmount;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj jInvoiceNum(Integer jInvoiceNum) {
    this.jInvoiceNum = jInvoiceNum;
    return this;
  }

   /**
   * 机动车发票
   * @return jInvoiceNum
  **/
  @ApiModelProperty(value = "机动车发票")
  public Integer getJInvoiceNum() {
    return jInvoiceNum;
  }

  public void setJInvoiceNum(Integer jInvoiceNum) {
    this.jInvoiceNum = jInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj jAmountWithTax(String jAmountWithTax) {
    this.jAmountWithTax = jAmountWithTax;
    return this;
  }

   /**
   * Get jAmountWithTax
   * @return jAmountWithTax
  **/
  @ApiModelProperty(value = "")
  public String getJAmountWithTax() {
    return jAmountWithTax;
  }

  public void setJAmountWithTax(String jAmountWithTax) {
    this.jAmountWithTax = jAmountWithTax;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj jTaxAmount(String jTaxAmount) {
    this.jTaxAmount = jTaxAmount;
    return this;
  }

   /**
   * Get jTaxAmount
   * @return jTaxAmount
  **/
  @ApiModelProperty(value = "")
  public String getJTaxAmount() {
    return jTaxAmount;
  }

  public void setJTaxAmount(String jTaxAmount) {
    this.jTaxAmount = jTaxAmount;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj ctInvoiceNum(Integer ctInvoiceNum) {
    this.ctInvoiceNum = ctInvoiceNum;
    return this;
  }

   /**
   * 通行发票
   * @return ctInvoiceNum
  **/
  @ApiModelProperty(value = "通行发票")
  public Integer getCtInvoiceNum() {
    return ctInvoiceNum;
  }

  public void setCtInvoiceNum(Integer ctInvoiceNum) {
    this.ctInvoiceNum = ctInvoiceNum;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj ctAmountWithTax(String ctAmountWithTax) {
    this.ctAmountWithTax = ctAmountWithTax;
    return this;
  }

   /**
   * Get ctAmountWithTax
   * @return ctAmountWithTax
  **/
  @ApiModelProperty(value = "")
  public String getCtAmountWithTax() {
    return ctAmountWithTax;
  }

  public void setCtAmountWithTax(String ctAmountWithTax) {
    this.ctAmountWithTax = ctAmountWithTax;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj ctTaxAmount(String ctTaxAmount) {
    this.ctTaxAmount = ctTaxAmount;
    return this;
  }

   /**
   * Get ctTaxAmount
   * @return ctTaxAmount
  **/
  @ApiModelProperty(value = "")
  public String getCtTaxAmount() {
    return ctTaxAmount;
  }

  public void setCtTaxAmount(String ctTaxAmount) {
    this.ctTaxAmount = ctTaxAmount;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj unauthCompanyInfo(List<MsAuthStatisticDetail> unauthCompanyInfo) {
    this.unauthCompanyInfo = unauthCompanyInfo;
    return this;
  }

  public MsSendAuthStatisticResponseObj addUnauthCompanyInfoItem(MsAuthStatisticDetail unauthCompanyInfoItem) {
    this.unauthCompanyInfo.add(unauthCompanyInfoItem);
    return this;
  }

   /**
   * Get unauthCompanyInfo
   * @return unauthCompanyInfo
  **/
  @ApiModelProperty(value = "")
  public List<MsAuthStatisticDetail> getUnauthCompanyInfo() {
    return unauthCompanyInfo;
  }

  public void setUnauthCompanyInfo(List<MsAuthStatisticDetail> unauthCompanyInfo) {
    this.unauthCompanyInfo = unauthCompanyInfo;
  }

  @JsonIgnore
  public MsSendAuthStatisticResponseObj authCompanyInfo(List<MsAuthStatisticDetail> authCompanyInfo) {
    this.authCompanyInfo = authCompanyInfo;
    return this;
  }

  public MsSendAuthStatisticResponseObj addAuthCompanyInfoItem(MsAuthStatisticDetail authCompanyInfoItem) {
    this.authCompanyInfo.add(authCompanyInfoItem);
    return this;
  }

   /**
   * Get authCompanyInfo
   * @return authCompanyInfo
  **/
  @ApiModelProperty(value = "")
  public List<MsAuthStatisticDetail> getAuthCompanyInfo() {
    return authCompanyInfo;
  }

  public void setAuthCompanyInfo(List<MsAuthStatisticDetail> authCompanyInfo) {
    this.authCompanyInfo = authCompanyInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSendAuthStatisticResponseObj sendAuthStatisticResponseObj = (MsSendAuthStatisticResponseObj) o;
    return Objects.equals(this.tenantName, sendAuthStatisticResponseObj.tenantName) &&
        Objects.equals(this.totalInvoiceNum, sendAuthStatisticResponseObj.totalInvoiceNum) &&
        Objects.equals(this.totalAmountWithTax, sendAuthStatisticResponseObj.totalAmountWithTax) &&
        Objects.equals(this.totalTaxAmount, sendAuthStatisticResponseObj.totalTaxAmount) &&
        Objects.equals(this.invoiceNum, sendAuthStatisticResponseObj.invoiceNum) &&
        Objects.equals(this.amountWithTax, sendAuthStatisticResponseObj.amountWithTax) &&
        Objects.equals(this.taxAmount, sendAuthStatisticResponseObj.taxAmount) &&
        Objects.equals(this.sInvoiceNum, sendAuthStatisticResponseObj.sInvoiceNum) &&
        Objects.equals(this.sAmountWithTax, sendAuthStatisticResponseObj.sAmountWithTax) &&
        Objects.equals(this.sTaxAmount, sendAuthStatisticResponseObj.sTaxAmount) &&
        Objects.equals(this.jInvoiceNum, sendAuthStatisticResponseObj.jInvoiceNum) &&
        Objects.equals(this.jAmountWithTax, sendAuthStatisticResponseObj.jAmountWithTax) &&
        Objects.equals(this.jTaxAmount, sendAuthStatisticResponseObj.jTaxAmount) &&
        Objects.equals(this.ctInvoiceNum, sendAuthStatisticResponseObj.ctInvoiceNum) &&
        Objects.equals(this.ctAmountWithTax, sendAuthStatisticResponseObj.ctAmountWithTax) &&
        Objects.equals(this.ctTaxAmount, sendAuthStatisticResponseObj.ctTaxAmount) &&
        Objects.equals(this.unauthCompanyInfo, sendAuthStatisticResponseObj.unauthCompanyInfo) &&
        Objects.equals(this.authCompanyInfo, sendAuthStatisticResponseObj.authCompanyInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantName, totalInvoiceNum, totalAmountWithTax, totalTaxAmount, invoiceNum, amountWithTax, taxAmount, sInvoiceNum, sAmountWithTax, sTaxAmount, jInvoiceNum, jAmountWithTax, jTaxAmount, ctInvoiceNum, ctAmountWithTax, ctTaxAmount, unauthCompanyInfo, authCompanyInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSendAuthStatisticResponseObj {\n");
    
    sb.append("    tenantName: ").append(toIndentedString(tenantName)).append("\n");
    sb.append("    totalInvoiceNum: ").append(toIndentedString(totalInvoiceNum)).append("\n");
    sb.append("    totalAmountWithTax: ").append(toIndentedString(totalAmountWithTax)).append("\n");
    sb.append("    totalTaxAmount: ").append(toIndentedString(totalTaxAmount)).append("\n");
    sb.append("    invoiceNum: ").append(toIndentedString(invoiceNum)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    sInvoiceNum: ").append(toIndentedString(sInvoiceNum)).append("\n");
    sb.append("    sAmountWithTax: ").append(toIndentedString(sAmountWithTax)).append("\n");
    sb.append("    sTaxAmount: ").append(toIndentedString(sTaxAmount)).append("\n");
    sb.append("    jInvoiceNum: ").append(toIndentedString(jInvoiceNum)).append("\n");
    sb.append("    jAmountWithTax: ").append(toIndentedString(jAmountWithTax)).append("\n");
    sb.append("    jTaxAmount: ").append(toIndentedString(jTaxAmount)).append("\n");
    sb.append("    ctInvoiceNum: ").append(toIndentedString(ctInvoiceNum)).append("\n");
    sb.append("    ctAmountWithTax: ").append(toIndentedString(ctAmountWithTax)).append("\n");
    sb.append("    ctTaxAmount: ").append(toIndentedString(ctTaxAmount)).append("\n");
    sb.append("    unauthCompanyInfo: ").append(toIndentedString(unauthCompanyInfo)).append("\n");
    sb.append("    authCompanyInfo: ").append(toIndentedString(authCompanyInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
