package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 申请统计跳转入参
 */
@ApiModel(description = "申请统计跳转入参")

@JsonInclude(NON_NULL)
public class MsStatisticalJumpObj {
  @JsonProperty("orgId")
  private Long orgId = null;

  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonIgnore
  public MsStatisticalJumpObj orgId(Long orgId) {
    this.orgId = orgId;
    return this;
  }

   /**
   * 组织id
   * @return orgId
  **/
  @ApiModelProperty(value = "组织id")
  public Long getOrgId() {
    return orgId;
  }

  public void setOrgId(Long orgId) {
    this.orgId = orgId;
  }

  @JsonIgnore
  public MsStatisticalJumpObj companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsStatisticalJumpObj purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsStatisticalJumpObj purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 公司名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsStatisticalJumpObj statisticalJumpObj = (MsStatisticalJumpObj) o;
    return Objects.equals(this.orgId, statisticalJumpObj.orgId) &&
        Objects.equals(this.companyId, statisticalJumpObj.companyId) &&
        Objects.equals(this.purchaserTaxNo, statisticalJumpObj.purchaserTaxNo) &&
        Objects.equals(this.purchaserName, statisticalJumpObj.purchaserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(orgId, companyId, purchaserTaxNo, purchaserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsStatisticalJumpObj {\n");
    
    sb.append("    orgId: ").append(toIndentedString(orgId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
