package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsStatisticalJumpObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 申请统计跳转入参
 */
@ApiModel(description = "申请统计跳转入参")

@JsonInclude(NON_NULL)
public class MsStatisticalJumpRequest {
  @JsonProperty("tenantCode")
  private String tenantCode = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("companyInfo")
  private List<MsStatisticalJumpObj> companyInfo = new ArrayList<MsStatisticalJumpObj>();

  @JsonIgnore
  public MsStatisticalJumpRequest tenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
    return this;
  }

   /**
   * 集团code
   * @return tenantCode
  **/
  @ApiModelProperty(value = "集团code")
  public String getTenantCode() {
    return tenantCode;
  }

  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "集团ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsStatisticalJumpRequest companyInfo(List<MsStatisticalJumpObj> companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

  public MsStatisticalJumpRequest addCompanyInfoItem(MsStatisticalJumpObj companyInfoItem) {
    this.companyInfo.add(companyInfoItem);
    return this;
  }

   /**
   * Get companyInfo
   * @return companyInfo
  **/
  @ApiModelProperty(value = "")
  public List<MsStatisticalJumpObj> getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(List<MsStatisticalJumpObj> companyInfo) {
    this.companyInfo = companyInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsStatisticalJumpRequest statisticalJumpRequest = (MsStatisticalJumpRequest) o;
    return Objects.equals(this.tenantCode, statisticalJumpRequest.tenantCode) &&
        Objects.equals(this.groupId, statisticalJumpRequest.groupId) &&
        Objects.equals(this.sysUserId, statisticalJumpRequest.sysUserId) &&
        Objects.equals(this.sysUserName, statisticalJumpRequest.sysUserName) &&
        Objects.equals(this.companyInfo, statisticalJumpRequest.companyInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantCode, groupId, sysUserId, sysUserName, companyInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsStatisticalJumpRequest {\n");
    
    sb.append("    tenantCode: ").append(toIndentedString(tenantCode)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
