package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsTaxPlateCompanyMain {
  @JsonProperty("companyId")
  private Long companyId = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("onlineStatus")
  private Integer onlineStatus = null;

  @JsonProperty("deviceNo")
  private String deviceNo = null;

  @JsonProperty("terminalName")
  private String terminalName = null;

  @JsonProperty("taxPlateType")
  private Integer taxPlateType = null;

  @JsonProperty("runTime")
  private java.util.Date runTime = null;

  @JsonIgnore
  public MsTaxPlateCompanyMain companyId(Long companyId) {
    this.companyId = companyId;
    return this;
  }

   /**
   * 公司id
   * @return companyId
  **/
  @ApiModelProperty(value = "公司id")
  public Long getCompanyId() {
    return companyId;
  }

  public void setCompanyId(Long companyId) {
    this.companyId = companyId;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain onlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
    return this;
  }

   /**
   * 税盘状态：1-在线，2-离线，3-异常
   * @return onlineStatus
  **/
  @ApiModelProperty(value = "税盘状态：1-在线，2-离线，3-异常")
  public Integer getOnlineStatus() {
    return onlineStatus;
  }

  public void setOnlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain deviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
    return this;
  }

   /**
   * 所属设备号
   * @return deviceNo
  **/
  @ApiModelProperty(value = "所属设备号")
  public String getDeviceNo() {
    return deviceNo;
  }

  public void setDeviceNo(String deviceNo) {
    this.deviceNo = deviceNo;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain terminalName(String terminalName) {
    this.terminalName = terminalName;
    return this;
  }

   /**
   * 终端开票标识
   * @return terminalName
  **/
  @ApiModelProperty(value = "终端开票标识")
  public String getTerminalName() {
    return terminalName;
  }

  public void setTerminalName(String terminalName) {
    this.terminalName = terminalName;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain taxPlateType(Integer taxPlateType) {
    this.taxPlateType = taxPlateType;
    return this;
  }

   /**
   * 税盘类型：1-服务器税盘，2-单机税盘
   * @return taxPlateType
  **/
  @ApiModelProperty(value = "税盘类型：1-服务器税盘，2-单机税盘")
  public Integer getTaxPlateType() {
    return taxPlateType;
  }

  public void setTaxPlateType(Integer taxPlateType) {
    this.taxPlateType = taxPlateType;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain runTime(java.util.Date runTime) {
    this.runTime = runTime;
    return this;
  }

   /**
   * 运行时间
   * @return runTime
  **/
  @ApiModelProperty(value = "运行时间")
  public java.util.Date getRunTime() {
    return runTime;
  }

  public void setRunTime(java.util.Date runTime) {
    this.runTime = runTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxPlateCompanyMain taxPlateCompanyMain = (MsTaxPlateCompanyMain) o;
    return Objects.equals(this.companyId, taxPlateCompanyMain.companyId) &&
        Objects.equals(this.companyName, taxPlateCompanyMain.companyName) &&
        Objects.equals(this.companyTaxNo, taxPlateCompanyMain.companyTaxNo) &&
        Objects.equals(this.onlineStatus, taxPlateCompanyMain.onlineStatus) &&
        Objects.equals(this.deviceNo, taxPlateCompanyMain.deviceNo) &&
        Objects.equals(this.terminalName, taxPlateCompanyMain.terminalName) &&
        Objects.equals(this.taxPlateType, taxPlateCompanyMain.taxPlateType) &&
        Objects.equals(this.runTime, taxPlateCompanyMain.runTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, companyName, companyTaxNo, onlineStatus, deviceNo, terminalName, taxPlateType, runTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxPlateCompanyMain {\n");
    
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    onlineStatus: ").append(toIndentedString(onlineStatus)).append("\n");
    sb.append("    deviceNo: ").append(toIndentedString(deviceNo)).append("\n");
    sb.append("    terminalName: ").append(toIndentedString(terminalName)).append("\n");
    sb.append("    taxPlateType: ").append(toIndentedString(taxPlateType)).append("\n");
    sb.append("    runTime: ").append(toIndentedString(runTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
