package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsTaxPlateCompanyMain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsTaxPlateInfo {
  @JsonProperty("countAll")
  private Integer countAll = null;

  @JsonProperty("countOffline")
  private Integer countOffline = null;

  @JsonProperty("countOnline")
  private Integer countOnline = null;

  @JsonProperty("countException")
  private Integer countException = null;

  @JsonProperty("companyList")
  private List<MsTaxPlateCompanyMain> companyList = new ArrayList<MsTaxPlateCompanyMain>();

  @JsonIgnore
  public MsTaxPlateInfo countAll(Integer countAll) {
    this.countAll = countAll;
    return this;
  }

   /**
   * 总税盘数
   * @return countAll
  **/
  @ApiModelProperty(value = "总税盘数")
  public Integer getCountAll() {
    return countAll;
  }

  public void setCountAll(Integer countAll) {
    this.countAll = countAll;
  }

  @JsonIgnore
  public MsTaxPlateInfo countOffline(Integer countOffline) {
    this.countOffline = countOffline;
    return this;
  }

   /**
   * 离线数
   * @return countOffline
  **/
  @ApiModelProperty(value = "离线数")
  public Integer getCountOffline() {
    return countOffline;
  }

  public void setCountOffline(Integer countOffline) {
    this.countOffline = countOffline;
  }

  @JsonIgnore
  public MsTaxPlateInfo countOnline(Integer countOnline) {
    this.countOnline = countOnline;
    return this;
  }

   /**
   * 在线数
   * @return countOnline
  **/
  @ApiModelProperty(value = "在线数")
  public Integer getCountOnline() {
    return countOnline;
  }

  public void setCountOnline(Integer countOnline) {
    this.countOnline = countOnline;
  }

  @JsonIgnore
  public MsTaxPlateInfo countException(Integer countException) {
    this.countException = countException;
    return this;
  }

   /**
   * 异常数
   * @return countException
  **/
  @ApiModelProperty(value = "异常数")
  public Integer getCountException() {
    return countException;
  }

  public void setCountException(Integer countException) {
    this.countException = countException;
  }

  @JsonIgnore
  public MsTaxPlateInfo companyList(List<MsTaxPlateCompanyMain> companyList) {
    this.companyList = companyList;
    return this;
  }

  public MsTaxPlateInfo addCompanyListItem(MsTaxPlateCompanyMain companyListItem) {
    this.companyList.add(companyListItem);
    return this;
  }

   /**
   * 公司集合
   * @return companyList
  **/
  @ApiModelProperty(value = "公司集合")
  public List<MsTaxPlateCompanyMain> getCompanyList() {
    return companyList;
  }

  public void setCompanyList(List<MsTaxPlateCompanyMain> companyList) {
    this.companyList = companyList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxPlateInfo taxPlateInfo = (MsTaxPlateInfo) o;
    return Objects.equals(this.countAll, taxPlateInfo.countAll) &&
        Objects.equals(this.countOffline, taxPlateInfo.countOffline) &&
        Objects.equals(this.countOnline, taxPlateInfo.countOnline) &&
        Objects.equals(this.countException, taxPlateInfo.countException) &&
        Objects.equals(this.companyList, taxPlateInfo.companyList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(countAll, countOffline, countOnline, countException, companyList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxPlateInfo {\n");
    
    sb.append("    countAll: ").append(toIndentedString(countAll)).append("\n");
    sb.append("    countOffline: ").append(toIndentedString(countOffline)).append("\n");
    sb.append("    countOnline: ").append(toIndentedString(countOnline)).append("\n");
    sb.append("    countException: ").append(toIndentedString(countException)).append("\n");
    sb.append("    companyList: ").append(toIndentedString(companyList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
