package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 未申报公司请求参数
 */
@ApiModel(description = "未申报公司请求参数")

@JsonInclude(NON_NULL)
public class MsUndeclaredCompanyRequest {
  @JsonProperty("authTabStatus")
  private Integer authTabStatus = null;

  @JsonProperty("purchaserTaxNos")
  private List<String> purchaserTaxNos = new ArrayList<String>();

  @JsonIgnore
  public MsUndeclaredCompanyRequest authTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
    return this;
  }

   /**
   * 认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税
   * @return authTabStatus
  **/
  @ApiModelProperty(value = "认证tab值：1-底账未认证，2-传统未认证，3-退税未认证，4-代理出口退税")
  public Integer getAuthTabStatus() {
    return authTabStatus;
  }

  public void setAuthTabStatus(Integer authTabStatus) {
    this.authTabStatus = authTabStatus;
  }

  @JsonIgnore
  public MsUndeclaredCompanyRequest purchaserTaxNos(List<String> purchaserTaxNos) {
    this.purchaserTaxNos = purchaserTaxNos;
    return this;
  }

  public MsUndeclaredCompanyRequest addPurchaserTaxNosItem(String purchaserTaxNosItem) {
    this.purchaserTaxNos.add(purchaserTaxNosItem);
    return this;
  }

   /**
   * 税号集合
   * @return purchaserTaxNos
  **/
  @ApiModelProperty(value = "税号集合")
  public List<String> getPurchaserTaxNos() {
    return purchaserTaxNos;
  }

  public void setPurchaserTaxNos(List<String> purchaserTaxNos) {
    this.purchaserTaxNos = purchaserTaxNos;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUndeclaredCompanyRequest undeclaredCompanyRequest = (MsUndeclaredCompanyRequest) o;
    return Objects.equals(this.authTabStatus, undeclaredCompanyRequest.authTabStatus) &&
        Objects.equals(this.purchaserTaxNos, undeclaredCompanyRequest.purchaserTaxNos);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authTabStatus, purchaserTaxNos);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUndeclaredCompanyRequest {\n");
    
    sb.append("    authTabStatus: ").append(toIndentedString(authTabStatus)).append("\n");
    sb.append("    purchaserTaxNos: ").append(toIndentedString(purchaserTaxNos)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
