package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 退税认证明细
 */
@ApiModel(description = "退税认证明细")

@JsonInclude(NON_NULL)
public class MsAuthDrawBackDetail {
  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("unConfirmedNum")
  private Integer unConfirmedNum = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("updateTime")
  private String updateTime = null;

  @JsonProperty("confirmStatus")
  private Integer confirmStatus = null;

  @JsonIgnore
  public MsAuthDrawBackDetail taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 税款所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "税款所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsAuthDrawBackDetail purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsAuthDrawBackDetail purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsAuthDrawBackDetail unConfirmedNum(Integer unConfirmedNum) {
    this.unConfirmedNum = unConfirmedNum;
    return this;
  }

   /**
   * 待确认发票数量
   * @return unConfirmedNum
  **/
  @ApiModelProperty(value = "待确认发票数量")
  public Integer getUnConfirmedNum() {
    return unConfirmedNum;
  }

  public void setUnConfirmedNum(Integer unConfirmedNum) {
    this.unConfirmedNum = unConfirmedNum;
  }

  @JsonIgnore
  public MsAuthDrawBackDetail taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 待确认发票税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "待确认发票税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsAuthDrawBackDetail amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 待确认发票不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "待确认发票不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsAuthDrawBackDetail amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 待确认发票含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "待确认发票含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsAuthDrawBackDetail updateTime(String updateTime) {
    this.updateTime = updateTime;
    return this;
  }

   /**
   * 操作时间
   * @return updateTime
  **/
  @ApiModelProperty(value = "操作时间")
  public String getUpdateTime() {
    return updateTime;
  }

  public void setUpdateTime(String updateTime) {
    this.updateTime = updateTime;
  }

  @JsonIgnore
  public MsAuthDrawBackDetail confirmStatus(Integer confirmStatus) {
    this.confirmStatus = confirmStatus;
    return this;
  }

   /**
   * 确认状态 0：未确认 1：本次确认中  2：本次已确认
   * @return confirmStatus
  **/
  @ApiModelProperty(value = "确认状态 0：未确认 1：本次确认中  2：本次已确认")
  public Integer getConfirmStatus() {
    return confirmStatus;
  }

  public void setConfirmStatus(Integer confirmStatus) {
    this.confirmStatus = confirmStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthDrawBackDetail authDrawBackDetail = (MsAuthDrawBackDetail) o;
    return Objects.equals(this.taxPeriod, authDrawBackDetail.taxPeriod) &&
        Objects.equals(this.purchaserTaxNo, authDrawBackDetail.purchaserTaxNo) &&
        Objects.equals(this.purchaserName, authDrawBackDetail.purchaserName) &&
        Objects.equals(this.unConfirmedNum, authDrawBackDetail.unConfirmedNum) &&
        Objects.equals(this.taxAmount, authDrawBackDetail.taxAmount) &&
        Objects.equals(this.amountWithoutTax, authDrawBackDetail.amountWithoutTax) &&
        Objects.equals(this.amountWithTax, authDrawBackDetail.amountWithTax) &&
        Objects.equals(this.updateTime, authDrawBackDetail.updateTime) &&
        Objects.equals(this.confirmStatus, authDrawBackDetail.confirmStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxPeriod, purchaserTaxNo, purchaserName, unConfirmedNum, taxAmount, amountWithoutTax, amountWithTax, updateTime, confirmStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthDrawBackDetail {\n");
    
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    unConfirmedNum: ").append(toIndentedString(unConfirmedNum)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    updateTime: ").append(toIndentedString(updateTime)).append("\n");
    sb.append("    confirmStatus: ").append(toIndentedString(confirmStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
