package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 导入勾选发票信息
 */
@ApiModel(description = "导入勾选发票信息")

@JsonInclude(NON_NULL)
public class MsAuthInvoiceModel {
  @JsonProperty("invoiceId")
  private Long invoiceId = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("authUse")
  private String authUse = null;

  @JsonIgnore
  public MsAuthInvoiceModel invoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

   /**
   * 发票id
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id")
  public Long getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(Long invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public MsAuthInvoiceModel paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsAuthInvoiceModel taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 征期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "征期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsAuthInvoiceModel taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsAuthInvoiceModel authUse(String authUse) {
    this.authUse = authUse;
    return this;
  }

   /**
   * 用途
   * @return authUse
  **/
  @ApiModelProperty(value = "用途")
  public String getAuthUse() {
    return authUse;
  }

  public void setAuthUse(String authUse) {
    this.authUse = authUse;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthInvoiceModel authInvoiceModel = (MsAuthInvoiceModel) o;
    return Objects.equals(this.invoiceId, authInvoiceModel.invoiceId) &&
        Objects.equals(this.paperDrewDate, authInvoiceModel.paperDrewDate) &&
        Objects.equals(this.taxPeriod, authInvoiceModel.taxPeriod) &&
        Objects.equals(this.taxAmount, authInvoiceModel.taxAmount) &&
        Objects.equals(this.authUse, authInvoiceModel.authUse);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, paperDrewDate, taxPeriod, taxAmount, authUse);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthInvoiceModel {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    authUse: ").append(toIndentedString(authUse)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
