package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsAuthStatisticDetail {
  @JsonProperty("declareFlag")
  private Boolean declareFlag = null;

  @JsonProperty("declareTime")
  private String declareTime = null;

  @JsonProperty("declaredCompanyNum")
  private Integer declaredCompanyNum = null;

  @JsonProperty("undeclaredCompanyNum")
  private Integer undeclaredCompanyNum = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("invoiceNum")
  private Integer invoiceNum = null;

  @JsonProperty("exceptionInvoiceNum")
  private Integer exceptionInvoiceNum = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("invoiceRate")
  private Integer invoiceRate = null;

  @JsonProperty("taxAmountRate")
  private Integer taxAmountRate = null;

  @JsonProperty("itemType")
  private Integer itemType = null;

  @JsonProperty("sInvoiceNum")
  private Integer sInvoiceNum = null;

  @JsonProperty("sTaxAmount")
  private String sTaxAmount = null;

  @JsonProperty("sAmountWithTax")
  private String sAmountWithTax = null;

  @JsonProperty("jInvoiceNum")
  private Integer jInvoiceNum = null;

  @JsonProperty("jTaxAmount")
  private String jTaxAmount = null;

  @JsonProperty("jAmountWithTax")
  private String jAmountWithTax = null;

  @JsonProperty("ctInvoiceNum")
  private Integer ctInvoiceNum = null;

  @JsonProperty("ctTaxAmount")
  private String ctTaxAmount = null;

  @JsonProperty("ctAmountWithTax")
  private String ctAmountWithTax = null;

  @JsonProperty("seInvoiceNum")
  private Integer seInvoiceNum = null;

  @JsonProperty("seTaxAmount")
  private String seTaxAmount = null;

  @JsonProperty("seAmountWithTax")
  private String seAmountWithTax = null;

  @JsonProperty("authNum")
  private Integer authNum = null;

  @JsonIgnore
  public MsAuthStatisticDetail declareFlag(Boolean declareFlag) {
    this.declareFlag = declareFlag;
    return this;
  }

   /**
   * 是否当前征期, true or false
   * @return declareFlag
  **/
  @ApiModelProperty(value = "是否当前征期, true or false")
  public Boolean getDeclareFlag() {
    return declareFlag;
  }

  public void setDeclareFlag(Boolean declareFlag) {
    this.declareFlag = declareFlag;
  }

  @JsonIgnore
  public MsAuthStatisticDetail declareTime(String declareTime) {
    this.declareTime = declareTime;
    return this;
  }

   /**
   * 所属征期
   * @return declareTime
  **/
  @ApiModelProperty(value = "所属征期")
  public String getDeclareTime() {
    return declareTime;
  }

  public void setDeclareTime(String declareTime) {
    this.declareTime = declareTime;
  }

  @JsonIgnore
  public MsAuthStatisticDetail declaredCompanyNum(Integer declaredCompanyNum) {
    this.declaredCompanyNum = declaredCompanyNum;
    return this;
  }

   /**
   * 已认证公司数
   * @return declaredCompanyNum
  **/
  @ApiModelProperty(value = "已认证公司数")
  public Integer getDeclaredCompanyNum() {
    return declaredCompanyNum;
  }

  public void setDeclaredCompanyNum(Integer declaredCompanyNum) {
    this.declaredCompanyNum = declaredCompanyNum;
  }

  @JsonIgnore
  public MsAuthStatisticDetail undeclaredCompanyNum(Integer undeclaredCompanyNum) {
    this.undeclaredCompanyNum = undeclaredCompanyNum;
    return this;
  }

   /**
   * 未认证公司数
   * @return undeclaredCompanyNum
  **/
  @ApiModelProperty(value = "未认证公司数")
  public Integer getUndeclaredCompanyNum() {
    return undeclaredCompanyNum;
  }

  public void setUndeclaredCompanyNum(Integer undeclaredCompanyNum) {
    this.undeclaredCompanyNum = undeclaredCompanyNum;
  }

  @JsonIgnore
  public MsAuthStatisticDetail companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsAuthStatisticDetail companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsAuthStatisticDetail invoiceNum(Integer invoiceNum) {
    this.invoiceNum = invoiceNum;
    return this;
  }

   /**
   * 发票数
   * @return invoiceNum
  **/
  @ApiModelProperty(value = "发票数")
  public Integer getInvoiceNum() {
    return invoiceNum;
  }

  public void setInvoiceNum(Integer invoiceNum) {
    this.invoiceNum = invoiceNum;
  }

  @JsonIgnore
  public MsAuthStatisticDetail exceptionInvoiceNum(Integer exceptionInvoiceNum) {
    this.exceptionInvoiceNum = exceptionInvoiceNum;
    return this;
  }

   /**
   * 异常发票数
   * @return exceptionInvoiceNum
  **/
  @ApiModelProperty(value = "异常发票数")
  public Integer getExceptionInvoiceNum() {
    return exceptionInvoiceNum;
  }

  public void setExceptionInvoiceNum(Integer exceptionInvoiceNum) {
    this.exceptionInvoiceNum = exceptionInvoiceNum;
  }

  @JsonIgnore
  public MsAuthStatisticDetail taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsAuthStatisticDetail amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsAuthStatisticDetail invoiceRate(Integer invoiceRate) {
    this.invoiceRate = invoiceRate;
    return this;
  }

   /**
   * 发票数增长率
   * @return invoiceRate
  **/
  @ApiModelProperty(value = "发票数增长率")
  public Integer getInvoiceRate() {
    return invoiceRate;
  }

  public void setInvoiceRate(Integer invoiceRate) {
    this.invoiceRate = invoiceRate;
  }

  @JsonIgnore
  public MsAuthStatisticDetail taxAmountRate(Integer taxAmountRate) {
    this.taxAmountRate = taxAmountRate;
    return this;
  }

   /**
   * 税额增长率
   * @return taxAmountRate
  **/
  @ApiModelProperty(value = "税额增长率")
  public Integer getTaxAmountRate() {
    return taxAmountRate;
  }

  public void setTaxAmountRate(Integer taxAmountRate) {
    this.taxAmountRate = taxAmountRate;
  }

  @JsonIgnore
  public MsAuthStatisticDetail itemType(Integer itemType) {
    this.itemType = itemType;
    return this;
  }

   /**
   * 类型：0-已申报，1-当前所属期，2-无
   * @return itemType
  **/
  @ApiModelProperty(value = "类型：0-已申报，1-当前所属期，2-无")
  public Integer getItemType() {
    return itemType;
  }

  public void setItemType(Integer itemType) {
    this.itemType = itemType;
  }

  @JsonIgnore
  public MsAuthStatisticDetail sInvoiceNum(Integer sInvoiceNum) {
    this.sInvoiceNum = sInvoiceNum;
    return this;
  }

   /**
   * 专票数
   * @return sInvoiceNum
  **/
  @ApiModelProperty(value = "专票数")
  public Integer getSInvoiceNum() {
    return sInvoiceNum;
  }

  public void setSInvoiceNum(Integer sInvoiceNum) {
    this.sInvoiceNum = sInvoiceNum;
  }

  @JsonIgnore
  public MsAuthStatisticDetail sTaxAmount(String sTaxAmount) {
    this.sTaxAmount = sTaxAmount;
    return this;
  }

   /**
   * 专票税额
   * @return sTaxAmount
  **/
  @ApiModelProperty(value = "专票税额")
  public String getSTaxAmount() {
    return sTaxAmount;
  }

  public void setSTaxAmount(String sTaxAmount) {
    this.sTaxAmount = sTaxAmount;
  }

  @JsonIgnore
  public MsAuthStatisticDetail sAmountWithTax(String sAmountWithTax) {
    this.sAmountWithTax = sAmountWithTax;
    return this;
  }

   /**
   * 专票含税金额
   * @return sAmountWithTax
  **/
  @ApiModelProperty(value = "专票含税金额")
  public String getSAmountWithTax() {
    return sAmountWithTax;
  }

  public void setSAmountWithTax(String sAmountWithTax) {
    this.sAmountWithTax = sAmountWithTax;
  }

  @JsonIgnore
  public MsAuthStatisticDetail jInvoiceNum(Integer jInvoiceNum) {
    this.jInvoiceNum = jInvoiceNum;
    return this;
  }

   /**
   * 机动车票数
   * @return jInvoiceNum
  **/
  @ApiModelProperty(value = "机动车票数")
  public Integer getJInvoiceNum() {
    return jInvoiceNum;
  }

  public void setJInvoiceNum(Integer jInvoiceNum) {
    this.jInvoiceNum = jInvoiceNum;
  }

  @JsonIgnore
  public MsAuthStatisticDetail jTaxAmount(String jTaxAmount) {
    this.jTaxAmount = jTaxAmount;
    return this;
  }

   /**
   * 机动车票税额
   * @return jTaxAmount
  **/
  @ApiModelProperty(value = "机动车票税额")
  public String getJTaxAmount() {
    return jTaxAmount;
  }

  public void setJTaxAmount(String jTaxAmount) {
    this.jTaxAmount = jTaxAmount;
  }

  @JsonIgnore
  public MsAuthStatisticDetail jAmountWithTax(String jAmountWithTax) {
    this.jAmountWithTax = jAmountWithTax;
    return this;
  }

   /**
   * 机动车票含税金额
   * @return jAmountWithTax
  **/
  @ApiModelProperty(value = "机动车票含税金额")
  public String getJAmountWithTax() {
    return jAmountWithTax;
  }

  public void setJAmountWithTax(String jAmountWithTax) {
    this.jAmountWithTax = jAmountWithTax;
  }

  @JsonIgnore
  public MsAuthStatisticDetail ctInvoiceNum(Integer ctInvoiceNum) {
    this.ctInvoiceNum = ctInvoiceNum;
    return this;
  }

   /**
   * 通行发票数
   * @return ctInvoiceNum
  **/
  @ApiModelProperty(value = "通行发票数")
  public Integer getCtInvoiceNum() {
    return ctInvoiceNum;
  }

  public void setCtInvoiceNum(Integer ctInvoiceNum) {
    this.ctInvoiceNum = ctInvoiceNum;
  }

  @JsonIgnore
  public MsAuthStatisticDetail ctTaxAmount(String ctTaxAmount) {
    this.ctTaxAmount = ctTaxAmount;
    return this;
  }

   /**
   * 通行发票税额
   * @return ctTaxAmount
  **/
  @ApiModelProperty(value = "通行发票税额")
  public String getCtTaxAmount() {
    return ctTaxAmount;
  }

  public void setCtTaxAmount(String ctTaxAmount) {
    this.ctTaxAmount = ctTaxAmount;
  }

  @JsonIgnore
  public MsAuthStatisticDetail ctAmountWithTax(String ctAmountWithTax) {
    this.ctAmountWithTax = ctAmountWithTax;
    return this;
  }

   /**
   * 通行发票含税金额
   * @return ctAmountWithTax
  **/
  @ApiModelProperty(value = "通行发票含税金额")
  public String getCtAmountWithTax() {
    return ctAmountWithTax;
  }

  public void setCtAmountWithTax(String ctAmountWithTax) {
    this.ctAmountWithTax = ctAmountWithTax;
  }

  @JsonIgnore
  public MsAuthStatisticDetail seInvoiceNum(Integer seInvoiceNum) {
    this.seInvoiceNum = seInvoiceNum;
    return this;
  }

   /**
   * 增值税电子专用发票数量
   * @return seInvoiceNum
  **/
  @ApiModelProperty(value = "增值税电子专用发票数量")
  public Integer getSeInvoiceNum() {
    return seInvoiceNum;
  }

  public void setSeInvoiceNum(Integer seInvoiceNum) {
    this.seInvoiceNum = seInvoiceNum;
  }

  @JsonIgnore
  public MsAuthStatisticDetail seTaxAmount(String seTaxAmount) {
    this.seTaxAmount = seTaxAmount;
    return this;
  }

   /**
   * 增值税电子专用发票税额
   * @return seTaxAmount
  **/
  @ApiModelProperty(value = "增值税电子专用发票税额")
  public String getSeTaxAmount() {
    return seTaxAmount;
  }

  public void setSeTaxAmount(String seTaxAmount) {
    this.seTaxAmount = seTaxAmount;
  }

  @JsonIgnore
  public MsAuthStatisticDetail seAmountWithTax(String seAmountWithTax) {
    this.seAmountWithTax = seAmountWithTax;
    return this;
  }

   /**
   * 增值税电子专用发票含税金额
   * @return seAmountWithTax
  **/
  @ApiModelProperty(value = "增值税电子专用发票含税金额")
  public String getSeAmountWithTax() {
    return seAmountWithTax;
  }

  public void setSeAmountWithTax(String seAmountWithTax) {
    this.seAmountWithTax = seAmountWithTax;
  }

  @JsonIgnore
  public MsAuthStatisticDetail authNum(Integer authNum) {
    this.authNum = authNum;
    return this;
  }

   /**
   * 认证次数
   * @return authNum
  **/
  @ApiModelProperty(value = "认证次数")
  public Integer getAuthNum() {
    return authNum;
  }

  public void setAuthNum(Integer authNum) {
    this.authNum = authNum;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthStatisticDetail authStatisticDetail = (MsAuthStatisticDetail) o;
    return Objects.equals(this.declareFlag, authStatisticDetail.declareFlag) &&
        Objects.equals(this.declareTime, authStatisticDetail.declareTime) &&
        Objects.equals(this.declaredCompanyNum, authStatisticDetail.declaredCompanyNum) &&
        Objects.equals(this.undeclaredCompanyNum, authStatisticDetail.undeclaredCompanyNum) &&
        Objects.equals(this.companyName, authStatisticDetail.companyName) &&
        Objects.equals(this.companyTaxNo, authStatisticDetail.companyTaxNo) &&
        Objects.equals(this.invoiceNum, authStatisticDetail.invoiceNum) &&
        Objects.equals(this.exceptionInvoiceNum, authStatisticDetail.exceptionInvoiceNum) &&
        Objects.equals(this.taxAmount, authStatisticDetail.taxAmount) &&
        Objects.equals(this.amountWithTax, authStatisticDetail.amountWithTax) &&
        Objects.equals(this.invoiceRate, authStatisticDetail.invoiceRate) &&
        Objects.equals(this.taxAmountRate, authStatisticDetail.taxAmountRate) &&
        Objects.equals(this.itemType, authStatisticDetail.itemType) &&
        Objects.equals(this.sInvoiceNum, authStatisticDetail.sInvoiceNum) &&
        Objects.equals(this.sTaxAmount, authStatisticDetail.sTaxAmount) &&
        Objects.equals(this.sAmountWithTax, authStatisticDetail.sAmountWithTax) &&
        Objects.equals(this.jInvoiceNum, authStatisticDetail.jInvoiceNum) &&
        Objects.equals(this.jTaxAmount, authStatisticDetail.jTaxAmount) &&
        Objects.equals(this.jAmountWithTax, authStatisticDetail.jAmountWithTax) &&
        Objects.equals(this.ctInvoiceNum, authStatisticDetail.ctInvoiceNum) &&
        Objects.equals(this.ctTaxAmount, authStatisticDetail.ctTaxAmount) &&
        Objects.equals(this.ctAmountWithTax, authStatisticDetail.ctAmountWithTax) &&
        Objects.equals(this.seInvoiceNum, authStatisticDetail.seInvoiceNum) &&
        Objects.equals(this.seTaxAmount, authStatisticDetail.seTaxAmount) &&
        Objects.equals(this.seAmountWithTax, authStatisticDetail.seAmountWithTax) &&
        Objects.equals(this.authNum, authStatisticDetail.authNum);
  }

  @Override
  public int hashCode() {
    return Objects.hash(declareFlag, declareTime, declaredCompanyNum, undeclaredCompanyNum, companyName, companyTaxNo, invoiceNum, exceptionInvoiceNum, taxAmount, amountWithTax, invoiceRate, taxAmountRate, itemType, sInvoiceNum, sTaxAmount, sAmountWithTax, jInvoiceNum, jTaxAmount, jAmountWithTax, ctInvoiceNum, ctTaxAmount, ctAmountWithTax, seInvoiceNum, seTaxAmount, seAmountWithTax, authNum);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthStatisticDetail {\n");
    
    sb.append("    declareFlag: ").append(toIndentedString(declareFlag)).append("\n");
    sb.append("    declareTime: ").append(toIndentedString(declareTime)).append("\n");
    sb.append("    declaredCompanyNum: ").append(toIndentedString(declaredCompanyNum)).append("\n");
    sb.append("    undeclaredCompanyNum: ").append(toIndentedString(undeclaredCompanyNum)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    invoiceNum: ").append(toIndentedString(invoiceNum)).append("\n");
    sb.append("    exceptionInvoiceNum: ").append(toIndentedString(exceptionInvoiceNum)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    invoiceRate: ").append(toIndentedString(invoiceRate)).append("\n");
    sb.append("    taxAmountRate: ").append(toIndentedString(taxAmountRate)).append("\n");
    sb.append("    itemType: ").append(toIndentedString(itemType)).append("\n");
    sb.append("    sInvoiceNum: ").append(toIndentedString(sInvoiceNum)).append("\n");
    sb.append("    sTaxAmount: ").append(toIndentedString(sTaxAmount)).append("\n");
    sb.append("    sAmountWithTax: ").append(toIndentedString(sAmountWithTax)).append("\n");
    sb.append("    jInvoiceNum: ").append(toIndentedString(jInvoiceNum)).append("\n");
    sb.append("    jTaxAmount: ").append(toIndentedString(jTaxAmount)).append("\n");
    sb.append("    jAmountWithTax: ").append(toIndentedString(jAmountWithTax)).append("\n");
    sb.append("    ctInvoiceNum: ").append(toIndentedString(ctInvoiceNum)).append("\n");
    sb.append("    ctTaxAmount: ").append(toIndentedString(ctTaxAmount)).append("\n");
    sb.append("    ctAmountWithTax: ").append(toIndentedString(ctAmountWithTax)).append("\n");
    sb.append("    seInvoiceNum: ").append(toIndentedString(seInvoiceNum)).append("\n");
    sb.append("    seTaxAmount: ").append(toIndentedString(seTaxAmount)).append("\n");
    sb.append("    seAmountWithTax: ").append(toIndentedString(seAmountWithTax)).append("\n");
    sb.append("    authNum: ").append(toIndentedString(authNum)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
