package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGetAuthTabsInfo
 */

@JsonInclude(NON_NULL)
public class MsGetAuthTabsInfo {
  @JsonProperty("name")
  private String name = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("total")
  private Integer total = null;

  @JsonIgnore
  public MsGetAuthTabsInfo name(String name) {
    this.name = name;
    return this;
  }

   /**
   * 标签页名称
   * @return name
  **/
  @ApiModelProperty(value = "标签页名称")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  @JsonIgnore
  public MsGetAuthTabsInfo status(Integer status) {
    this.status = status;
    return this;
  }

   /**
   * 标签页状态值
   * @return status
  **/
  @ApiModelProperty(value = "标签页状态值")
  public Integer getStatus() {
    return status;
  }

  public void setStatus(Integer status) {
    this.status = status;
  }

  @JsonIgnore
  public MsGetAuthTabsInfo total(Integer total) {
    this.total = total;
    return this;
  }

   /**
   * 标签页总数
   * @return total
  **/
  @ApiModelProperty(value = "标签页总数")
  public Integer getTotal() {
    return total;
  }

  public void setTotal(Integer total) {
    this.total = total;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetAuthTabsInfo getAuthTabsInfo = (MsGetAuthTabsInfo) o;
    return Objects.equals(this.name, getAuthTabsInfo.name) &&
        Objects.equals(this.status, getAuthTabsInfo.status) &&
        Objects.equals(this.total, getAuthTabsInfo.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, status, total);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetAuthTabsInfo {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
