package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsInvoiceIdMain {
  @JsonProperty("invoiceId")
  private List<Long> invoiceId = new ArrayList<Long>();

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("effectiveTaxAmount")
  private String effectiveTaxAmount = null;

  @JsonIgnore
  public MsInvoiceIdMain invoiceId(List<Long> invoiceId) {
    this.invoiceId = invoiceId;
    return this;
  }

  public MsInvoiceIdMain addInvoiceIdItem(Long invoiceIdItem) {
    this.invoiceId.add(invoiceIdItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceId
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceId() {
    return invoiceId;
  }

  public void setInvoiceId(List<Long> invoiceId) {
    this.invoiceId = invoiceId;
  }

  @JsonIgnore
  public MsInvoiceIdMain amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsInvoiceIdMain taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsInvoiceIdMain amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsInvoiceIdMain effectiveTaxAmount(String effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
    return this;
  }

   /**
   * 有效金额
   * @return effectiveTaxAmount
  **/
  @ApiModelProperty(value = "有效金额")
  public String getEffectiveTaxAmount() {
    return effectiveTaxAmount;
  }

  public void setEffectiveTaxAmount(String effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceIdMain invoiceIdMain = (MsInvoiceIdMain) o;
    return Objects.equals(this.invoiceId, invoiceIdMain.invoiceId) &&
        Objects.equals(this.amountWithoutTax, invoiceIdMain.amountWithoutTax) &&
        Objects.equals(this.taxAmount, invoiceIdMain.taxAmount) &&
        Objects.equals(this.amountWithTax, invoiceIdMain.amountWithTax) &&
        Objects.equals(this.effectiveTaxAmount, invoiceIdMain.effectiveTaxAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceId, amountWithoutTax, taxAmount, amountWithTax, effectiveTaxAmount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceIdMain {\n");
    
    sb.append("    invoiceId: ").append(toIndentedString(invoiceId)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    effectiveTaxAmount: ").append(toIndentedString(effectiveTaxAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
