package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsInvoiceTotalAmount {
  @JsonProperty("totalTaxAmount")
  private String totalTaxAmount = null;

  @JsonProperty("totalAmountWithTax")
  private String totalAmountWithTax = null;

  @JsonProperty("totalAmount")
  private String totalAmount = null;

  @JsonIgnore
  public MsInvoiceTotalAmount totalTaxAmount(String totalTaxAmount) {
    this.totalTaxAmount = totalTaxAmount;
    return this;
  }

   /**
   * 总税额
   * @return totalTaxAmount
  **/
  @ApiModelProperty(value = "总税额")
  public String getTotalTaxAmount() {
    return totalTaxAmount;
  }

  public void setTotalTaxAmount(String totalTaxAmount) {
    this.totalTaxAmount = totalTaxAmount;
  }

  @JsonIgnore
  public MsInvoiceTotalAmount totalAmountWithTax(String totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
    return this;
  }

   /**
   * 总金额
   * @return totalAmountWithTax
  **/
  @ApiModelProperty(value = "总金额")
  public String getTotalAmountWithTax() {
    return totalAmountWithTax;
  }

  public void setTotalAmountWithTax(String totalAmountWithTax) {
    this.totalAmountWithTax = totalAmountWithTax;
  }

  @JsonIgnore
  public MsInvoiceTotalAmount totalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * 总价税合计
   * @return totalAmount
  **/
  @ApiModelProperty(value = "总价税合计")
  public String getTotalAmount() {
    return totalAmount;
  }

  public void setTotalAmount(String totalAmount) {
    this.totalAmount = totalAmount;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceTotalAmount invoiceTotalAmount = (MsInvoiceTotalAmount) o;
    return Objects.equals(this.totalTaxAmount, invoiceTotalAmount.totalTaxAmount) &&
        Objects.equals(this.totalAmountWithTax, invoiceTotalAmount.totalAmountWithTax) &&
        Objects.equals(this.totalAmount, invoiceTotalAmount.totalAmount);
  }

  @Override
  public int hashCode() {
    return Objects.hash(totalTaxAmount, totalAmountWithTax, totalAmount);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceTotalAmount {\n");
    
    sb.append("    totalTaxAmount: ").append(toIndentedString(totalTaxAmount)).append("\n");
    sb.append("    totalAmountWithTax: ").append(toIndentedString(totalAmountWithTax)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
