package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsUndeclaredCompanyRequestObj;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 未申报公司请求对象
 */
@ApiModel(description = "未申报公司请求对象")

@JsonInclude(NON_NULL)
public class MsListUndeclaredCompanyRequest {
  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("purchaserGroupId")
  private Long purchaserGroupId = null;

  @JsonProperty("companyList")
  private List<MsUndeclaredCompanyRequestObj> companyList = new ArrayList<MsUndeclaredCompanyRequestObj>();

  @JsonIgnore
  public MsListUndeclaredCompanyRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsListUndeclaredCompanyRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsListUndeclaredCompanyRequest purchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
    return this;
  }

   /**
   * 集团id
   * @return purchaserGroupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getPurchaserGroupId() {
    return purchaserGroupId;
  }

  public void setPurchaserGroupId(Long purchaserGroupId) {
    this.purchaserGroupId = purchaserGroupId;
  }

  @JsonIgnore
  public MsListUndeclaredCompanyRequest companyList(List<MsUndeclaredCompanyRequestObj> companyList) {
    this.companyList = companyList;
    return this;
  }

  public MsListUndeclaredCompanyRequest addCompanyListItem(MsUndeclaredCompanyRequestObj companyListItem) {
    this.companyList.add(companyListItem);
    return this;
  }

   /**
   * Get companyList
   * @return companyList
  **/
  @ApiModelProperty(value = "")
  public List<MsUndeclaredCompanyRequestObj> getCompanyList() {
    return companyList;
  }

  public void setCompanyList(List<MsUndeclaredCompanyRequestObj> companyList) {
    this.companyList = companyList;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsListUndeclaredCompanyRequest listUndeclaredCompanyRequest = (MsListUndeclaredCompanyRequest) o;
    return Objects.equals(this.sysUserId, listUndeclaredCompanyRequest.sysUserId) &&
        Objects.equals(this.sysUserName, listUndeclaredCompanyRequest.sysUserName) &&
        Objects.equals(this.purchaserGroupId, listUndeclaredCompanyRequest.purchaserGroupId) &&
        Objects.equals(this.companyList, listUndeclaredCompanyRequest.companyList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sysUserId, sysUserName, purchaserGroupId, companyList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsListUndeclaredCompanyRequest {\n");
    
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    purchaserGroupId: ").append(toIndentedString(purchaserGroupId)).append("\n");
    sb.append("    companyList: ").append(toIndentedString(companyList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
