package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 发送认证统计请求参数
 */
@ApiModel(description = "发送认证统计请求参数")

@JsonInclude(NON_NULL)
public class MsSendAuthStatisticRequestObj {
  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("switchFlag")
  private Boolean switchFlag = null;

  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonIgnore
  public MsSendAuthStatisticRequestObj companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsSendAuthStatisticRequestObj companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsSendAuthStatisticRequestObj taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 征期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "征期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsSendAuthStatisticRequestObj switchFlag(Boolean switchFlag) {
    this.switchFlag = switchFlag;
    return this;
  }

   /**
   * 是否切征期，true,false
   * @return switchFlag
  **/
  @ApiModelProperty(value = "是否切征期，true,false")
  public Boolean getSwitchFlag() {
    return switchFlag;
  }

  public void setSwitchFlag(Boolean switchFlag) {
    this.switchFlag = switchFlag;
  }

  @JsonIgnore
  public MsSendAuthStatisticRequestObj invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsSendAuthStatisticRequestObj addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsSendAuthStatisticRequestObj sendAuthStatisticRequestObj = (MsSendAuthStatisticRequestObj) o;
    return Objects.equals(this.companyTaxNo, sendAuthStatisticRequestObj.companyTaxNo) &&
        Objects.equals(this.companyName, sendAuthStatisticRequestObj.companyName) &&
        Objects.equals(this.taxPeriod, sendAuthStatisticRequestObj.taxPeriod) &&
        Objects.equals(this.switchFlag, sendAuthStatisticRequestObj.switchFlag) &&
        Objects.equals(this.invoiceIds, sendAuthStatisticRequestObj.invoiceIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyTaxNo, companyName, taxPeriod, switchFlag, invoiceIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsSendAuthStatisticRequestObj {\n");
    
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    switchFlag: ").append(toIndentedString(switchFlag)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
