package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsTaxPushInvoiceMain {
  @JsonProperty("pid")
  private String pid = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("invoiceType")
  private String invoiceType = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("purchaserName")
  private String purchaserName = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("sellerName")
  private String sellerName = null;

  @JsonProperty("paperDrewDate")
  private String paperDrewDate = null;

  @JsonProperty("amountWithoutTax")
  private String amountWithoutTax = null;

  @JsonProperty("taxAmount")
  private String taxAmount = null;

  @JsonProperty("amountWithTax")
  private String amountWithTax = null;

  @JsonProperty("status")
  private String status = null;

  @JsonProperty("authStatus")
  private String authStatus = null;

  @JsonProperty("authType")
  private String authType = null;

  @JsonProperty("authResult")
  private String authResult = null;

  @JsonProperty("authTime")
  private String authTime = null;

  @JsonProperty("authRemark")
  private String authRemark = null;

  @JsonProperty("elTaxPeriod")
  private String elTaxPeriod = null;

  @JsonProperty("elUserId")
  private String elUserId = null;

  @JsonProperty("elTime")
  private String elTime = null;

  @JsonProperty("elFlag")
  private String elFlag = null;

  @JsonProperty("elEnsureTime")
  private String elEnsureTime = null;

  @JsonProperty("redFlag")
  private String redFlag = null;

  @JsonProperty("lastModifyTime")
  private String lastModifyTime = null;

  @JsonIgnore
  public MsTaxPushInvoiceMain pid(String pid) {
    this.pid = pid;
    return this;
  }

   /**
   * 税件发票id
   * @return pid
  **/
  @ApiModelProperty(value = "税件发票id")
  public String getPid() {
    return pid;
  }

  public void setPid(String pid) {
    this.pid = pid;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain invoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
    return this;
  }

   /**
   * 发票类型 s-增值税专用发票 ct-通行费发票 j-机动车销售统一发票 y-货物运输业增值税专用发票
   * @return invoiceType
  **/
  @ApiModelProperty(value = "发票类型 s-增值税专用发票 ct-通行费发票 j-机动车销售统一发票 y-货物运输业增值税专用发票")
  public String getInvoiceType() {
    return invoiceType;
  }

  public void setInvoiceType(String invoiceType) {
    this.invoiceType = invoiceType;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain purchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
    return this;
  }

   /**
   * 购方名称
   * @return purchaserName
  **/
  @ApiModelProperty(value = "购方名称")
  public String getPurchaserName() {
    return purchaserName;
  }

  public void setPurchaserName(String purchaserName) {
    this.purchaserName = purchaserName;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain sellerName(String sellerName) {
    this.sellerName = sellerName;
    return this;
  }

   /**
   * 销方名称
   * @return sellerName
  **/
  @ApiModelProperty(value = "销方名称")
  public String getSellerName() {
    return sellerName;
  }

  public void setSellerName(String sellerName) {
    this.sellerName = sellerName;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain paperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
    return this;
  }

   /**
   * 开票日期
   * @return paperDrewDate
  **/
  @ApiModelProperty(value = "开票日期")
  public String getPaperDrewDate() {
    return paperDrewDate;
  }

  public void setPaperDrewDate(String paperDrewDate) {
    this.paperDrewDate = paperDrewDate;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain amountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
    return this;
  }

   /**
   * 不含税金额
   * @return amountWithoutTax
  **/
  @ApiModelProperty(value = "不含税金额")
  public String getAmountWithoutTax() {
    return amountWithoutTax;
  }

  public void setAmountWithoutTax(String amountWithoutTax) {
    this.amountWithoutTax = amountWithoutTax;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain taxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税额")
  public String getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(String taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain amountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
    return this;
  }

   /**
   * 含税金额
   * @return amountWithTax
  **/
  @ApiModelProperty(value = "含税金额")
  public String getAmountWithTax() {
    return amountWithTax;
  }

  public void setAmountWithTax(String amountWithTax) {
    this.amountWithTax = amountWithTax;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain status(String status) {
    this.status = status;
    return this;
  }

   /**
   * 发票状态 0-作废 1-正常 8-失控
   * @return status
  **/
  @ApiModelProperty(value = "发票状态 0-作废 1-正常 8-失控")
  public String getStatus() {
    return status;
  }

  public void setStatus(String status) {
    this.status = status;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain authStatus(String authStatus) {
    this.authStatus = authStatus;
    return this;
  }

   /**
   * 认证状态 0-待认证 1-认证成功
   * @return authStatus
  **/
  @ApiModelProperty(value = "认证状态 0-待认证 1-认证成功")
  public String getAuthStatus() {
    return authStatus;
  }

  public void setAuthStatus(String authStatus) {
    this.authStatus = authStatus;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain authType(String authType) {
    this.authType = authType;
    return this;
  }

   /**
   * 认证方式 0-传统认证 1-底账认证
   * @return authType
  **/
  @ApiModelProperty(value = "认证方式 0-传统认证 1-底账认证")
  public String getAuthType() {
    return authType;
  }

  public void setAuthType(String authType) {
    this.authType = authType;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain authResult(String authResult) {
    this.authResult = authResult;
    return this;
  }

   /**
   * 认证结果-传统认证  00-认证成功
   * @return authResult
  **/
  @ApiModelProperty(value = "认证结果-传统认证  00-认证成功")
  public String getAuthResult() {
    return authResult;
  }

  public void setAuthResult(String authResult) {
    this.authResult = authResult;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain authTime(String authTime) {
    this.authTime = authTime;
    return this;
  }

   /**
   * 认证时间 - 传统认证
   * @return authTime
  **/
  @ApiModelProperty(value = "认证时间 - 传统认证")
  public String getAuthTime() {
    return authTime;
  }

  public void setAuthTime(String authTime) {
    this.authTime = authTime;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain authRemark(String authRemark) {
    this.authRemark = authRemark;
    return this;
  }

   /**
   * 认证说明 - 传统认证
   * @return authRemark
  **/
  @ApiModelProperty(value = "认证说明 - 传统认证")
  public String getAuthRemark() {
    return authRemark;
  }

  public void setAuthRemark(String authRemark) {
    this.authRemark = authRemark;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain elTaxPeriod(String elTaxPeriod) {
    this.elTaxPeriod = elTaxPeriod;
    return this;
  }

   /**
   * 税款所属期
   * @return elTaxPeriod
  **/
  @ApiModelProperty(value = "税款所属期")
  public String getElTaxPeriod() {
    return elTaxPeriod;
  }

  public void setElTaxPeriod(String elTaxPeriod) {
    this.elTaxPeriod = elTaxPeriod;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain elUserId(String elUserId) {
    this.elUserId = elUserId;
    return this;
  }

   /**
   * 底账账号
   * @return elUserId
  **/
  @ApiModelProperty(value = "底账账号")
  public String getElUserId() {
    return elUserId;
  }

  public void setElUserId(String elUserId) {
    this.elUserId = elUserId;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain elTime(String elTime) {
    this.elTime = elTime;
    return this;
  }

   /**
   * 底账获取时间
   * @return elTime
  **/
  @ApiModelProperty(value = "底账获取时间")
  public String getElTime() {
    return elTime;
  }

  public void setElTime(String elTime) {
    this.elTime = elTime;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain elFlag(String elFlag) {
    this.elFlag = elFlag;
    return this;
  }

   /**
   * 底账状态 0-未勾选1-已勾选 4-已确认 5-不可勾选确认
   * @return elFlag
  **/
  @ApiModelProperty(value = "底账状态 0-未勾选1-已勾选 4-已确认 5-不可勾选确认")
  public String getElFlag() {
    return elFlag;
  }

  public void setElFlag(String elFlag) {
    this.elFlag = elFlag;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain elEnsureTime(String elEnsureTime) {
    this.elEnsureTime = elEnsureTime;
    return this;
  }

   /**
   * 底账确认时间
   * @return elEnsureTime
  **/
  @ApiModelProperty(value = "底账确认时间")
  public String getElEnsureTime() {
    return elEnsureTime;
  }

  public void setElEnsureTime(String elEnsureTime) {
    this.elEnsureTime = elEnsureTime;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain redFlag(String redFlag) {
    this.redFlag = redFlag;
    return this;
  }

   /**
   * 红冲状态  2-已红冲
   * @return redFlag
  **/
  @ApiModelProperty(value = "红冲状态  2-已红冲")
  public String getRedFlag() {
    return redFlag;
  }

  public void setRedFlag(String redFlag) {
    this.redFlag = redFlag;
  }

  @JsonIgnore
  public MsTaxPushInvoiceMain lastModifyTime(String lastModifyTime) {
    this.lastModifyTime = lastModifyTime;
    return this;
  }

   /**
   * 最后状态更新时间
   * @return lastModifyTime
  **/
  @ApiModelProperty(value = "最后状态更新时间")
  public String getLastModifyTime() {
    return lastModifyTime;
  }

  public void setLastModifyTime(String lastModifyTime) {
    this.lastModifyTime = lastModifyTime;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxPushInvoiceMain taxPushInvoiceMain = (MsTaxPushInvoiceMain) o;
    return Objects.equals(this.pid, taxPushInvoiceMain.pid) &&
        Objects.equals(this.invoiceCode, taxPushInvoiceMain.invoiceCode) &&
        Objects.equals(this.invoiceNo, taxPushInvoiceMain.invoiceNo) &&
        Objects.equals(this.invoiceType, taxPushInvoiceMain.invoiceType) &&
        Objects.equals(this.purchaserTaxNo, taxPushInvoiceMain.purchaserTaxNo) &&
        Objects.equals(this.purchaserName, taxPushInvoiceMain.purchaserName) &&
        Objects.equals(this.sellerTaxNo, taxPushInvoiceMain.sellerTaxNo) &&
        Objects.equals(this.sellerName, taxPushInvoiceMain.sellerName) &&
        Objects.equals(this.paperDrewDate, taxPushInvoiceMain.paperDrewDate) &&
        Objects.equals(this.amountWithoutTax, taxPushInvoiceMain.amountWithoutTax) &&
        Objects.equals(this.taxAmount, taxPushInvoiceMain.taxAmount) &&
        Objects.equals(this.amountWithTax, taxPushInvoiceMain.amountWithTax) &&
        Objects.equals(this.status, taxPushInvoiceMain.status) &&
        Objects.equals(this.authStatus, taxPushInvoiceMain.authStatus) &&
        Objects.equals(this.authType, taxPushInvoiceMain.authType) &&
        Objects.equals(this.authResult, taxPushInvoiceMain.authResult) &&
        Objects.equals(this.authTime, taxPushInvoiceMain.authTime) &&
        Objects.equals(this.authRemark, taxPushInvoiceMain.authRemark) &&
        Objects.equals(this.elTaxPeriod, taxPushInvoiceMain.elTaxPeriod) &&
        Objects.equals(this.elUserId, taxPushInvoiceMain.elUserId) &&
        Objects.equals(this.elTime, taxPushInvoiceMain.elTime) &&
        Objects.equals(this.elFlag, taxPushInvoiceMain.elFlag) &&
        Objects.equals(this.elEnsureTime, taxPushInvoiceMain.elEnsureTime) &&
        Objects.equals(this.redFlag, taxPushInvoiceMain.redFlag) &&
        Objects.equals(this.lastModifyTime, taxPushInvoiceMain.lastModifyTime);
  }

  @Override
  public int hashCode() {
    return Objects.hash(pid, invoiceCode, invoiceNo, invoiceType, purchaserTaxNo, purchaserName, sellerTaxNo, sellerName, paperDrewDate, amountWithoutTax, taxAmount, amountWithTax, status, authStatus, authType, authResult, authTime, authRemark, elTaxPeriod, elUserId, elTime, elFlag, elEnsureTime, redFlag, lastModifyTime);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxPushInvoiceMain {\n");
    
    sb.append("    pid: ").append(toIndentedString(pid)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    invoiceType: ").append(toIndentedString(invoiceType)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    purchaserName: ").append(toIndentedString(purchaserName)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    sellerName: ").append(toIndentedString(sellerName)).append("\n");
    sb.append("    paperDrewDate: ").append(toIndentedString(paperDrewDate)).append("\n");
    sb.append("    amountWithoutTax: ").append(toIndentedString(amountWithoutTax)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    amountWithTax: ").append(toIndentedString(amountWithTax)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    authStatus: ").append(toIndentedString(authStatus)).append("\n");
    sb.append("    authType: ").append(toIndentedString(authType)).append("\n");
    sb.append("    authResult: ").append(toIndentedString(authResult)).append("\n");
    sb.append("    authTime: ").append(toIndentedString(authTime)).append("\n");
    sb.append("    authRemark: ").append(toIndentedString(authRemark)).append("\n");
    sb.append("    elTaxPeriod: ").append(toIndentedString(elTaxPeriod)).append("\n");
    sb.append("    elUserId: ").append(toIndentedString(elUserId)).append("\n");
    sb.append("    elTime: ").append(toIndentedString(elTime)).append("\n");
    sb.append("    elFlag: ").append(toIndentedString(elFlag)).append("\n");
    sb.append("    elEnsureTime: ").append(toIndentedString(elEnsureTime)).append("\n");
    sb.append("    redFlag: ").append(toIndentedString(redFlag)).append("\n");
    sb.append("    lastModifyTime: ").append(toIndentedString(lastModifyTime)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
