package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 二元字符组
 */
@ApiModel(description = "二元字符组")

@JsonInclude(NON_NULL)
public class MsTuple2 {
  @JsonProperty("first")
  private String first = null;

  @JsonProperty("second")
  private String second = null;

  @JsonIgnore
  public MsTuple2 first(String first) {
    this.first = first;
    return this;
  }

   /**
   * first element
   * @return first
  **/
  @ApiModelProperty(value = "first element")
  public String getFirst() {
    return first;
  }

  public void setFirst(String first) {
    this.first = first;
  }

  @JsonIgnore
  public MsTuple2 second(String second) {
    this.second = second;
    return this;
  }

   /**
   * second element
   * @return second
  **/
  @ApiModelProperty(value = "second element")
  public String getSecond() {
    return second;
  }

  public void setSecond(String second) {
    this.second = second;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTuple2 tuple2 = (MsTuple2) o;
    return Objects.equals(this.first, tuple2.first) &&
        Objects.equals(this.second, tuple2.second);
  }

  @Override
  public int hashCode() {
    return Objects.hash(first, second);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTuple2 {\n");
    
    sb.append("    first: ").append(toIndentedString(first)).append("\n");
    sb.append("    second: ").append(toIndentedString(second)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
