package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 进转出对象
 */
@ApiModel(description = "进转出对象")

@JsonInclude(NON_NULL)
public class MsTurnOutInvoiceRequest {
  @JsonProperty("turnOutRemark")
  private String turnOutRemark = null;

  @JsonProperty("turnOutType")
  private Integer turnOutType = null;

  @JsonProperty("turnOutAmount")
  private String turnOutAmount = null;

  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonIgnore
  public MsTurnOutInvoiceRequest turnOutRemark(String turnOutRemark) {
    this.turnOutRemark = turnOutRemark;
    return this;
  }

   /**
   * 进转出描述
   * @return turnOutRemark
  **/
  @ApiModelProperty(value = "进转出描述")
  public String getTurnOutRemark() {
    return turnOutRemark;
  }

  public void setTurnOutRemark(String turnOutRemark) {
    this.turnOutRemark = turnOutRemark;
  }

  @JsonIgnore
  public MsTurnOutInvoiceRequest turnOutType(Integer turnOutType) {
    this.turnOutType = turnOutType;
    return this;
  }

   /**
   * 进转出类型
   * @return turnOutType
  **/
  @ApiModelProperty(value = "进转出类型")
  public Integer getTurnOutType() {
    return turnOutType;
  }

  public void setTurnOutType(Integer turnOutType) {
    this.turnOutType = turnOutType;
  }

  @JsonIgnore
  public MsTurnOutInvoiceRequest turnOutAmount(String turnOutAmount) {
    this.turnOutAmount = turnOutAmount;
    return this;
  }

   /**
   * 进转出金额
   * @return turnOutAmount
  **/
  @ApiModelProperty(value = "进转出金额")
  public String getTurnOutAmount() {
    return turnOutAmount;
  }

  public void setTurnOutAmount(String turnOutAmount) {
    this.turnOutAmount = turnOutAmount;
  }

  @JsonIgnore
  public MsTurnOutInvoiceRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsTurnOutInvoiceRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票id集合
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票id集合")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public MsTurnOutInvoiceRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsTurnOutInvoiceRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsTurnOutInvoiceRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsTurnOutInvoiceRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTurnOutInvoiceRequest turnOutInvoiceRequest = (MsTurnOutInvoiceRequest) o;
    return Objects.equals(this.turnOutRemark, turnOutInvoiceRequest.turnOutRemark) &&
        Objects.equals(this.turnOutType, turnOutInvoiceRequest.turnOutType) &&
        Objects.equals(this.turnOutAmount, turnOutInvoiceRequest.turnOutAmount) &&
        Objects.equals(this.invoiceIds, turnOutInvoiceRequest.invoiceIds) &&
        Objects.equals(this.orgIdList, turnOutInvoiceRequest.orgIdList) &&
        Objects.equals(this.sysUserId, turnOutInvoiceRequest.sysUserId) &&
        Objects.equals(this.sysUserName, turnOutInvoiceRequest.sysUserName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(turnOutRemark, turnOutType, turnOutAmount, invoiceIds, orgIdList, sysUserId, sysUserName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTurnOutInvoiceRequest {\n");
    
    sb.append("    turnOutRemark: ").append(toIndentedString(turnOutRemark)).append("\n");
    sb.append("    turnOutType: ").append(toIndentedString(turnOutType)).append("\n");
    sb.append("    turnOutAmount: ").append(toIndentedString(turnOutAmount)).append("\n");
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
