package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonInclude(NON_NULL)
public class MsUpdateHangInfoRequest {
  @JsonProperty("invoiceIds")
  private List<Long> invoiceIds = new ArrayList<Long>();

  @JsonProperty("hangStatus")
  private Integer hangStatus = null;

  @JsonProperty("hangRemark")
  private String hangRemark = null;

  @JsonProperty("orgIdList")
  private List<Long> orgIdList = new ArrayList<Long>();

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonIgnore
  public MsUpdateHangInfoRequest invoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
    return this;
  }

  public MsUpdateHangInfoRequest addInvoiceIdsItem(Long invoiceIdsItem) {
    this.invoiceIds.add(invoiceIdsItem);
    return this;
  }

   /**
   * 发票ID 列表
   * @return invoiceIds
  **/
  @ApiModelProperty(value = "发票ID 列表")
  public List<Long> getInvoiceIds() {
    return invoiceIds;
  }

  public void setInvoiceIds(List<Long> invoiceIds) {
    this.invoiceIds = invoiceIds;
  }

  @JsonIgnore
  public MsUpdateHangInfoRequest hangStatus(Integer hangStatus) {
    this.hangStatus = hangStatus;
    return this;
  }

   /**
   * 0：默认（未挂起），1:已挂起
   * @return hangStatus
  **/
  @ApiModelProperty(value = "0：默认（未挂起），1:已挂起")
  public Integer getHangStatus() {
    return hangStatus;
  }

  public void setHangStatus(Integer hangStatus) {
    this.hangStatus = hangStatus;
  }

  @JsonIgnore
  public MsUpdateHangInfoRequest hangRemark(String hangRemark) {
    this.hangRemark = hangRemark;
    return this;
  }

   /**
   * 挂起原因
   * @return hangRemark
  **/
  @ApiModelProperty(value = "挂起原因")
  public String getHangRemark() {
    return hangRemark;
  }

  public void setHangRemark(String hangRemark) {
    this.hangRemark = hangRemark;
  }

  @JsonIgnore
  public MsUpdateHangInfoRequest orgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
    return this;
  }

  public MsUpdateHangInfoRequest addOrgIdListItem(Long orgIdListItem) {
    this.orgIdList.add(orgIdListItem);
    return this;
  }

   /**
   * 组织id
   * @return orgIdList
  **/
  @ApiModelProperty(value = "组织id")
  public List<Long> getOrgIdList() {
    return orgIdList;
  }

  public void setOrgIdList(List<Long> orgIdList) {
    this.orgIdList = orgIdList;
  }

  @JsonIgnore
  public MsUpdateHangInfoRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 用户id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "用户id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsUpdateHangInfoRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 用户名称
   * @return sysUserName
  **/
  @ApiModelProperty(value = "用户名称")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsUpdateHangInfoRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团id
   * @return groupId
  **/
  @ApiModelProperty(value = "集团id")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsUpdateHangInfoRequest updateHangInfoRequest = (MsUpdateHangInfoRequest) o;
    return Objects.equals(this.invoiceIds, updateHangInfoRequest.invoiceIds) &&
        Objects.equals(this.hangStatus, updateHangInfoRequest.hangStatus) &&
        Objects.equals(this.hangRemark, updateHangInfoRequest.hangRemark) &&
        Objects.equals(this.orgIdList, updateHangInfoRequest.orgIdList) &&
        Objects.equals(this.sysUserId, updateHangInfoRequest.sysUserId) &&
        Objects.equals(this.sysUserName, updateHangInfoRequest.sysUserName) &&
        Objects.equals(this.groupId, updateHangInfoRequest.groupId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIds, hangStatus, hangRemark, orgIdList, sysUserId, sysUserName, groupId);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsUpdateHangInfoRequest {\n");
    
    sb.append("    invoiceIds: ").append(toIndentedString(invoiceIds)).append("\n");
    sb.append("    hangStatus: ").append(toIndentedString(hangStatus)).append("\n");
    sb.append("    hangRemark: ").append(toIndentedString(hangRemark)).append("\n");
    sb.append("    orgIdList: ").append(toIndentedString(orgIdList)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
