package com.xforceplus.phoenix.auth.client.api;

import com.xforceplus.phoenix.auth.client.model.MsAmountAggregationResponse;
import com.xforceplus.phoenix.auth.client.model.MsAuthInvoiceRequest;
import com.xforceplus.phoenix.auth.client.model.MsAuthResponse;
import com.xforceplus.phoenix.auth.client.model.MsAuthTemplateResponse;
import com.xforceplus.phoenix.auth.client.model.MsCompanyMainResponse;
import com.xforceplus.phoenix.auth.client.model.MsCompanyRequest;
import com.xforceplus.phoenix.auth.client.model.MsGetAuthTabsResponse;
import com.xforceplus.phoenix.auth.client.model.MsImportInvoiceAuthDataRequest;
import com.xforceplus.phoenix.auth.client.model.MsInvoiceAuthStatusCountResponse;
import com.xforceplus.phoenix.auth.client.model.MsInvoiceIdResponse;
import com.xforceplus.phoenix.auth.client.model.MsInvoiceMainResponse;
import com.xforceplus.phoenix.auth.client.model.MsInvoiceTotalAmountResponse;
import com.xforceplus.phoenix.auth.client.model.MsUpdateHangInfoRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "authIndex", description = "the authIndex API")
public interface AuthIndexApi {

    @ApiOperation(value = "根据查询条件汇总发票金额", notes = "", response = MsAmountAggregationResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsAmountAggregationResponse.class) })
    @RequestMapping(value = "/authIndex/amountAggregation",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAmountAggregationResponse amountAggregation(@ApiParam(value = "parameter" ,required=true ) @RequestBody MsAuthInvoiceRequest request);


    @ApiOperation(value = "批量选中前1000条发票认证首页数据", notes = "", response = MsInvoiceIdResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsInvoiceIdResponse.class) })
    @RequestMapping(value = "/authIndex/batch-selection/authInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceIdResponse batchSelectionAuthInvoices(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthInvoiceRequest request);


    @ApiOperation(value = "首页统计总金额", notes = "", response = MsInvoiceTotalAmountResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsInvoiceTotalAmountResponse.class) })
    @RequestMapping(value = "/authIndex/countAuthInvoiceAmount",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceTotalAmountResponse countAuthInvoiceAmount(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthInvoiceRequest request);


    @ApiOperation(value = "首页统计各认证状态发票数", notes = "", response = MsInvoiceAuthStatusCountResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsInvoiceAuthStatusCountResponse.class) })
    @RequestMapping(value = "/authIndex/countAuthInvoiceNumByStatus",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceAuthStatusCountResponse countAuthInvoiceNumByStatus(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthInvoiceRequest request);


    @ApiOperation(value = "下载认证导入模板", notes = "", response = MsAuthTemplateResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsAuthTemplateResponse.class) })
    @RequestMapping(value = "/authIndex/downloadInvoiceAuthTemplate",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthTemplateResponse downloadInvoiceAuthTemplate();


    @ApiOperation(value = "查询发票全部tab统计", notes = "", response = MsGetAuthTabsResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "返回结果", response = MsGetAuthTabsResponse.class) })
    @RequestMapping(value = "/authIndex/getAuthTabs",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetAuthTabsResponse getAuthTabs(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthInvoiceRequest request);


    @ApiOperation(value = "导入认证数据", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authIndex/importInvoiceAuthData",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse importInvoiceAuthData(@ApiParam(value = "request" ,required=true ) @RequestBody MsImportInvoiceAuthDataRequest request);


    @ApiOperation(value = "获取发票认证首页数据", notes = "", response = MsInvoiceMainResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsInvoiceMainResponse.class) })
    @RequestMapping(value = "/authIndex/listAuthInvoices",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsInvoiceMainResponse listAuthInvoices(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthInvoiceRequest request);


    @ApiOperation(value = "有认证权限的公司集合", notes = "", response = MsCompanyMainResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsCompanyMainResponse.class) })
    @RequestMapping(value = "/authIndex/listCompanyInfos",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCompanyMainResponse listCompanyInfos(@ApiParam(value = "request" ,required=true ) @RequestBody MsCompanyRequest request);


    @ApiOperation(value = "修改发票挂起信息", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthIndex", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "统一返回", response = MsAuthResponse.class) })
    @RequestMapping(value = "/authIndex/updateHangInfo",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse updateHangInfo(@ApiParam(value = "request" ,required=true ) @RequestBody MsUpdateHangInfoRequest request);

}
