package com.xforceplus.phoenix.auth.client.api;

import com.xforceplus.phoenix.auth.client.model.MsAuthStatisticDetailResponse;
import com.xforceplus.phoenix.auth.client.model.MsAuthStatisticInfoResponse;
import com.xforceplus.phoenix.auth.client.model.MsAuthStatisticRequest;
import com.xforceplus.phoenix.auth.client.model.MsCompanyMainResponse;
import com.xforceplus.phoenix.auth.client.model.MsCompanyRequest;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "authStatistic", description = "the authStatistic API")
public interface AuthStatisticApi {

    @ApiOperation(value = "获取认证统计发票明细列表", notes = "", response = MsAuthStatisticInfoResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthStatistic", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthStatisticInfoResponse.class) })
    @RequestMapping(value = "/authStatistic/getStatisticDetail",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthStatisticInfoResponse getStatisticDetail(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthStatisticRequest request);


    @ApiOperation(value = "获取当前账号下所有公司信息", notes = "", response = MsCompanyMainResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthStatistic", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsCompanyMainResponse.class) })
    @RequestMapping(value = "/authStatistic/listCompanyInfosForStatistic",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCompanyMainResponse listCompanyInfosForStatistic(@ApiParam(value = "request" ,required=true ) @RequestBody MsCompanyRequest request);


    @ApiOperation(value = "获取认证统计列表，根据条件", notes = "", response = MsAuthStatisticDetailResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "AuthStatistic", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthStatisticDetailResponse.class) })
    @RequestMapping(value = "/authStatistic/listStatisticData",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthStatisticDetailResponse listStatisticData(@ApiParam(value = "request" ,required=true ) @RequestBody MsAuthStatisticRequest request);

}
