package com.xforceplus.phoenix.auth.client.api;

import com.xforceplus.phoenix.auth.client.model.MsAuthResponse;
import com.xforceplus.phoenix.auth.client.model.MsCustomsDeductionRequest;
import com.xforceplus.phoenix.auth.client.model.MsCustomsPaymentFormResponse;
import com.xforceplus.phoenix.auth.client.model.MsCustomsPaymentFormSubmit;
import com.xforceplus.phoenix.auth.client.model.MsCustomsPaymentFormSummaryResponse;
import com.xforceplus.phoenix.auth.client.model.MsGetAuthTabsResponse;
import com.xforceplus.phoenix.auth.client.model.MsSearchCustomsPaymentForm;

import io.swagger.annotations.*;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;
import java.util.List;

import javax.validation.constraints.*;
import javax.validation.Valid;


@Api(value = "customsRequest", description = "the customsRequest API")
public interface CustomsRequestApi {

    @ApiOperation(value = "海关缴款书 抵扣勾选/撤销勾选", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "CustomsRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/customsRequest/customsPaymentForm/deduction",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse customsPaymentDeduction(@ApiParam(value = "request" ,required=true ) @RequestBody MsCustomsDeductionRequest request);


    @ApiOperation(value = "海关缴款书列表count", notes = "", response = MsGetAuthTabsResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "CustomsRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsGetAuthTabsResponse.class) })
    @RequestMapping(value = "/customsRequest/customsPaymentForm/count",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsGetAuthTabsResponse customsPaymentFormCount(@ApiParam(value = "request" ,required=true ) @RequestBody MsSearchCustomsPaymentForm request);


    @ApiOperation(value = "海关缴款书导出", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "CustomsRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/customsRequest/customsPaymentForm/export",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse customsPaymentFormExport(@ApiParam(value = "request" ,required=true ) @RequestBody MsSearchCustomsPaymentForm request);


    @ApiOperation(value = "海关缴款书列表查询", notes = "", response = MsCustomsPaymentFormResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "CustomsRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsCustomsPaymentFormResponse.class) })
    @RequestMapping(value = "/customsRequest/customsPaymentForm/list",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCustomsPaymentFormResponse customsPaymentFormList(@ApiParam(value = "request" ,required=true ) @RequestBody MsSearchCustomsPaymentForm request);


    @ApiOperation(value = "海关缴款书 抵扣勾选/撤销勾选 汇总列表", notes = "", response = MsCustomsPaymentFormSummaryResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "CustomsRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsCustomsPaymentFormSummaryResponse.class) })
    @RequestMapping(value = "/customsRequest/customsPaymentForm/summary/list",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsCustomsPaymentFormSummaryResponse customsPaymentSummary(@ApiParam(value = "request" ,required=true ) @RequestBody MsCustomsPaymentFormSubmit request);


    @ApiOperation(value = "海关缴款书有效税款金额修改", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "CustomsRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "response", response = MsAuthResponse.class) })
    @RequestMapping(value = "/customsRequest/customsPaymentForm/list",
        produces = { "application/json" }, 
        method = RequestMethod.PUT)
     MsAuthResponse customsPaymentUpdate(@ApiParam(value = "request 修改时填写taxBillNo 和 effectiveTaxAmount参数" ,required=true ) @RequestBody MsCustomsPaymentFormSubmit request);


    @ApiOperation(value = "申请统计跳转", notes = "", response = MsAuthResponse.class, authorizations = {
        @Authorization(value = "X-Access-Token"),
        @Authorization(value = "X-Operation-Token")
    }, tags={ "CustomsRequest", })
    @ApiResponses(value = { 
        @ApiResponse(code = 200, message = "OK", response = MsAuthResponse.class) })
    @RequestMapping(value = "/customsRequest/statisticalJump",
        produces = { "application/json" }, 
        method = RequestMethod.POST)
     MsAuthResponse statisticalJump();

}
