package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsAuthStatisticDetail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsAuthStatisticInfo {
  @JsonProperty("tenantInfo")
  private MsAuthStatisticDetail tenantInfo = null;

  @JsonProperty("companyInfo")
  private List<MsAuthStatisticDetail> companyInfo = new ArrayList<MsAuthStatisticDetail>();

  @JsonIgnore
  public MsAuthStatisticInfo tenantInfo(MsAuthStatisticDetail tenantInfo) {
    this.tenantInfo = tenantInfo;
    return this;
  }

   /**
   * 集团认证统计数据
   * @return tenantInfo
  **/
  @ApiModelProperty(value = "集团认证统计数据")
  public MsAuthStatisticDetail getTenantInfo() {
    return tenantInfo;
  }

  public void setTenantInfo(MsAuthStatisticDetail tenantInfo) {
    this.tenantInfo = tenantInfo;
  }

  @JsonIgnore
  public MsAuthStatisticInfo companyInfo(List<MsAuthStatisticDetail> companyInfo) {
    this.companyInfo = companyInfo;
    return this;
  }

  public MsAuthStatisticInfo addCompanyInfoItem(MsAuthStatisticDetail companyInfoItem) {
    this.companyInfo.add(companyInfoItem);
    return this;
  }

   /**
   * 公司认证统计信息集合
   * @return companyInfo
  **/
  @ApiModelProperty(value = "公司认证统计信息集合")
  public List<MsAuthStatisticDetail> getCompanyInfo() {
    return companyInfo;
  }

  public void setCompanyInfo(List<MsAuthStatisticDetail> companyInfo) {
    this.companyInfo = companyInfo;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsAuthStatisticInfo authStatisticInfo = (MsAuthStatisticInfo) o;
    return Objects.equals(this.tenantInfo, authStatisticInfo.tenantInfo) &&
        Objects.equals(this.companyInfo, authStatisticInfo.companyInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tenantInfo, companyInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsAuthStatisticInfo {\n");
    
    sb.append("    tenantInfo: ").append(toIndentedString(tenantInfo)).append("\n");
    sb.append("    companyInfo: ").append(toIndentedString(companyInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
