package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsCustomsPaymentForm;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 抵扣请求对象
 */
@ApiModel(description = "抵扣请求对象")

@JsonInclude(NON_NULL)
public class MsCustomsDeductionRequestObj {
  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("taxPeriod")
  private String taxPeriod = null;

  @JsonProperty("checkCount")
  private Integer checkCount = null;

  @JsonProperty("sendCount")
  private Integer sendCount = null;

  @JsonProperty("unsendableCount")
  private Integer unsendableCount = null;

  @JsonProperty("customsList")
  private List<MsCustomsPaymentForm> customsList = new ArrayList<MsCustomsPaymentForm>();

  @JsonProperty("unsendableList")
  private List<MsCustomsPaymentForm> unsendableList = new ArrayList<MsCustomsPaymentForm>();

  @JsonProperty("taxAmount")
  private BigDecimal taxAmount = null;

  @JsonProperty("effectiveTaxAmount")
  private BigDecimal effectiveTaxAmount = null;

  @JsonProperty("blockStatus")
  private Integer blockStatus = null;

  @JsonProperty("onlineStatus")
  private Integer onlineStatus = null;

  @JsonIgnore
  public MsCustomsDeductionRequestObj companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj taxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
    return this;
  }

   /**
   * 税款所属期
   * @return taxPeriod
  **/
  @ApiModelProperty(value = "税款所属期")
  public String getTaxPeriod() {
    return taxPeriod;
  }

  public void setTaxPeriod(String taxPeriod) {
    this.taxPeriod = taxPeriod;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj checkCount(Integer checkCount) {
    this.checkCount = checkCount;
    return this;
  }

   /**
   * 勾选数量
   * @return checkCount
  **/
  @ApiModelProperty(value = "勾选数量")
  public Integer getCheckCount() {
    return checkCount;
  }

  public void setCheckCount(Integer checkCount) {
    this.checkCount = checkCount;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj sendCount(Integer sendCount) {
    this.sendCount = sendCount;
    return this;
  }

   /**
   * 可发送勾选数量
   * @return sendCount
  **/
  @ApiModelProperty(value = "可发送勾选数量")
  public Integer getSendCount() {
    return sendCount;
  }

  public void setSendCount(Integer sendCount) {
    this.sendCount = sendCount;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj unsendableCount(Integer unsendableCount) {
    this.unsendableCount = unsendableCount;
    return this;
  }

   /**
   * 不可发送勾选数量
   * @return unsendableCount
  **/
  @ApiModelProperty(value = "不可发送勾选数量")
  public Integer getUnsendableCount() {
    return unsendableCount;
  }

  public void setUnsendableCount(Integer unsendableCount) {
    this.unsendableCount = unsendableCount;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj customsList(List<MsCustomsPaymentForm> customsList) {
    this.customsList = customsList;
    return this;
  }

  public MsCustomsDeductionRequestObj addCustomsListItem(MsCustomsPaymentForm customsListItem) {
    this.customsList.add(customsListItem);
    return this;
  }

   /**
   * 缴款书集合
   * @return customsList
  **/
  @ApiModelProperty(value = "缴款书集合")
  public List<MsCustomsPaymentForm> getCustomsList() {
    return customsList;
  }

  public void setCustomsList(List<MsCustomsPaymentForm> customsList) {
    this.customsList = customsList;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj unsendableList(List<MsCustomsPaymentForm> unsendableList) {
    this.unsendableList = unsendableList;
    return this;
  }

  public MsCustomsDeductionRequestObj addUnsendableListItem(MsCustomsPaymentForm unsendableListItem) {
    this.unsendableList.add(unsendableListItem);
    return this;
  }

   /**
   * 缴款书集合
   * @return unsendableList
  **/
  @ApiModelProperty(value = "缴款书集合")
  public List<MsCustomsPaymentForm> getUnsendableList() {
    return unsendableList;
  }

  public void setUnsendableList(List<MsCustomsPaymentForm> unsendableList) {
    this.unsendableList = unsendableList;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj taxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
    return this;
  }

   /**
   * 税款金额
   * @return taxAmount
  **/
  @ApiModelProperty(value = "税款金额")
  public BigDecimal getTaxAmount() {
    return taxAmount;
  }

  public void setTaxAmount(BigDecimal taxAmount) {
    this.taxAmount = taxAmount;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj effectiveTaxAmount(BigDecimal effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
    return this;
  }

   /**
   * 有效税款金额
   * @return effectiveTaxAmount
  **/
  @ApiModelProperty(value = "有效税款金额")
  public BigDecimal getEffectiveTaxAmount() {
    return effectiveTaxAmount;
  }

  public void setEffectiveTaxAmount(BigDecimal effectiveTaxAmount) {
    this.effectiveTaxAmount = effectiveTaxAmount;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj blockStatus(Integer blockStatus) {
    this.blockStatus = blockStatus;
    return this;
  }

   /**
   * 封锁状态，1-未封锁，2-已封锁
   * @return blockStatus
  **/
  @ApiModelProperty(value = "封锁状态，1-未封锁，2-已封锁")
  public Integer getBlockStatus() {
    return blockStatus;
  }

  public void setBlockStatus(Integer blockStatus) {
    this.blockStatus = blockStatus;
  }

  @JsonIgnore
  public MsCustomsDeductionRequestObj onlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
    return this;
  }

   /**
   * 税盘状态：1-在线，2-离线，3-异常
   * @return onlineStatus
  **/
  @ApiModelProperty(value = "税盘状态：1-在线，2-离线，3-异常")
  public Integer getOnlineStatus() {
    return onlineStatus;
  }

  public void setOnlineStatus(Integer onlineStatus) {
    this.onlineStatus = onlineStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsCustomsDeductionRequestObj customsDeductionRequestObj = (MsCustomsDeductionRequestObj) o;
    return Objects.equals(this.companyTaxNo, customsDeductionRequestObj.companyTaxNo) &&
        Objects.equals(this.companyName, customsDeductionRequestObj.companyName) &&
        Objects.equals(this.taxPeriod, customsDeductionRequestObj.taxPeriod) &&
        Objects.equals(this.checkCount, customsDeductionRequestObj.checkCount) &&
        Objects.equals(this.sendCount, customsDeductionRequestObj.sendCount) &&
        Objects.equals(this.unsendableCount, customsDeductionRequestObj.unsendableCount) &&
        Objects.equals(this.customsList, customsDeductionRequestObj.customsList) &&
        Objects.equals(this.unsendableList, customsDeductionRequestObj.unsendableList) &&
        Objects.equals(this.taxAmount, customsDeductionRequestObj.taxAmount) &&
        Objects.equals(this.effectiveTaxAmount, customsDeductionRequestObj.effectiveTaxAmount) &&
        Objects.equals(this.blockStatus, customsDeductionRequestObj.blockStatus) &&
        Objects.equals(this.onlineStatus, customsDeductionRequestObj.onlineStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyTaxNo, companyName, taxPeriod, checkCount, sendCount, unsendableCount, customsList, unsendableList, taxAmount, effectiveTaxAmount, blockStatus, onlineStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsCustomsDeductionRequestObj {\n");
    
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    taxPeriod: ").append(toIndentedString(taxPeriod)).append("\n");
    sb.append("    checkCount: ").append(toIndentedString(checkCount)).append("\n");
    sb.append("    sendCount: ").append(toIndentedString(sendCount)).append("\n");
    sb.append("    unsendableCount: ").append(toIndentedString(unsendableCount)).append("\n");
    sb.append("    customsList: ").append(toIndentedString(customsList)).append("\n");
    sb.append("    unsendableList: ").append(toIndentedString(unsendableList)).append("\n");
    sb.append("    taxAmount: ").append(toIndentedString(taxAmount)).append("\n");
    sb.append("    effectiveTaxAmount: ").append(toIndentedString(effectiveTaxAmount)).append("\n");
    sb.append("    blockStatus: ").append(toIndentedString(blockStatus)).append("\n");
    sb.append("    onlineStatus: ").append(toIndentedString(onlineStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
