package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.xforceplus.phoenix.auth.client.model.MsGetAuthTabsInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * MsGetAuthTabsResponse
 */

@JsonInclude(NON_NULL)
public class MsGetAuthTabsResponse {
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("result")
  private List<MsGetAuthTabsInfo> result = new ArrayList<MsGetAuthTabsInfo>();

  @JsonIgnore
  public MsGetAuthTabsResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * null
   * @return code
  **/
  @ApiModelProperty(value = "null")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetAuthTabsResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * null
   * @return message
  **/
  @ApiModelProperty(value = "null")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetAuthTabsResponse result(List<MsGetAuthTabsInfo> result) {
    this.result = result;
    return this;
  }

  public MsGetAuthTabsResponse addResultItem(MsGetAuthTabsInfo resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * Get result
   * @return result
  **/
  @ApiModelProperty(value = "")
  public List<MsGetAuthTabsInfo> getResult() {
    return result;
  }

  public void setResult(List<MsGetAuthTabsInfo> result) {
    this.result = result;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetAuthTabsResponse getAuthTabsResponse = (MsGetAuthTabsResponse) o;
    return Objects.equals(this.code, getAuthTabsResponse.code) &&
        Objects.equals(this.message, getAuthTabsResponse.message) &&
        Objects.equals(this.result, getAuthTabsResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetAuthTabsResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
