package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 导入认证文件信息
 */
@ApiModel(description = "导入认证文件信息")

@JsonInclude(NON_NULL)
public class MsImportAuthRequest {
  @JsonProperty("ossKey")
  private String ossKey = null;

  @JsonProperty("sysUserId")
  private Long sysUserId = null;

  @JsonProperty("sysUserName")
  private String sysUserName = null;

  @JsonProperty("groupId")
  private Long groupId = null;

  @JsonProperty("orgIds")
  private List<Long> orgIds = new ArrayList<Long>();

  @JsonIgnore
  public MsImportAuthRequest ossKey(String ossKey) {
    this.ossKey = ossKey;
    return this;
  }

   /**
   * oss文件路径[fileDirectory+uploadFileName]
   * @return ossKey
  **/
  @ApiModelProperty(value = "oss文件路径[fileDirectory+uploadFileName]")
  public String getOssKey() {
    return ossKey;
  }

  public void setOssKey(String ossKey) {
    this.ossKey = ossKey;
  }

  @JsonIgnore
  public MsImportAuthRequest sysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
    return this;
  }

   /**
   * 操作者id
   * @return sysUserId
  **/
  @ApiModelProperty(value = "操作者id")
  public Long getSysUserId() {
    return sysUserId;
  }

  public void setSysUserId(Long sysUserId) {
    this.sysUserId = sysUserId;
  }

  @JsonIgnore
  public MsImportAuthRequest sysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
    return this;
  }

   /**
   * 操作者姓名
   * @return sysUserName
  **/
  @ApiModelProperty(value = "操作者姓名")
  public String getSysUserName() {
    return sysUserName;
  }

  public void setSysUserName(String sysUserName) {
    this.sysUserName = sysUserName;
  }

  @JsonIgnore
  public MsImportAuthRequest groupId(Long groupId) {
    this.groupId = groupId;
    return this;
  }

   /**
   * 集团ID
   * @return groupId
  **/
  @ApiModelProperty(value = "集团ID")
  public Long getGroupId() {
    return groupId;
  }

  public void setGroupId(Long groupId) {
    this.groupId = groupId;
  }

  @JsonIgnore
  public MsImportAuthRequest orgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
    return this;
  }

  public MsImportAuthRequest addOrgIdsItem(Long orgIdsItem) {
    this.orgIds.add(orgIdsItem);
    return this;
  }

   /**
   * 所属组织Id集合
   * @return orgIds
  **/
  @ApiModelProperty(value = "所属组织Id集合")
  public List<Long> getOrgIds() {
    return orgIds;
  }

  public void setOrgIds(List<Long> orgIds) {
    this.orgIds = orgIds;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsImportAuthRequest importAuthRequest = (MsImportAuthRequest) o;
    return Objects.equals(this.ossKey, importAuthRequest.ossKey) &&
        Objects.equals(this.sysUserId, importAuthRequest.sysUserId) &&
        Objects.equals(this.sysUserName, importAuthRequest.sysUserName) &&
        Objects.equals(this.groupId, importAuthRequest.groupId) &&
        Objects.equals(this.orgIds, importAuthRequest.orgIds);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ossKey, sysUserId, sysUserName, groupId, orgIds);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsImportAuthRequest {\n");
    
    sb.append("    ossKey: ").append(toIndentedString(ossKey)).append("\n");
    sb.append("    sysUserId: ").append(toIndentedString(sysUserId)).append("\n");
    sb.append("    sysUserName: ").append(toIndentedString(sysUserName)).append("\n");
    sb.append("    groupId: ").append(toIndentedString(groupId)).append("\n");
    sb.append("    orgIds: ").append(toIndentedString(orgIds)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
