package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 自定义查询参数
 */
@ApiModel(description = "自定义查询参数")

@JsonInclude(NON_NULL)
public class MsInvoiceParam {
  @JsonProperty("paramKey")
  private String paramKey = null;

  @JsonProperty("paramValue")
  private String paramValue = null;

  @JsonProperty("paramCondition")
  private String paramCondition = null;

  @JsonIgnore
  public MsInvoiceParam paramKey(String paramKey) {
    this.paramKey = paramKey;
    return this;
  }

   /**
   * 查询参数KEY 取字段的驼峰格式命名 如:\"invoiceNo\"
   * @return paramKey
  **/
  @ApiModelProperty(value = "查询参数KEY 取字段的驼峰格式命名 如:\"invoiceNo\"")
  public String getParamKey() {
    return paramKey;
  }

  public void setParamKey(String paramKey) {
    this.paramKey = paramKey;
  }

  @JsonIgnore
  public MsInvoiceParam paramValue(String paramValue) {
    this.paramValue = paramValue;
    return this;
  }

   /**
   * 查询参数值
   * @return paramValue
  **/
  @ApiModelProperty(value = "查询参数值")
  public String getParamValue() {
    return paramValue;
  }

  public void setParamValue(String paramValue) {
    this.paramValue = paramValue;
  }

  @JsonIgnore
  public MsInvoiceParam paramCondition(String paramCondition) {
    this.paramCondition = paramCondition;
    return this;
  }

   /**
   * 查询参数条件
   * @return paramCondition
  **/
  @ApiModelProperty(value = "查询参数条件")
  public String getParamCondition() {
    return paramCondition;
  }

  public void setParamCondition(String paramCondition) {
    this.paramCondition = paramCondition;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsInvoiceParam invoiceParam = (MsInvoiceParam) o;
    return Objects.equals(this.paramKey, invoiceParam.paramKey) &&
        Objects.equals(this.paramValue, invoiceParam.paramValue) &&
        Objects.equals(this.paramCondition, invoiceParam.paramCondition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paramKey, paramValue, paramCondition);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsInvoiceParam {\n");
    
    sb.append("    paramKey: ").append(toIndentedString(paramKey)).append("\n");
    sb.append("    paramValue: ").append(toIndentedString(paramValue)).append("\n");
    sb.append("    paramCondition: ").append(toIndentedString(paramCondition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
