package com.xforceplus.phoenix.auth.client.model;

import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;
import com.fasterxml.jackson.annotation.JsonIgnore;
import javax.validation.constraints.*;

/**
 * 返回对象
 */
@ApiModel(description = "返回对象")

@JsonInclude(NON_NULL)
public class MsTaxPlateCompanyMain {
  @JsonProperty("companyTaxNo")
  private String companyTaxNo = null;

  @JsonProperty("companyName")
  private String companyName = null;

  @JsonProperty("onlineStatus")
  private Boolean onlineStatus = null;

  @JsonIgnore
  public MsTaxPlateCompanyMain companyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
    return this;
  }

   /**
   * 公司税号
   * @return companyTaxNo
  **/
  @ApiModelProperty(value = "公司税号")
  public String getCompanyTaxNo() {
    return companyTaxNo;
  }

  public void setCompanyTaxNo(String companyTaxNo) {
    this.companyTaxNo = companyTaxNo;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain companyName(String companyName) {
    this.companyName = companyName;
    return this;
  }

   /**
   * 公司名称
   * @return companyName
  **/
  @ApiModelProperty(value = "公司名称")
  public String getCompanyName() {
    return companyName;
  }

  public void setCompanyName(String companyName) {
    this.companyName = companyName;
  }

  @JsonIgnore
  public MsTaxPlateCompanyMain onlineStatus(Boolean onlineStatus) {
    this.onlineStatus = onlineStatus;
    return this;
  }

   /**
   * 在线状态true-在线，false-离线
   * @return onlineStatus
  **/
  @ApiModelProperty(value = "在线状态true-在线，false-离线")
  public Boolean getOnlineStatus() {
    return onlineStatus;
  }

  public void setOnlineStatus(Boolean onlineStatus) {
    this.onlineStatus = onlineStatus;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsTaxPlateCompanyMain taxPlateCompanyMain = (MsTaxPlateCompanyMain) o;
    return Objects.equals(this.companyTaxNo, taxPlateCompanyMain.companyTaxNo) &&
        Objects.equals(this.companyName, taxPlateCompanyMain.companyName) &&
        Objects.equals(this.onlineStatus, taxPlateCompanyMain.onlineStatus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyTaxNo, companyName, onlineStatus);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsTaxPlateCompanyMain {\n");
    
    sb.append("    companyTaxNo: ").append(toIndentedString(companyTaxNo)).append("\n");
    sb.append("    companyName: ").append(toIndentedString(companyName)).append("\n");
    sb.append("    onlineStatus: ").append(toIndentedString(onlineStatus)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
